--------------------------------------------------------------------
--       Actel A500K VITAL Library
--       NAME: a500k.vhd
--       DATE: May 17, 2006
---------------------------------------------------------------------/



library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.VITAL_Timing.all;

package COMPONENTS is

constant DefaultTimingChecksOn : Boolean := True;
constant DefaultXGenerationOn : Boolean := False;
constant DefaultXon : Boolean := False;
constant DefaultMsgOn : Boolean := True;



------ Component AND2 ------
 component AND2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND2FT ------
 component AND2FT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND3 ------
 component AND3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND3FFT ------
 component AND3FFT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND3FTT ------
 component AND3FTT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO21 ------
 component AO21
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO21FTF ------
 component AO21FTF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO21FTT ------
 component AO21FTT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO21TTF ------
 component AO21TTF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI21 ------
 component AOI21
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI21FTF ------
 component AOI21FTF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI21FTT ------
 component AOI21FTT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI21TTF ------
 component AOI21TTF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BFR ------
 component BFR
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BUBBLE ------
 component BUBBLE
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component DMUX ------
 component DMUX
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component GL25 ------
 component GL25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GL25LP ------
 component GL25LP
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GL25LPU ------
 component GL25LPU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GL25U ------
 component GL25U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GL33 ------
 component GL33
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GL33U ------
 component GL33U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GLINT ------
 component GLINT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GND ------
 component GND
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True		);
    port(
		Y		: out    STD_ULOGIC);
 end component;


------ Component IB25 ------
 component IB25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IB25LP ------
 component IB25LP
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IB25LPU ------
 component IB25LPU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IB25U ------
 component IB25U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IB33 ------
 component IB33
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IB33U ------
 component IB33U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INV ------
 component INV
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component LD ------
 component LD
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_EN_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_negedge		:VitalDelayType := 0.000 ns;
		tpw_EN_posedge		:  VitalDelayType := 0.000 ns;
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component LDB ------
 component LDB
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_SET_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_negedge		:VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		SET		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component LDBI ------
 component LDBI
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_SET_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_negedge		:VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		SET		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 end component;


------ Component LDC ------
 component LDC
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_negedge		:VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component LDCI ------
 component LDCI
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_negedge		:VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 end component;


------ Component LDI ------
 component LDI
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_EN_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_negedge		:VitalDelayType := 0.000 ns;
		tpw_EN_posedge		:  VitalDelayType := 0.000 ns;
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 end component;


------ Component LDL ------
 component LDL
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_EN_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_negedge		:  VitalDelayType := 0.000 ns;
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component LDLB ------
 component LDLB
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_SET_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_posedge		:  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_negedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		SET		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component LDLBI ------
 component LDLBI
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_SET_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_posedge		:  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_negedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		SET		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 end component;


------ Component LDLC ------
 component LDLC
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component LDLCI ------
 component LDLCI
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 end component;


------ Component LDLI ------
 component LDLI
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_EN_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_negedge		:  VitalDelayType := 0.000 ns;
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 end component;


------ Component LDLS ------
 component LDLS
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_SET_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_posedge		:  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_negedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		SET		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component LDLSI ------
 component LDLSI
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_SET_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_posedge		:  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_negedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		SET		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 end component;


------ Component LDS ------
 component LDS
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_SET_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_negedge		:VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		SET		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component LDSI ------
 component LDSI
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_SET_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_negedge		:VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		SET		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 end component;


------ Component MUX2H ------
 component MUX2H
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MUX2L ------
 component MUX2L
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND2 ------
 component NAND2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND2FT ------
 component NAND2FT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND3 ------
 component NAND3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND3FFT ------
 component NAND3FFT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND3FTT ------
 component NAND3FTT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR2 ------
 component NOR2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR2FT ------
 component NOR2FT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR3 ------
 component NOR3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR3FFT ------
 component NOR3FFT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR3FTT ------
 component NOR3FTT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NUBBLE ------
 component NUBBLE
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA21 ------
 component OA21
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA21FTF ------
 component OA21FTF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA21FTT ------
 component OA21FTT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA21TTF ------
 component OA21TTF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OAI21 ------
 component OAI21
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OAI21FTF ------
 component OAI21FTF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OAI21FTT ------
 component OAI21FTT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OAI21TTF ------
 component OAI21TTF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		C		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OB25HH ------
 component OB25HH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OB25HL ------
 component OB25HL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OB25HN ------
 component OB25HN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OB25LH ------
 component OB25LH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OB25LL ------
 component OB25LL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OB25LN ------
 component OB25LN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OB25LPHH ------
 component OB25LPHH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OB25LPHL ------
 component OB25LPHL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OB25LPHN ------
 component OB25LPHN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OB25LPLH ------
 component OB25LPLH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OB25LPLL ------
 component OB25LPLL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OB25LPLN ------
 component OB25LPLN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OB33LH ------
 component OB33LH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OB33LL ------
 component OB33LL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OB33LN ------
 component OB33LN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OB33PH ------
 component OB33PH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OB33PL ------
 component OB33PL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OB33PN ------
 component OB33PN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OR2 ------
 component OR2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR2FT ------
 component OR2FT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR3 ------
 component OR3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR3FFT ------
 component OR3FFT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR3FTT ------
 component OR3FTT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component PWR ------
 component PWR
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True		);
    port(
		Y		: out    STD_ULOGIC);
 end component;


------ Component XNOR2 ------
 component XNOR2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XNOR2FT ------
 component XNOR2FT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XOR2 ------
 component XOR2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XOR2FT ------
 component XOR2FT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component DFF ------
 component DFF
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFFB ------
 component DFFB
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_SET_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		SET		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFFBI ------
 component DFFBI
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_SET_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		SET		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 end component;


------ Component DFFC ------
 component DFFC
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFFCI ------
 component DFFCI
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 end component;


------ Component DFFI ------
 component DFFI
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 end component;


------ Component DFFL ------
 component DFFL
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFFLB ------
 component DFFLB
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_SET_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		SET		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFFLBI ------
 component DFFLBI
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_SET_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		SET		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 end component;


------ Component DFFLC ------
 component DFFLC
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFFLCI ------
 component DFFLCI
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 end component;


------ Component DFFLI ------
 component DFFLI
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 end component;


------ Component DFFLS ------
 component DFFLS
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_SET_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		SET		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFFLSI ------
 component DFFLSI
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_SET_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		SET		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 end component;


------ Component DFFS ------
 component DFFS
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_SET_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		SET		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFFSI ------
 component DFFSI
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_SET_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		SET		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 end component;


------ Component GLIB25 ------
 component GLIB25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GLIB25LP ------
 component GLIB25LP
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GLIB25LPU ------
 component GLIB25LPU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GLIB25U ------
 component GLIB25U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GLIB33 ------
 component GLIB33
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GLIB33U ------
 component GLIB33U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GLMIB25 ------
 component GLMIB25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GLMIB33 ------
 component GLMIB33
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GLMIB25LP ------
 component GLMIB25LP
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GLMIB25U ------
 component GLMIB25U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GLMIB33U ------
 component GLMIB33U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GLMIB25LPU ------
 component GLMIB25LPU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GLMIBL25 ------
 component GLMIBL25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GLMIBL33 ------
 component GLMIBL33
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GLMIBL25LP ------
 component GLMIBL25LP
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GLMIBL25LPU ------
 component GLMIBL25LPU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GLMIBL33U ------
 component GLMIBL33U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component GLMIBL25U ------
 component GLMIBL25U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 end component;


------ Component IOB25HH ------
 component IOB25HH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
       		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB25HL ------
 component IOB25HL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
                tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB25HN ------
 component IOB25HN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
                tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB25LH ------
 component IOB25LH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
                tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB25LL ------
 component IOB25LL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
                tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB25LN ------
 component IOB25LN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB25HHU ------
 component IOB25HHU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB25HLU ------
 component IOB25HLU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB25HNU ------
 component IOB25HNU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB25LHU ------
 component IOB25LHU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB25LLU ------
 component IOB25LLU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB25LNU ------
 component IOB25LNU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB25LPHH ------
 component IOB25LPHH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB25LPHL ------
 component IOB25LPHL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB25LPHN ------
 component IOB25LPHN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB25LPLH ------
 component IOB25LPLH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB25LPLL ------
 component IOB25LPLL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB25LPLN ------
 component IOB25LPLN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB25LPHHU ------
 component IOB25LPHHU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB25LPHLU ------
 component IOB25LPHLU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB25LPHNU ------
 component IOB25LPHNU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB25LPLHU ------
 component IOB25LPLHU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB25LPLLU ------
 component IOB25LPLLU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB25LPLNU ------
 component IOB25LPLNU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB33LH ------
 component IOB33LH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB33LL ------
 component IOB33LL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB33LN ------
 component IOB33LN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB33PH ------
 component IOB33PH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB33PL ------
 component IOB33PL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB33PN ------
 component IOB33PN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB33LHU ------
 component IOB33LHU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB33LLU ------
 component IOB33LLU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB33LNU ------
 component IOB33LNU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB33PHU ------
 component IOB33PHU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB33PLU ------
 component IOB33PLU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOB33PNU ------
 component IOB33PNU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25HH ------
 component IOBL25HH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25HL ------
 component IOBL25HL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25HN ------
 component IOBL25HN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25LH ------
 component IOBL25LH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25LL ------
 component IOBL25LL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25LN ------
 component IOBL25LN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25HHU ------
 component IOBL25HHU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25HLU ------
 component IOBL25HLU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25HNU ------
 component IOBL25HNU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25LHU ------
 component IOBL25LHU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25LLU ------
 component IOBL25LLU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25LNU ------
 component IOBL25LNU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25LPHH ------
 component IOBL25LPHH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25LPHL ------
 component IOBL25LPHL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25LPHN ------
 component IOBL25LPHN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25LPLH ------
 component IOBL25LPLH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25LPLL ------
 component IOBL25LPLL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25LPLN ------
 component IOBL25LPLN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25LPHHU ------
 component IOBL25LPHHU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25LPHLU ------
 component IOBL25LPHLU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25LPHNU ------
 component IOBL25LPHNU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25LPLHU ------
 component IOBL25LPLHU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25LPLLU ------
 component IOBL25LPLLU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL25LPLNU ------
 component IOBL25LPLNU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL33LH ------
 component IOBL33LH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL33LL ------
 component IOBL33LL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL33LN ------
 component IOBL33LN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL33PH ------
 component IOBL33PH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL33PL ------
 component IOBL33PL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL33PN ------
 component IOBL33PN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL33LHU ------
 component IOBL33LHU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL33LLU ------
 component IOBL33LLU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL33LNU ------
 component IOBL33LNU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL33PHU ------
 component IOBL33PHU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL33PLU ------
 component IOBL33PLU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBL33PNU ------
 component IOBL33PNU
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OTB25HH ------
 component OTB25HH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTB25HL ------
 component OTB25HL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTB25HN ------
 component OTB25HN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTB25LH ------
 component OTB25LH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTB25LL ------
 component OTB25LL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTB25LN ------
 component OTB25LN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTB25LPLH ------
 component OTB25LPLH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTB25LPLL ------
 component OTB25LPLL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTB25LPLN ------
 component OTB25LPLN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTB25LPHH ------
 component OTB25LPHH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTB25LPHL ------
 component OTB25LPHL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTB25LPHN ------
 component OTB25LPHN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTB33LH ------
 component OTB33LH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTB33LL ------
 component OTB33LL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTB33LN ------
 component OTB33LN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTB33PH ------
 component OTB33PH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTB33PL ------
 component OTB33PL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTB33PN ------
 component OTB33PN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTBL25HH ------
 component OTBL25HH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTBL25HL ------
 component OTBL25HL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTBL25HN ------
 component OTBL25HN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTBL25LH ------
 component OTBL25LH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTBL25LL ------
 component OTBL25LL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTBL25LN ------
 component OTBL25LN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTBL25LPLH ------
 component OTBL25LPLH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTBL25LPLL ------
 component OTBL25LPLL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTBL25LPLN ------
 component OTBL25LPLN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTBL25LPHH ------
 component OTBL25LPHH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTBL25LPHL ------
 component OTBL25LPHL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTBL25LPHN ------
 component OTBL25LPHN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTBL33LH ------
 component OTBL33LH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTBL33LL ------
 component OTBL33LL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTBL33LN ------
 component OTBL33LN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTBL33PH ------
 component OTBL33PH
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTBL33PL ------
 component OTBL33PL
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OTBL33PN ------
 component OTBL33PN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_EN_PAD : VitalDelayType01z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;

component RAM256x9AA
   generic (
        Xon                     : Boolean := False;
        MsgOn                   : Boolean := True;
        TimingCheckOn           : Boolean := True;
        MEMORYFILE              : String  := "";
        InstancePath            : String  := "*";

 	tipd_RADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI0_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI1_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI2_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI3_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI4_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI5_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI6_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI7_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI8_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns,0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpw_RDB_posedge	        : VitalDelayType := 0.000 ns;
 	tpw_RDB_negedge	        : VitalDelayType := 0.000 ns;
 	tperiod_RDB	        : VitalDelayType := 0.000 ns;
 	tpw_RBLKB_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RBLKB_negedge	: VitalDelayType := 0.000 ns;
 	tperiod_RBLKB	        : VitalDelayType := 0.000 ns;
 	tpw_RADDR0_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR0_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR1_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR1_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR2_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR2_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR3_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR3_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR4_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR4_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR5_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR5_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR6_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR6_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR7_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR7_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR0_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR1_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR2_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR3_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR4_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR5_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR6_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR7_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR0_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR1_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR2_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR3_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR4_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR5_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR6_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR7_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR0_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR1_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR2_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR3_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR4_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR5_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR6_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR7_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR0_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR1_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR2_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR3_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR4_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR5_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR6_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR7_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI0_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI0_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI1_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI2_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI3_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI4_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI5_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI6_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI7_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI8_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI0_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI1_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI1_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI2_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI2_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI3_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI3_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI4_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI4_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI5_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI5_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI6_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI6_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI7_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI7_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI8_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI8_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_DI0_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI0_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI1_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI1_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI2_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI2_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI3_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI3_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI4_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI4_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI5_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI5_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI6_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI6_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI7_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI7_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI8_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI8_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI0_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI0_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI1_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI1_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI2_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI2_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI3_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI3_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI4_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI4_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI5_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI5_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI6_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI6_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI7_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI7_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI8_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI8_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_posedge                       : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_negedge                       : VitalDelayType := 0.000 ns;
 	tperiod_WBLKB                           : VitalDelayType := 0.000 ns;
 	tpw_WRB_posedge                         : VitalDelayType := 0.000 ns;
 	tpw_WRB_negedge                         : VitalDelayType := 0.000 ns;
 	tperiod_WRB                             : VitalDelayType := 0.000 ns;

 	-- timing data for checking read/write at the same address, and at same time
 	tsetup_RDB_WRB_negedge_negedge          : VitalDelayType := 0.000 ns;
 	tsetup_RBLKB_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RDB_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RBLKB_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR0_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR0_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR0_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR0_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR1_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR1_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR1_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR1_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR2_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR2_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR2_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR2_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR3_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR3_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR3_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR3_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR4_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR4_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR4_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR4_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR5_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR5_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR5_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR5_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR6_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR6_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR6_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR6_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR7_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR7_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR7_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR7_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	thold_RDB_WRB_posedge_posedge           : VitalDelayType := 0.000 ns;
 	thold_RBLKB_WRB_posedge_posedge         : VitalDelayType := 0.000 ns;
 	thold_RDB_WBLKB_posedge_posedge         : VitalDelayType := 0.000 ns;
 	thold_RBLKB_WBLKB_posedge_posedge       : VitalDelayType := 0.000 ns;
 	thold_RADDR0_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR0_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR0_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
        thold_RADDR0_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR1_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR1_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR1_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
        thold_RADDR1_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR2_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR2_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR2_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
        thold_RADDR2_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR3_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR3_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR3_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
        thold_RADDR3_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR4_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR4_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR4_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
        thold_RADDR4_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR5_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR5_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR5_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
        thold_RADDR5_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR6_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR6_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR6_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
        thold_RADDR6_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR7_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR7_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR7_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
        thold_RADDR7_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns

 	);
 port (
   DO0    :  OUT STD_LOGIC := 'X';
   DO1    :  OUT STD_LOGIC := 'X';
   DO2    :  OUT STD_LOGIC := 'X';
   DO3    :  OUT STD_LOGIC := 'X';
   DO4    :  OUT STD_LOGIC := 'X';
   DO5    :  OUT STD_LOGIC := 'X';
   DO6    :  OUT STD_LOGIC := 'X';
   DO7    :  OUT STD_LOGIC := 'X';
   DO8    :  OUT STD_LOGIC := 'X';
   DOS    :  OUT STD_LOGIC := 'X';
   WPE    :  OUT STD_LOGIC := 'X';
   RPE    :  OUT STD_LOGIC := 'X';

   WADDR0 :  IN STD_LOGIC := 'X';
   WADDR1 :  IN STD_LOGIC := 'X';
   WADDR2 :  IN STD_LOGIC := 'X';
   WADDR3 :  IN STD_LOGIC := 'X';
   WADDR4 :  IN STD_LOGIC := 'X';
   WADDR5 :  IN STD_LOGIC := 'X';
   WADDR6 :  IN STD_LOGIC := 'X';
   WADDR7 :  IN STD_LOGIC := 'X';
   RADDR0 :  IN STD_LOGIC := 'X';
   RADDR1 :  IN STD_LOGIC := 'X';
   RADDR2 :  IN STD_LOGIC := 'X';
   RADDR3 :  IN STD_LOGIC := 'X';
   RADDR4 :  IN STD_LOGIC := 'X';
   RADDR5 :  IN STD_LOGIC := 'X';
   RADDR6 :  IN STD_LOGIC := 'X';
   RADDR7 :  IN STD_LOGIC := 'X';
   DI0    :  IN STD_LOGIC := 'X';
   DI1    :  IN STD_LOGIC := 'X';
   DI2    :  IN STD_LOGIC := 'X';
   DI3    :  IN STD_LOGIC := 'X';
   DI4    :  IN STD_LOGIC := 'X';
   DI5    :  IN STD_LOGIC := 'X';
   DI6    :  IN STD_LOGIC := 'X';
   DI7    :  IN STD_LOGIC := 'X';
   DI8    :  IN STD_LOGIC := 'X';
   WRB    :  IN STD_LOGIC := 'X';
   RDB    :  IN STD_LOGIC := 'X';
   WBLKB  :  IN STD_LOGIC := 'X';
   RBLKB  :  IN STD_LOGIC := 'X';
   PARODD :  IN STD_LOGIC := 'X';
   DIS    :  IN STD_LOGIC := 'X');
end component;

component RAM256x9AAP
   generic (
        Xon                     : Boolean := False;
        MsgOn                   : Boolean := True;
        TimingCheckOn           : Boolean := True;
        MEMORYFILE              : String  := "";
        InstancePath            : String  := "*";

 	tipd_RADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpw_RDB_posedge	        : VitalDelayType := 0.000 ns;
 	tpw_RDB_negedge	        : VitalDelayType := 0.000 ns;
 	tperiod_RDB	        : VitalDelayType := 0.000 ns;
 	tpw_RBLKB_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RBLKB_negedge	: VitalDelayType := 0.000 ns;
 	tperiod_RBLKB	        : VitalDelayType := 0.000 ns;
 	tpw_RADDR0_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR0_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR1_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR1_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR2_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR2_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR3_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR3_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR4_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR4_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR5_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR5_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR6_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR6_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR7_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR7_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR0_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR1_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR2_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR3_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR4_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR5_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR6_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR7_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR0_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR1_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR2_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR3_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR4_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR5_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR6_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR7_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR0_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR1_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR2_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR3_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR4_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR5_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR6_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR7_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR0_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR1_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR2_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR3_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR4_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR5_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR6_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR7_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI0_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI0_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI1_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI2_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI3_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI4_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI5_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI6_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI7_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI8_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI0_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI1_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI1_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI2_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI2_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI3_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI3_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI4_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI4_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI5_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI5_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI6_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI6_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI7_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI7_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI8_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI8_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_DI0_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI0_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI1_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI1_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI2_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI2_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI3_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI3_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI4_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI4_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI5_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI5_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI6_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI6_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI7_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI7_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI8_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI8_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI0_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI0_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI1_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI1_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI2_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI2_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI3_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI3_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI4_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI4_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI5_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI5_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI6_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI6_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI7_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI7_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI8_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI8_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_posedge                       : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_negedge                       : VitalDelayType := 0.000 ns;
 	tperiod_WBLKB                           : VitalDelayType := 0.000 ns;
 	tpw_WRB_posedge                         : VitalDelayType := 0.000 ns;
 	tpw_WRB_negedge                         : VitalDelayType := 0.000 ns;
 	tperiod_WRB                             : VitalDelayType := 0.000 ns;

 	-- timing data for checking read/write at the same address, and at same time
 	tsetup_RDB_WRB_negedge_negedge          : VitalDelayType := 0.000 ns;
 	tsetup_RBLKB_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RDB_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RBLKB_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR0_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR0_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR0_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR0_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR1_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR1_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR1_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR1_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR2_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR2_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR2_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR2_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR3_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR3_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR3_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR3_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR4_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR4_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR4_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR4_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR5_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR5_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR5_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR5_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR6_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR6_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR6_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR6_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR7_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR7_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR7_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR7_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	thold_RDB_WRB_posedge_posedge           : VitalDelayType := 0.000 ns;
 	thold_RBLKB_WRB_posedge_posedge         : VitalDelayType := 0.000 ns;
 	thold_RDB_WBLKB_posedge_posedge         : VitalDelayType := 0.000 ns;
 	thold_RBLKB_WBLKB_posedge_posedge       : VitalDelayType := 0.000 ns;
 	thold_RADDR0_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR0_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR0_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
        thold_RADDR0_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR1_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR1_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR1_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
        thold_RADDR1_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR2_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR2_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR2_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
        thold_RADDR2_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR3_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR3_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR3_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
        thold_RADDR3_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR4_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR4_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR4_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
        thold_RADDR4_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR5_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR5_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR5_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
        thold_RADDR5_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR6_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR6_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR6_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
        thold_RADDR6_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR7_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR7_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR7_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
        thold_RADDR7_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns

 	);
 port (
   DO0    :  OUT STD_LOGIC := 'X';
   DO1    :  OUT STD_LOGIC := 'X';
   DO2    :  OUT STD_LOGIC := 'X';
   DO3    :  OUT STD_LOGIC := 'X';
   DO4    :  OUT STD_LOGIC := 'X';
   DO5    :  OUT STD_LOGIC := 'X';
   DO6    :  OUT STD_LOGIC := 'X';
   DO7    :  OUT STD_LOGIC := 'X';
   DO8    :  OUT STD_LOGIC := 'X';
   DOS    :  OUT STD_LOGIC := 'X';

   WADDR0 :  IN STD_LOGIC := 'X';
   WADDR1 :  IN STD_LOGIC := 'X';
   WADDR2 :  IN STD_LOGIC := 'X';
   WADDR3 :  IN STD_LOGIC := 'X';
   WADDR4 :  IN STD_LOGIC := 'X';
   WADDR5 :  IN STD_LOGIC := 'X';
   WADDR6 :  IN STD_LOGIC := 'X';
   WADDR7 :  IN STD_LOGIC := 'X';
   RADDR0 :  IN STD_LOGIC := 'X';
   RADDR1 :  IN STD_LOGIC := 'X';
   RADDR2 :  IN STD_LOGIC := 'X';
   RADDR3 :  IN STD_LOGIC := 'X';
   RADDR4 :  IN STD_LOGIC := 'X';
   RADDR5 :  IN STD_LOGIC := 'X';
   RADDR6 :  IN STD_LOGIC := 'X';
   RADDR7 :  IN STD_LOGIC := 'X';
   DI0    :  IN STD_LOGIC := 'X';
   DI1    :  IN STD_LOGIC := 'X';
   DI2    :  IN STD_LOGIC := 'X';
   DI3    :  IN STD_LOGIC := 'X';
   DI4    :  IN STD_LOGIC := 'X';
   DI5    :  IN STD_LOGIC := 'X';
   DI6    :  IN STD_LOGIC := 'X';
   DI7    :  IN STD_LOGIC := 'X';
   DI8    :  IN STD_LOGIC := 'X';
   WRB    :  IN STD_LOGIC := 'X';
   RDB    :  IN STD_LOGIC := 'X';
   WBLKB  :  IN STD_LOGIC := 'X';
   RBLKB  :  IN STD_LOGIC := 'X';
   PARODD :  IN STD_LOGIC := 'X';
   DIS    :  IN STD_LOGIC := 'X');
end component;

component RAM256x9AST
   generic (
        Xon                     : Boolean := False;
        MsgOn                   : Boolean := True;
        TimingCheckOn           : Boolean := True;
        MEMORYFILE              : String  := "";
        InstancePath            : String  := "*";

 	tipd_RADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI0_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI1_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI2_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI3_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI4_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI5_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI6_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI7_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI8_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tsetup_RADDR0_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR0_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR1_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR1_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR2_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR2_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR3_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR3_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR4_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR4_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR5_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR5_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR6_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR6_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR7_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR7_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RDB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RDB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RBLKB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RBLKB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR0_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR0_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR1_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR1_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR2_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR2_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR3_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR3_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR4_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR4_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR5_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR5_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR6_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR6_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR7_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR7_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RDB_RCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_RDB_RCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_RBLKB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RBLKB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	tpw_RCLKS_posedge	                : VitalDelayType := 0.000 ns;
 	tpw_RCLKS_negedge	                : VitalDelayType := 0.000 ns;
 	tperiod_RCLKS	                        : VitalDelayType := 0.000 ns;
 	tsetup_WADDR0_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR1_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR2_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR3_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR4_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR5_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR6_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR7_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR0_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR1_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR2_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR3_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR4_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR5_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR6_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR7_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR0_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR1_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR2_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR3_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR4_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR5_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR6_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR7_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR0_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR1_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR2_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR3_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR4_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR5_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR6_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR7_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI0_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI0_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI1_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI2_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI3_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI4_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI5_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI6_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI7_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI8_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI0_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI1_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI1_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI2_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI2_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI3_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI3_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI4_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI4_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI5_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI5_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI6_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI6_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI7_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI7_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI8_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI8_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_DI0_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI0_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI1_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI1_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI2_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI2_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI3_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI3_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI4_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI4_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI5_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI5_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI6_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI6_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI7_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI7_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI8_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI8_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI0_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI0_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI1_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI1_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI2_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI2_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI3_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI3_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI4_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI4_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI5_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI5_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI6_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI6_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI7_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI7_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI8_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI8_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_posedge                       : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_negedge                       : VitalDelayType := 0.000 ns;
 	tperiod_WBLKB                           : VitalDelayType := 0.000 ns;
 	tpw_WRB_posedge                         : VitalDelayType := 0.000 ns;
 	tpw_WRB_negedge                         : VitalDelayType := 0.000 ns;
 	tperiod_WRB                             : VitalDelayType := 0.000 ns;

 	-- timing data for checking read/write at the same address, and at same time
 	tsetup_WRB_RCLKS_negedge_posedge        : VitalDelayType := 0.000 ns;
 	thold_WRB_RCLKS_negedge_posedge         : VitalDelayType := 0.000 ns;
 	tsetup_WBLKB_RCLKS_negedge_posedge      : VitalDelayType := 0.000 ns;
	thold_WBLKB_RCLKS_negedge_posedge       : VitalDelayType := 0.000 ns

 	);
 port (
   DO0    :  OUT STD_LOGIC := 'X';
   DO1    :  OUT STD_LOGIC := 'X';
   DO2    :  OUT STD_LOGIC := 'X';
   DO3    :  OUT STD_LOGIC := 'X';
   DO4    :  OUT STD_LOGIC := 'X';
   DO5    :  OUT STD_LOGIC := 'X';
   DO6    :  OUT STD_LOGIC := 'X';
   DO7    :  OUT STD_LOGIC := 'X';
   DO8    :  OUT STD_LOGIC := 'X';
   DOS    :  OUT STD_LOGIC := 'X';
   WPE    :  OUT STD_LOGIC := 'X';
   RPE    :  OUT STD_LOGIC := 'X';

   WADDR0 :  IN STD_LOGIC := 'X';
   WADDR1 :  IN STD_LOGIC := 'X';
   WADDR2 :  IN STD_LOGIC := 'X';
   WADDR3 :  IN STD_LOGIC := 'X';
   WADDR4 :  IN STD_LOGIC := 'X';
   WADDR5 :  IN STD_LOGIC := 'X';
   WADDR6 :  IN STD_LOGIC := 'X';
   WADDR7 :  IN STD_LOGIC := 'X';
   RADDR0 :  IN STD_LOGIC := 'X';
   RADDR1 :  IN STD_LOGIC := 'X';
   RADDR2 :  IN STD_LOGIC := 'X';
   RADDR3 :  IN STD_LOGIC := 'X';
   RADDR4 :  IN STD_LOGIC := 'X';
   RADDR5 :  IN STD_LOGIC := 'X';
   RADDR6 :  IN STD_LOGIC := 'X';
   RADDR7 :  IN STD_LOGIC := 'X';
   DI0    :  IN STD_LOGIC := 'X';
   DI1    :  IN STD_LOGIC := 'X';
   DI2    :  IN STD_LOGIC := 'X';
   DI3    :  IN STD_LOGIC := 'X';
   DI4    :  IN STD_LOGIC := 'X';
   DI5    :  IN STD_LOGIC := 'X';
   DI6    :  IN STD_LOGIC := 'X';
   DI7    :  IN STD_LOGIC := 'X';
   DI8    :  IN STD_LOGIC := 'X';
   WRB    :  IN STD_LOGIC := 'X';
   RDB    :  IN STD_LOGIC := 'X';
   WBLKB  :  IN STD_LOGIC := 'X';
   RBLKB  :  IN STD_LOGIC := 'X';
   PARODD :  IN STD_LOGIC := 'X';
   RCLKS   :  IN STD_LOGIC := 'X';
   DIS    :  IN STD_LOGIC := 'X');
end component;

component RAM256x9ASTP
   generic (
        Xon                     : Boolean := False;
        MsgOn                   : Boolean := True;
        TimingCheckOn           : Boolean := True;
        MEMORYFILE              : String  := "";
        InstancePath            : String  := "*";

 	tipd_RADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tsetup_RADDR0_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR0_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR1_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR1_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR2_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR2_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR3_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR3_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR4_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR4_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR5_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR5_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR6_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR6_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR7_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR7_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RDB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RDB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RBLKB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RBLKB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR0_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR0_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR1_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR1_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR2_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR2_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR3_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR3_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR4_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR4_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR5_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR5_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR6_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR6_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR7_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR7_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RDB_RCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_RDB_RCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_RBLKB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RBLKB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	tpw_RCLKS_posedge	                : VitalDelayType := 0.000 ns;
 	tpw_RCLKS_negedge	                : VitalDelayType := 0.000 ns;
 	tperiod_RCLKS	                        : VitalDelayType := 0.000 ns;
 	tsetup_WADDR0_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR1_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR2_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR3_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR4_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR5_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR6_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR7_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR0_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR1_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR2_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR3_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR4_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR5_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR6_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR7_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR0_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR1_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR2_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR3_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR4_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR5_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR6_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR7_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR0_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR1_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR2_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR3_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR4_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR5_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR6_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR7_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI0_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI0_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI1_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI2_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI3_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI4_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI5_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI6_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI7_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI8_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI0_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI1_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI1_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI2_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI2_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI3_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI3_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI4_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI4_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI5_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI5_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI6_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI6_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI7_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI7_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI8_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI8_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_DI0_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI0_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI1_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI1_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI2_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI2_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI3_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI3_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI4_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI4_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI5_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI5_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI6_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI6_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI7_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI7_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI8_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI8_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI0_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI0_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI1_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI1_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI2_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI2_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI3_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI3_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI4_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI4_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI5_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI5_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI6_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI6_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI7_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI7_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI8_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI8_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_posedge                       : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_negedge                       : VitalDelayType := 0.000 ns;
 	tperiod_WBLKB                           : VitalDelayType := 0.000 ns;
 	tpw_WRB_posedge                         : VitalDelayType := 0.000 ns;
 	tpw_WRB_negedge                         : VitalDelayType := 0.000 ns;
 	tperiod_WRB                             : VitalDelayType := 0.000 ns;

 	-- timing data for checking read/write at the same address, and at same time
 	tsetup_WRB_RCLKS_negedge_posedge        : VitalDelayType := 0.000 ns;
 	thold_WRB_RCLKS_negedge_posedge         : VitalDelayType := 0.000 ns;
 	tsetup_WBLKB_RCLKS_negedge_posedge      : VitalDelayType := 0.000 ns;
	thold_WBLKB_RCLKS_negedge_posedge       : VitalDelayType := 0.000 ns

 	);
 port (
   DO0    :  OUT STD_LOGIC := 'X';
   DO1    :  OUT STD_LOGIC := 'X';
   DO2    :  OUT STD_LOGIC := 'X';
   DO3    :  OUT STD_LOGIC := 'X';
   DO4    :  OUT STD_LOGIC := 'X';
   DO5    :  OUT STD_LOGIC := 'X';
   DO6    :  OUT STD_LOGIC := 'X';
   DO7    :  OUT STD_LOGIC := 'X';
   DO8    :  OUT STD_LOGIC := 'X';
   DOS    :  OUT STD_LOGIC := 'X';

   WADDR0 :  IN STD_LOGIC := 'X';
   WADDR1 :  IN STD_LOGIC := 'X';
   WADDR2 :  IN STD_LOGIC := 'X';
   WADDR3 :  IN STD_LOGIC := 'X';
   WADDR4 :  IN STD_LOGIC := 'X';
   WADDR5 :  IN STD_LOGIC := 'X';
   WADDR6 :  IN STD_LOGIC := 'X';
   WADDR7 :  IN STD_LOGIC := 'X';
   RADDR0 :  IN STD_LOGIC := 'X';
   RADDR1 :  IN STD_LOGIC := 'X';
   RADDR2 :  IN STD_LOGIC := 'X';
   RADDR3 :  IN STD_LOGIC := 'X';
   RADDR4 :  IN STD_LOGIC := 'X';
   RADDR5 :  IN STD_LOGIC := 'X';
   RADDR6 :  IN STD_LOGIC := 'X';
   RADDR7 :  IN STD_LOGIC := 'X';
   DI0    :  IN STD_LOGIC := 'X';
   DI1    :  IN STD_LOGIC := 'X';
   DI2    :  IN STD_LOGIC := 'X';
   DI3    :  IN STD_LOGIC := 'X';
   DI4    :  IN STD_LOGIC := 'X';
   DI5    :  IN STD_LOGIC := 'X';
   DI6    :  IN STD_LOGIC := 'X';
   DI7    :  IN STD_LOGIC := 'X';
   DI8    :  IN STD_LOGIC := 'X';
   WRB    :  IN STD_LOGIC := 'X';
   RDB    :  IN STD_LOGIC := 'X';
   WBLKB  :  IN STD_LOGIC := 'X';
   RBLKB  :  IN STD_LOGIC := 'X';
   PARODD :  IN STD_LOGIC := 'X';
   RCLKS   :  IN STD_LOGIC := 'X';
   DIS    :  IN STD_LOGIC := 'X');
end component;

component RAM256x9ASR
   generic (
        Xon                     : Boolean := False;
        MsgOn                   : Boolean := True;
        TimingCheckOn           : Boolean := True;
        MEMORYFILE              : String  := "";
        InstancePath            : String  := "*";

 	tipd_RADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI0_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI1_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI2_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI3_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI4_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI5_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI6_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI7_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI8_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tsetup_RADDR0_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR0_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR1_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR1_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR2_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR2_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR3_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR3_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR4_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR4_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR5_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR5_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR6_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR6_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR7_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR7_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RDB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RDB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RBLKB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RBLKB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR0_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR0_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR1_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR1_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR2_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR2_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR3_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR3_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR4_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR4_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR5_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR5_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR6_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR6_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR7_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR7_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RDB_RCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_RDB_RCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_RBLKB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RBLKB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	tpw_RCLKS_posedge	                : VitalDelayType := 0.000 ns;
 	tpw_RCLKS_negedge	                : VitalDelayType := 0.000 ns;
 	tperiod_RCLKS	                        : VitalDelayType := 0.000 ns;
 	tsetup_WADDR0_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR1_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR2_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR3_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR4_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR5_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR6_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR7_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR0_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR1_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR2_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR3_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR4_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR5_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR6_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR7_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR0_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR1_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR2_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR3_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR4_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR5_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR6_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR7_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR0_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR1_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR2_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR3_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR4_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR5_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR6_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR7_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI0_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI0_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI1_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI2_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI3_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI4_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI5_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI6_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI7_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI8_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI0_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI1_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI1_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI2_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI2_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI3_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI3_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI4_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI4_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI5_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI5_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI6_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI6_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI7_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI7_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI8_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI8_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_DI0_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI0_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI1_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI1_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI2_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI2_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI3_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI3_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI4_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI4_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI5_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI5_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI6_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI6_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI7_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI7_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI8_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI8_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI0_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI0_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI1_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI1_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI2_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI2_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI3_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI3_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI4_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI4_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI5_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI5_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI6_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI6_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI7_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI7_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI8_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI8_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_posedge                       : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_negedge                       : VitalDelayType := 0.000 ns;
 	tperiod_WBLKB                           : VitalDelayType := 0.000 ns;
 	tpw_WRB_posedge                         : VitalDelayType := 0.000 ns;
 	tpw_WRB_negedge                         : VitalDelayType := 0.000 ns;
 	tperiod_WRB                             : VitalDelayType := 0.000 ns;

 	-- timing data for checking read/write at the same address, and at same time
 	tsetup_WRB_RCLKS_negedge_posedge        : VitalDelayType := 0.000 ns;
 	thold_WRB_RCLKS_negedge_posedge         : VitalDelayType := 0.000 ns;
 	tsetup_WBLKB_RCLKS_negedge_posedge      : VitalDelayType := 0.000 ns;
	thold_WBLKB_RCLKS_negedge_posedge       : VitalDelayType := 0.000 ns

 	);
 port (
   DO0    :  OUT STD_LOGIC := 'X';
   DO1    :  OUT STD_LOGIC := 'X';
   DO2    :  OUT STD_LOGIC := 'X';
   DO3    :  OUT STD_LOGIC := 'X';
   DO4    :  OUT STD_LOGIC := 'X';
   DO5    :  OUT STD_LOGIC := 'X';
   DO6    :  OUT STD_LOGIC := 'X';
   DO7    :  OUT STD_LOGIC := 'X';
   DO8    :  OUT STD_LOGIC := 'X';
   DOS    :  OUT STD_LOGIC := 'X';
   WPE    :  OUT STD_LOGIC := 'X';
   RPE    :  OUT STD_LOGIC := 'X';

   WADDR0 :  IN STD_LOGIC := 'X';
   WADDR1 :  IN STD_LOGIC := 'X';
   WADDR2 :  IN STD_LOGIC := 'X';
   WADDR3 :  IN STD_LOGIC := 'X';
   WADDR4 :  IN STD_LOGIC := 'X';
   WADDR5 :  IN STD_LOGIC := 'X';
   WADDR6 :  IN STD_LOGIC := 'X';
   WADDR7 :  IN STD_LOGIC := 'X';
   RADDR0 :  IN STD_LOGIC := 'X';
   RADDR1 :  IN STD_LOGIC := 'X';
   RADDR2 :  IN STD_LOGIC := 'X';
   RADDR3 :  IN STD_LOGIC := 'X';
   RADDR4 :  IN STD_LOGIC := 'X';
   RADDR5 :  IN STD_LOGIC := 'X';
   RADDR6 :  IN STD_LOGIC := 'X';
   RADDR7 :  IN STD_LOGIC := 'X';
   DI0    :  IN STD_LOGIC := 'X';
   DI1    :  IN STD_LOGIC := 'X';
   DI2    :  IN STD_LOGIC := 'X';
   DI3    :  IN STD_LOGIC := 'X';
   DI4    :  IN STD_LOGIC := 'X';
   DI5    :  IN STD_LOGIC := 'X';
   DI6    :  IN STD_LOGIC := 'X';
   DI7    :  IN STD_LOGIC := 'X';
   DI8    :  IN STD_LOGIC := 'X';
   WRB    :  IN STD_LOGIC := 'X';
   RDB    :  IN STD_LOGIC := 'X';
   WBLKB  :  IN STD_LOGIC := 'X';
   RBLKB  :  IN STD_LOGIC := 'X';
   PARODD :  IN STD_LOGIC := 'X';
   RCLKS   :  IN STD_LOGIC := 'X';
   DIS    :  IN STD_LOGIC := 'X');
end component;

component RAM256x9ASRP
   generic (
        Xon                     : Boolean := False;
        MsgOn                   : Boolean := True;
        TimingCheckOn           : Boolean := True;
        MEMORYFILE              : String  := "";
        InstancePath            : String  := "*";

 	tipd_RADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tsetup_RADDR0_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR0_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR1_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR1_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR2_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR2_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR3_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR3_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR4_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR4_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR5_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR5_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR6_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR6_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR7_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR7_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RDB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RDB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RBLKB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RBLKB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR0_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR0_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR1_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR1_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR2_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR2_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR3_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR3_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR4_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR4_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR5_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR5_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR6_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR6_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR7_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR7_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RDB_RCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_RDB_RCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_RBLKB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RBLKB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	tpw_RCLKS_posedge	                : VitalDelayType := 0.000 ns;
 	tpw_RCLKS_negedge	                : VitalDelayType := 0.000 ns;
 	tperiod_RCLKS	                        : VitalDelayType := 0.000 ns;
 	tsetup_WADDR0_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR1_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR2_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR3_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR4_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR5_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR6_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR7_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WRB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WRB_negedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR0_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR1_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR2_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR3_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR4_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR5_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR6_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR7_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WBLKB_negedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WBLKB_posedge_negedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR0_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR1_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR2_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR3_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR4_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR5_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR6_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR7_WRB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WRB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR0_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR1_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR2_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR3_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR4_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR5_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR6_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR7_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI0_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI0_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI1_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI2_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI3_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI4_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI5_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI6_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI7_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tsetup_DI8_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI0_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI1_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI1_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI2_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI2_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI3_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI3_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI4_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI4_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI5_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI5_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI6_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI6_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI7_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI7_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI8_WBLKB_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI8_WBLKB_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_DI0_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI0_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI1_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI1_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI2_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI2_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI3_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI3_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI4_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI4_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI5_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI5_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI6_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI6_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI7_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI7_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI8_WRB_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI8_WRB_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI0_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI0_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI1_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI1_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI2_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI2_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI3_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI3_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI4_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI4_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI5_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI5_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI6_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI6_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI7_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI7_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI8_WBLKB_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI8_WBLKB_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_posedge                       : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_negedge                       : VitalDelayType := 0.000 ns;
 	tperiod_WBLKB                           : VitalDelayType := 0.000 ns;
 	tpw_WRB_posedge                         : VitalDelayType := 0.000 ns;
 	tpw_WRB_negedge                         : VitalDelayType := 0.000 ns;
 	tperiod_WRB                             : VitalDelayType := 0.000 ns;

 	-- timing data for checking read/write at the same address, and at same time
 	tsetup_WRB_RCLKS_negedge_posedge        : VitalDelayType := 0.000 ns;
 	thold_WRB_RCLKS_negedge_posedge         : VitalDelayType := 0.000 ns;
 	tsetup_WBLKB_RCLKS_negedge_posedge      : VitalDelayType := 0.000 ns;
	thold_WBLKB_RCLKS_negedge_posedge       : VitalDelayType := 0.000 ns

 	);
 port (
   DO0    :  OUT STD_LOGIC := 'X';
   DO1    :  OUT STD_LOGIC := 'X';
   DO2    :  OUT STD_LOGIC := 'X';
   DO3    :  OUT STD_LOGIC := 'X';
   DO4    :  OUT STD_LOGIC := 'X';
   DO5    :  OUT STD_LOGIC := 'X';
   DO6    :  OUT STD_LOGIC := 'X';
   DO7    :  OUT STD_LOGIC := 'X';
   DO8    :  OUT STD_LOGIC := 'X';
   DOS    :  OUT STD_LOGIC := 'X';

   WADDR0 :  IN STD_LOGIC := 'X';
   WADDR1 :  IN STD_LOGIC := 'X';
   WADDR2 :  IN STD_LOGIC := 'X';
   WADDR3 :  IN STD_LOGIC := 'X';
   WADDR4 :  IN STD_LOGIC := 'X';
   WADDR5 :  IN STD_LOGIC := 'X';
   WADDR6 :  IN STD_LOGIC := 'X';
   WADDR7 :  IN STD_LOGIC := 'X';
   RADDR0 :  IN STD_LOGIC := 'X';
   RADDR1 :  IN STD_LOGIC := 'X';
   RADDR2 :  IN STD_LOGIC := 'X';
   RADDR3 :  IN STD_LOGIC := 'X';
   RADDR4 :  IN STD_LOGIC := 'X';
   RADDR5 :  IN STD_LOGIC := 'X';
   RADDR6 :  IN STD_LOGIC := 'X';
   RADDR7 :  IN STD_LOGIC := 'X';
   DI0    :  IN STD_LOGIC := 'X';
   DI1    :  IN STD_LOGIC := 'X';
   DI2    :  IN STD_LOGIC := 'X';
   DI3    :  IN STD_LOGIC := 'X';
   DI4    :  IN STD_LOGIC := 'X';
   DI5    :  IN STD_LOGIC := 'X';
   DI6    :  IN STD_LOGIC := 'X';
   DI7    :  IN STD_LOGIC := 'X';
   DI8    :  IN STD_LOGIC := 'X';
   WRB    :  IN STD_LOGIC := 'X';
   RDB    :  IN STD_LOGIC := 'X';
   WBLKB  :  IN STD_LOGIC := 'X';
   RBLKB  :  IN STD_LOGIC := 'X';
   PARODD :  IN STD_LOGIC := 'X';
   RCLKS   :  IN STD_LOGIC := 'X';
   DIS    :  IN STD_LOGIC := 'X');
end component;

component RAM256x9SA
   generic (
        Xon                     : Boolean := False;
        MsgOn                   : Boolean := True;
        TimingCheckOn           : Boolean := True;
        MEMORYFILE              : String  := "";
        InstancePath            : String  := "*";

 	tipd_RADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_WCLKS_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns,0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpw_RDB_posedge	        : VitalDelayType := 0.000 ns;
 	tpw_RDB_negedge	        : VitalDelayType := 0.000 ns;
 	tperiod_RDB	        : VitalDelayType := 0.000 ns;
 	tpw_RBLKB_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RBLKB_negedge	: VitalDelayType := 0.000 ns;
 	tperiod_RBLKB	        : VitalDelayType := 0.000 ns;
 	tpw_RADDR0_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR0_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR1_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR1_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR2_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR2_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR3_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR3_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR4_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR4_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR5_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR5_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR6_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR6_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR7_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR7_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR0_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR1_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR2_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR3_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR4_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR5_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR6_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR7_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WRB_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WRB_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WBLKB_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WBLKB_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI0_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI0_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI1_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI1_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI2_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI2_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI3_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI3_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI4_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI4_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI5_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI5_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI6_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI6_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI7_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI7_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI8_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI8_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR0_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR1_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR2_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR3_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR4_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR5_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR6_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR7_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WRB_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_WRB_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_WBLKB_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WBLKB_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_DI0_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI0_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI1_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI1_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI2_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI2_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI3_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI3_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI4_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI4_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI5_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI5_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI6_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI6_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI7_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI7_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI8_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI8_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tpw_WCLKS_posedge                       : VitalDelayType := 0.000 ns;
 	tpw_WCLKS_negedge                       : VitalDelayType := 0.000 ns;
 	tperiod_WCLKS                           : VitalDelayType := 0.000 ns;

 	-- timing data for checking read/write at the same address, and at same time
 	tsetup_RDB_WCLKS_negedge_posedge       : VitalDelayType := 0.000 ns;
 	tsetup_RBLKB_WCLKS_negedge_posedge       : VitalDelayType := 0.000 ns;
 	tsetup_RADDR0_WCLKS_negedge_posedge     : VitalDelayType := 0.000 ns;
	tsetup_RADDR0_WCLKS_posedge_posedge     : VitalDelayType := 0.000 ns;
 	tsetup_RADDR1_WCLKS_negedge_posedge     : VitalDelayType := 0.000 ns;
	tsetup_RADDR1_WCLKS_posedge_posedge     : VitalDelayType := 0.000 ns;
 	tsetup_RADDR2_WCLKS_negedge_posedge     : VitalDelayType := 0.000 ns;
	tsetup_RADDR2_WCLKS_posedge_posedge     : VitalDelayType := 0.000 ns;
 	tsetup_RADDR3_WCLKS_negedge_posedge     : VitalDelayType := 0.000 ns;
	tsetup_RADDR3_WCLKS_posedge_posedge     : VitalDelayType := 0.000 ns;
 	tsetup_RADDR4_WCLKS_negedge_posedge     : VitalDelayType := 0.000 ns;
	tsetup_RADDR4_WCLKS_posedge_posedge     : VitalDelayType := 0.000 ns;
 	tsetup_RADDR5_WCLKS_negedge_posedge     : VitalDelayType := 0.000 ns;
	tsetup_RADDR5_WCLKS_posedge_posedge     : VitalDelayType := 0.000 ns;
 	tsetup_RADDR6_WCLKS_negedge_posedge     : VitalDelayType := 0.000 ns;
	tsetup_RADDR6_WCLKS_posedge_posedge     : VitalDelayType := 0.000 ns;
 	tsetup_RADDR7_WCLKS_negedge_posedge     : VitalDelayType := 0.000 ns;
	tsetup_RADDR7_WCLKS_posedge_posedge     : VitalDelayType := 0.000 ns;
 	thold_RDB_WCLKS_posedge_negedge	: VitalDelayType := 0.000 ns;
 	thold_RBLKB_WCLKS_posedge_negedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR0_WCLKS_negedge_negedge	: VitalDelayType := 0.000 ns;
        thold_RADDR0_WCLKS_posedge_negedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR1_WCLKS_negedge_negedge	: VitalDelayType := 0.000 ns;
        thold_RADDR1_WCLKS_posedge_negedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR2_WCLKS_negedge_negedge	: VitalDelayType := 0.000 ns;
        thold_RADDR2_WCLKS_posedge_negedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR3_WCLKS_negedge_negedge	: VitalDelayType := 0.000 ns;
        thold_RADDR3_WCLKS_posedge_negedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR4_WCLKS_negedge_negedge	: VitalDelayType := 0.000 ns;
        thold_RADDR4_WCLKS_posedge_negedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR5_WCLKS_negedge_negedge	: VitalDelayType := 0.000 ns;
        thold_RADDR5_WCLKS_posedge_negedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR6_WCLKS_negedge_negedge	: VitalDelayType := 0.000 ns;
        thold_RADDR6_WCLKS_posedge_negedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR7_WCLKS_negedge_negedge	: VitalDelayType := 0.000 ns;
        thold_RADDR7_WCLKS_posedge_negedge	: VitalDelayType := 0.000 ns

 	);
 port (
   DO0    :  OUT STD_LOGIC := 'X';
   DO1    :  OUT STD_LOGIC := 'X';
   DO2    :  OUT STD_LOGIC := 'X';
   DO3    :  OUT STD_LOGIC := 'X';
   DO4    :  OUT STD_LOGIC := 'X';
   DO5    :  OUT STD_LOGIC := 'X';
   DO6    :  OUT STD_LOGIC := 'X';
   DO7    :  OUT STD_LOGIC := 'X';
   DO8    :  OUT STD_LOGIC := 'X';
   DOS    :  OUT STD_LOGIC := 'X';
   WPE    :  OUT STD_LOGIC := 'X';
   RPE    :  OUT STD_LOGIC := 'X';

   WADDR0 :  IN STD_LOGIC := 'X';
   WADDR1 :  IN STD_LOGIC := 'X';
   WADDR2 :  IN STD_LOGIC := 'X';
   WADDR3 :  IN STD_LOGIC := 'X';
   WADDR4 :  IN STD_LOGIC := 'X';
   WADDR5 :  IN STD_LOGIC := 'X';
   WADDR6 :  IN STD_LOGIC := 'X';
   WADDR7 :  IN STD_LOGIC := 'X';
   RADDR0 :  IN STD_LOGIC := 'X';
   RADDR1 :  IN STD_LOGIC := 'X';
   RADDR2 :  IN STD_LOGIC := 'X';
   RADDR3 :  IN STD_LOGIC := 'X';
   RADDR4 :  IN STD_LOGIC := 'X';
   RADDR5 :  IN STD_LOGIC := 'X';
   RADDR6 :  IN STD_LOGIC := 'X';
   RADDR7 :  IN STD_LOGIC := 'X';
   DI0    :  IN STD_LOGIC := 'X';
   DI1    :  IN STD_LOGIC := 'X';
   DI2    :  IN STD_LOGIC := 'X';
   DI3    :  IN STD_LOGIC := 'X';
   DI4    :  IN STD_LOGIC := 'X';
   DI5    :  IN STD_LOGIC := 'X';
   DI6    :  IN STD_LOGIC := 'X';
   DI7    :  IN STD_LOGIC := 'X';
   DI8    :  IN STD_LOGIC := 'X';
   WRB    :  IN STD_LOGIC := 'X';
   RDB    :  IN STD_LOGIC := 'X';
   WBLKB  :  IN STD_LOGIC := 'X';
   RBLKB  :  IN STD_LOGIC := 'X';
   PARODD :  IN STD_LOGIC := 'X';
   WCLKS   :  IN STD_LOGIC := 'X';
   DIS    :  IN STD_LOGIC := 'X');
end component;

component RAM256x9SAP
   generic (
        Xon                     : Boolean := False;
        MsgOn                   : Boolean := True;
        TimingCheckOn           : Boolean := True;
        MEMORYFILE              : String  := "";
        InstancePath            : String  := "*";

 	tipd_RADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR0_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR1_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR2_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR3_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR4_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR5_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR6_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RADDR7_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpw_RDB_posedge	        : VitalDelayType := 0.000 ns;
 	tpw_RDB_negedge	        : VitalDelayType := 0.000 ns;
 	tperiod_RDB	        : VitalDelayType := 0.000 ns;
 	tpw_RBLKB_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RBLKB_negedge	: VitalDelayType := 0.000 ns;
 	tperiod_RBLKB	        : VitalDelayType := 0.000 ns;
 	tpw_RADDR0_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR0_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR1_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR1_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR2_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR2_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR3_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR3_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR4_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR4_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR5_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR5_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR6_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR6_negedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR7_posedge	: VitalDelayType := 0.000 ns;
 	tpw_RADDR7_negedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR0_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR1_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR2_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR3_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR4_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR5_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR6_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR7_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WRB_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WRB_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WBLKB_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WBLKB_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI0_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI0_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI1_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI1_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI2_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI2_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI3_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI3_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI4_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI4_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI5_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI5_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI6_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI6_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI7_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI7_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI8_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI8_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR0_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR1_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR2_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR3_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR4_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR5_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR6_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR7_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WRB_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_WRB_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_WBLKB_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WBLKB_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_DI0_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI0_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI1_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI1_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI2_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI2_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI3_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI3_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI4_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI4_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI5_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI5_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI6_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI6_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI7_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI7_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI8_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI8_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tpw_WCLKS_posedge                       : VitalDelayType := 0.000 ns;
 	tpw_WCLKS_negedge                       : VitalDelayType := 0.000 ns;
 	tperiod_WCLKS                           : VitalDelayType := 0.000 ns;

 	-- timing data for checking read/write at the same address, and at same time
 	tsetup_RDB_WCLKS_negedge_posedge       : VitalDelayType := 0.000 ns;
 	tsetup_RBLKB_WCLKS_negedge_posedge       : VitalDelayType := 0.000 ns;
 	tsetup_RADDR0_WCLKS_negedge_posedge     : VitalDelayType := 0.000 ns;
	tsetup_RADDR0_WCLKS_posedge_posedge     : VitalDelayType := 0.000 ns;
 	tsetup_RADDR1_WCLKS_negedge_posedge     : VitalDelayType := 0.000 ns;
	tsetup_RADDR1_WCLKS_posedge_posedge     : VitalDelayType := 0.000 ns;
 	tsetup_RADDR2_WCLKS_negedge_posedge     : VitalDelayType := 0.000 ns;
	tsetup_RADDR2_WCLKS_posedge_posedge     : VitalDelayType := 0.000 ns;
 	tsetup_RADDR3_WCLKS_negedge_posedge     : VitalDelayType := 0.000 ns;
	tsetup_RADDR3_WCLKS_posedge_posedge     : VitalDelayType := 0.000 ns;
 	tsetup_RADDR4_WCLKS_negedge_posedge     : VitalDelayType := 0.000 ns;
	tsetup_RADDR4_WCLKS_posedge_posedge     : VitalDelayType := 0.000 ns;
 	tsetup_RADDR5_WCLKS_negedge_posedge     : VitalDelayType := 0.000 ns;
	tsetup_RADDR5_WCLKS_posedge_posedge     : VitalDelayType := 0.000 ns;
 	tsetup_RADDR6_WCLKS_negedge_posedge     : VitalDelayType := 0.000 ns;
	tsetup_RADDR6_WCLKS_posedge_posedge     : VitalDelayType := 0.000 ns;
 	tsetup_RADDR7_WCLKS_negedge_posedge     : VitalDelayType := 0.000 ns;
	tsetup_RADDR7_WCLKS_posedge_posedge     : VitalDelayType := 0.000 ns;
 	thold_RDB_WCLKS_posedge_negedge	: VitalDelayType := 0.000 ns;
 	thold_RBLKB_WCLKS_posedge_negedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR0_WCLKS_negedge_negedge	: VitalDelayType := 0.000 ns;
        thold_RADDR0_WCLKS_posedge_negedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR1_WCLKS_negedge_negedge	: VitalDelayType := 0.000 ns;
        thold_RADDR1_WCLKS_posedge_negedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR2_WCLKS_negedge_negedge	: VitalDelayType := 0.000 ns;
        thold_RADDR2_WCLKS_posedge_negedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR3_WCLKS_negedge_negedge	: VitalDelayType := 0.000 ns;
        thold_RADDR3_WCLKS_posedge_negedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR4_WCLKS_negedge_negedge	: VitalDelayType := 0.000 ns;
        thold_RADDR4_WCLKS_posedge_negedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR5_WCLKS_negedge_negedge	: VitalDelayType := 0.000 ns;
        thold_RADDR5_WCLKS_posedge_negedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR6_WCLKS_negedge_negedge	: VitalDelayType := 0.000 ns;
        thold_RADDR6_WCLKS_posedge_negedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR7_WCLKS_negedge_negedge	: VitalDelayType := 0.000 ns;
        thold_RADDR7_WCLKS_posedge_negedge	: VitalDelayType := 0.000 ns

 	);
 port (
   DO0    :  OUT STD_LOGIC := 'X';
   DO1    :  OUT STD_LOGIC := 'X';
   DO2    :  OUT STD_LOGIC := 'X';
   DO3    :  OUT STD_LOGIC := 'X';
   DO4    :  OUT STD_LOGIC := 'X';
   DO5    :  OUT STD_LOGIC := 'X';
   DO6    :  OUT STD_LOGIC := 'X';
   DO7    :  OUT STD_LOGIC := 'X';
   DO8    :  OUT STD_LOGIC := 'X';
   DOS    :  OUT STD_LOGIC := 'X';

   WADDR0 :  IN STD_LOGIC := 'X';
   WADDR1 :  IN STD_LOGIC := 'X';
   WADDR2 :  IN STD_LOGIC := 'X';
   WADDR3 :  IN STD_LOGIC := 'X';
   WADDR4 :  IN STD_LOGIC := 'X';
   WADDR5 :  IN STD_LOGIC := 'X';
   WADDR6 :  IN STD_LOGIC := 'X';
   WADDR7 :  IN STD_LOGIC := 'X';
   RADDR0 :  IN STD_LOGIC := 'X';
   RADDR1 :  IN STD_LOGIC := 'X';
   RADDR2 :  IN STD_LOGIC := 'X';
   RADDR3 :  IN STD_LOGIC := 'X';
   RADDR4 :  IN STD_LOGIC := 'X';
   RADDR5 :  IN STD_LOGIC := 'X';
   RADDR6 :  IN STD_LOGIC := 'X';
   RADDR7 :  IN STD_LOGIC := 'X';
   DI0    :  IN STD_LOGIC := 'X';
   DI1    :  IN STD_LOGIC := 'X';
   DI2    :  IN STD_LOGIC := 'X';
   DI3    :  IN STD_LOGIC := 'X';
   DI4    :  IN STD_LOGIC := 'X';
   DI5    :  IN STD_LOGIC := 'X';
   DI6    :  IN STD_LOGIC := 'X';
   DI7    :  IN STD_LOGIC := 'X';
   DI8    :  IN STD_LOGIC := 'X';
   WRB    :  IN STD_LOGIC := 'X';
   RDB    :  IN STD_LOGIC := 'X';
   WBLKB  :  IN STD_LOGIC := 'X';
   RBLKB  :  IN STD_LOGIC := 'X';
   PARODD :  IN STD_LOGIC := 'X';
   WCLKS   :  IN STD_LOGIC := 'X';
   DIS    :  IN STD_LOGIC := 'X');
end component;

component RAM256x9SST
   generic (
        Xon                     : Boolean := False;
        MsgOn                   : Boolean := True;
        TimingCheckOn           : Boolean := True;
        MEMORYFILE              : String  := "";
        InstancePath            : String  := "*";

 	tipd_RADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_WCLKS_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tsetup_RADDR0_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR0_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR1_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR1_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR2_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR2_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR3_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR3_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR4_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR4_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR5_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR5_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR6_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR6_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR7_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR7_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RDB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RDB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RBLKB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RBLKB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR0_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR0_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR1_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR1_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR2_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR2_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR3_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR3_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR4_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR4_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR5_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR5_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR6_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR6_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR7_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR7_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RDB_RCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_RDB_RCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_RBLKB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RBLKB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	tpw_RCLKS_posedge	                : VitalDelayType := 0.000 ns;
 	tpw_RCLKS_negedge	                : VitalDelayType := 0.000 ns;
 	tperiod_RCLKS	                        : VitalDelayType := 0.000 ns;
 	tsetup_WADDR0_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR1_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR2_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR3_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR4_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR5_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR6_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR7_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WRB_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WRB_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WBLKB_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WBLKB_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI0_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI0_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI1_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI1_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI2_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI2_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI3_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI3_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI4_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI4_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI5_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI5_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI6_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI6_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI7_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI7_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI8_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI8_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR0_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR1_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR2_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR3_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR4_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR5_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR6_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR7_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WRB_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_WRB_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_WBLKB_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WBLKB_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_DI0_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI0_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI1_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI1_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI2_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI2_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI3_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI3_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI4_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI4_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI5_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI5_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI6_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI6_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI7_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI7_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI8_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI8_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tpw_WCLKS_posedge                       : VitalDelayType := 0.000 ns;
 	tpw_WCLKS_negedge                       : VitalDelayType := 0.000 ns;
 	tperiod_WCLKS                           : VitalDelayType := 0.000 ns;

 	-- timing data for checking read/write at the same address, and at same time
 	tsetup_WCLKS_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WCLKS_RCLKS_posedge_posedge	: VitalDelayType := 7.000 ns

 	);
 port (
   DO0    :  OUT STD_LOGIC := 'X';
   DO1    :  OUT STD_LOGIC := 'X';
   DO2    :  OUT STD_LOGIC := 'X';
   DO3    :  OUT STD_LOGIC := 'X';
   DO4    :  OUT STD_LOGIC := 'X';
   DO5    :  OUT STD_LOGIC := 'X';
   DO6    :  OUT STD_LOGIC := 'X';
   DO7    :  OUT STD_LOGIC := 'X';
   DO8    :  OUT STD_LOGIC := 'X';
   DOS    :  OUT STD_LOGIC := 'X';
   WPE    :  OUT STD_LOGIC := 'X';
   RPE    :  OUT STD_LOGIC := 'X';

   WADDR0 :  IN STD_LOGIC := 'X';
   WADDR1 :  IN STD_LOGIC := 'X';
   WADDR2 :  IN STD_LOGIC := 'X';
   WADDR3 :  IN STD_LOGIC := 'X';
   WADDR4 :  IN STD_LOGIC := 'X';
   WADDR5 :  IN STD_LOGIC := 'X';
   WADDR6 :  IN STD_LOGIC := 'X';
   WADDR7 :  IN STD_LOGIC := 'X';
   RADDR0 :  IN STD_LOGIC := 'X';
   RADDR1 :  IN STD_LOGIC := 'X';
   RADDR2 :  IN STD_LOGIC := 'X';
   RADDR3 :  IN STD_LOGIC := 'X';
   RADDR4 :  IN STD_LOGIC := 'X';
   RADDR5 :  IN STD_LOGIC := 'X';
   RADDR6 :  IN STD_LOGIC := 'X';
   RADDR7 :  IN STD_LOGIC := 'X';
   DI0    :  IN STD_LOGIC := 'X';
   DI1    :  IN STD_LOGIC := 'X';
   DI2    :  IN STD_LOGIC := 'X';
   DI3    :  IN STD_LOGIC := 'X';
   DI4    :  IN STD_LOGIC := 'X';
   DI5    :  IN STD_LOGIC := 'X';
   DI6    :  IN STD_LOGIC := 'X';
   DI7    :  IN STD_LOGIC := 'X';
   DI8    :  IN STD_LOGIC := 'X';
   WRB    :  IN STD_LOGIC := 'X';
   RDB    :  IN STD_LOGIC := 'X';
   WBLKB  :  IN STD_LOGIC := 'X';
   RBLKB  :  IN STD_LOGIC := 'X';
   PARODD :  IN STD_LOGIC := 'X';
   RCLKS   :  IN STD_LOGIC := 'X';
   WCLKS   :  IN STD_LOGIC := 'X';
   DIS    :  IN STD_LOGIC := 'X');
end component;

component RAM256x9SSTP
   generic (
        Xon                     : Boolean := False;
        MsgOn                   : Boolean := True;
        TimingCheckOn           : Boolean := True;
        MEMORYFILE              : String  := "";
        InstancePath            : String  := "*";

 	tipd_RADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tsetup_RADDR0_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR0_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR1_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR1_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR2_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR2_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR3_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR3_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR4_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR4_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR5_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR5_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR6_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR6_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR7_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR7_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RDB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RDB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RBLKB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RBLKB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR0_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR0_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR1_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR1_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR2_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR2_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR3_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR3_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR4_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR4_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR5_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR5_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR6_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR6_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR7_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR7_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RDB_RCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_RDB_RCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_RBLKB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RBLKB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	tpw_RCLKS_posedge	                : VitalDelayType := 0.000 ns;
 	tpw_RCLKS_negedge	                : VitalDelayType := 0.000 ns;
 	tperiod_RCLKS	                        : VitalDelayType := 0.000 ns;
 	tsetup_WADDR0_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR1_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR2_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR3_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR4_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR5_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR6_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR7_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WRB_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WRB_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WBLKB_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WBLKB_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI0_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI0_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI1_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI1_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI2_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI2_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI3_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI3_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI4_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI4_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI5_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI5_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI6_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI6_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI7_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI7_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI8_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI8_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR0_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR1_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR2_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR3_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR4_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR5_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR6_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR7_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WRB_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_WRB_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_WBLKB_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WBLKB_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_DI0_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI0_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI1_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI1_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI2_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI2_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI3_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI3_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI4_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI4_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI5_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI5_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI6_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI6_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI7_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI7_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI8_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI8_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tpw_WCLKS_posedge                       : VitalDelayType := 0.000 ns;
 	tpw_WCLKS_negedge                       : VitalDelayType := 0.000 ns;
 	tperiod_WCLKS                           : VitalDelayType := 0.000 ns;

 	-- timing data for checking read/write at the same address, and at same time
 	tsetup_WCLKS_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WCLKS_RCLKS_posedge_posedge	: VitalDelayType := 7.000 ns

 	);
 port (
   DO0    :  OUT STD_LOGIC := 'X';
   DO1    :  OUT STD_LOGIC := 'X';
   DO2    :  OUT STD_LOGIC := 'X';
   DO3    :  OUT STD_LOGIC := 'X';
   DO4    :  OUT STD_LOGIC := 'X';
   DO5    :  OUT STD_LOGIC := 'X';
   DO6    :  OUT STD_LOGIC := 'X';
   DO7    :  OUT STD_LOGIC := 'X';
   DO8    :  OUT STD_LOGIC := 'X';
   DOS    :  OUT STD_LOGIC := 'X';

   WADDR0 :  IN STD_LOGIC := 'X';
   WADDR1 :  IN STD_LOGIC := 'X';
   WADDR2 :  IN STD_LOGIC := 'X';
   WADDR3 :  IN STD_LOGIC := 'X';
   WADDR4 :  IN STD_LOGIC := 'X';
   WADDR5 :  IN STD_LOGIC := 'X';
   WADDR6 :  IN STD_LOGIC := 'X';
   WADDR7 :  IN STD_LOGIC := 'X';
   RADDR0 :  IN STD_LOGIC := 'X';
   RADDR1 :  IN STD_LOGIC := 'X';
   RADDR2 :  IN STD_LOGIC := 'X';
   RADDR3 :  IN STD_LOGIC := 'X';
   RADDR4 :  IN STD_LOGIC := 'X';
   RADDR5 :  IN STD_LOGIC := 'X';
   RADDR6 :  IN STD_LOGIC := 'X';
   RADDR7 :  IN STD_LOGIC := 'X';
   DI0    :  IN STD_LOGIC := 'X';
   DI1    :  IN STD_LOGIC := 'X';
   DI2    :  IN STD_LOGIC := 'X';
   DI3    :  IN STD_LOGIC := 'X';
   DI4    :  IN STD_LOGIC := 'X';
   DI5    :  IN STD_LOGIC := 'X';
   DI6    :  IN STD_LOGIC := 'X';
   DI7    :  IN STD_LOGIC := 'X';
   DI8    :  IN STD_LOGIC := 'X';
   WRB    :  IN STD_LOGIC := 'X';
   RDB    :  IN STD_LOGIC := 'X';
   WBLKB  :  IN STD_LOGIC := 'X';
   RBLKB  :  IN STD_LOGIC := 'X';
   PARODD :  IN STD_LOGIC := 'X';
   RCLKS   :  IN STD_LOGIC := 'X';
   WCLKS   :  IN STD_LOGIC := 'X';
   DIS    :  IN STD_LOGIC := 'X');
end component;

component RAM256x9SSR
   generic (
        Xon                     : Boolean := False;
        MsgOn                   : Boolean := True;
        TimingCheckOn           : Boolean := True;
        MEMORYFILE              : String  := "";
        InstancePath            : String  := "*";

 	tipd_RADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_WCLKS_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tsetup_RADDR0_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR0_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR1_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR1_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR2_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR2_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR3_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR3_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR4_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR4_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR5_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR5_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR6_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR6_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR7_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR7_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RDB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RDB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RBLKB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RBLKB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR0_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR0_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR1_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR1_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR2_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR2_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR3_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR3_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR4_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR4_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR5_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR5_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR6_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR6_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR7_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR7_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RDB_RCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_RDB_RCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_RBLKB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RBLKB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	tpw_RCLKS_posedge	                : VitalDelayType := 0.000 ns;
 	tpw_RCLKS_negedge	                : VitalDelayType := 0.000 ns;
 	tperiod_RCLKS	                        : VitalDelayType := 0.000 ns;
 	tsetup_WADDR0_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR1_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR2_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR3_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR4_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR5_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR6_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR7_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WRB_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WRB_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WBLKB_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WBLKB_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI0_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI0_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI1_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI1_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI2_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI2_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI3_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI3_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI4_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI4_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI5_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI5_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI6_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI6_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI7_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI7_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI8_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI8_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR0_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR1_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR2_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR3_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR4_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR5_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR6_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR7_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WRB_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_WRB_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_WBLKB_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WBLKB_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_DI0_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI0_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI1_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI1_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI2_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI2_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI3_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI3_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI4_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI4_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI5_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI5_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI6_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI6_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI7_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI7_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI8_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI8_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tpw_WCLKS_posedge                       : VitalDelayType := 0.000 ns;
 	tpw_WCLKS_negedge                       : VitalDelayType := 0.000 ns;
 	tperiod_WCLKS                           : VitalDelayType := 0.000 ns;

 	-- timing data for checking read/write at the same address, and at same time
 	tsetup_WCLKS_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WCLKS_RCLKS_posedge_posedge	: VitalDelayType := 7.000 ns

 	);
 port (
   DO0    :  OUT STD_LOGIC := 'X';
   DO1    :  OUT STD_LOGIC := 'X';
   DO2    :  OUT STD_LOGIC := 'X';
   DO3    :  OUT STD_LOGIC := 'X';
   DO4    :  OUT STD_LOGIC := 'X';
   DO5    :  OUT STD_LOGIC := 'X';
   DO6    :  OUT STD_LOGIC := 'X';
   DO7    :  OUT STD_LOGIC := 'X';
   DO8    :  OUT STD_LOGIC := 'X';
   DOS    :  OUT STD_LOGIC := 'X';
   WPE    :  OUT STD_LOGIC := 'X';
   RPE    :  OUT STD_LOGIC := 'X';

   WADDR0 :  IN STD_LOGIC := 'X';
   WADDR1 :  IN STD_LOGIC := 'X';
   WADDR2 :  IN STD_LOGIC := 'X';
   WADDR3 :  IN STD_LOGIC := 'X';
   WADDR4 :  IN STD_LOGIC := 'X';
   WADDR5 :  IN STD_LOGIC := 'X';
   WADDR6 :  IN STD_LOGIC := 'X';
   WADDR7 :  IN STD_LOGIC := 'X';
   RADDR0 :  IN STD_LOGIC := 'X';
   RADDR1 :  IN STD_LOGIC := 'X';
   RADDR2 :  IN STD_LOGIC := 'X';
   RADDR3 :  IN STD_LOGIC := 'X';
   RADDR4 :  IN STD_LOGIC := 'X';
   RADDR5 :  IN STD_LOGIC := 'X';
   RADDR6 :  IN STD_LOGIC := 'X';
   RADDR7 :  IN STD_LOGIC := 'X';
   DI0    :  IN STD_LOGIC := 'X';
   DI1    :  IN STD_LOGIC := 'X';
   DI2    :  IN STD_LOGIC := 'X';
   DI3    :  IN STD_LOGIC := 'X';
   DI4    :  IN STD_LOGIC := 'X';
   DI5    :  IN STD_LOGIC := 'X';
   DI6    :  IN STD_LOGIC := 'X';
   DI7    :  IN STD_LOGIC := 'X';
   DI8    :  IN STD_LOGIC := 'X';
   WRB    :  IN STD_LOGIC := 'X';
   RDB    :  IN STD_LOGIC := 'X';
   WBLKB  :  IN STD_LOGIC := 'X';
   RBLKB  :  IN STD_LOGIC := 'X';
   PARODD :  IN STD_LOGIC := 'X';
   RCLKS   :  IN STD_LOGIC := 'X';
   WCLKS   :  IN STD_LOGIC := 'X';
   DIS    :  IN STD_LOGIC := 'X');
end component;

component RAM256x9SSRP
   generic (
        Xon                     : Boolean := False;
        MsgOn                   : Boolean := True;
        TimingCheckOn           : Boolean := True;
        MEMORYFILE              : String  := "";
        InstancePath            : String  := "*";

 	tipd_RADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WADDR7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RCLKS_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tsetup_RADDR0_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR0_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR1_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR1_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR2_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR2_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR3_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR3_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR4_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR4_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR5_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR5_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR6_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR6_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RADDR7_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RADDR7_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RDB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RDB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_RBLKB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_RBLKB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR0_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR0_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR1_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR1_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR2_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR2_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR3_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR3_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR4_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR4_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR5_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR5_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR6_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR6_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RADDR7_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RADDR7_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_RDB_RCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_RDB_RCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_RBLKB_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_RBLKB_RCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	tpw_RCLKS_posedge	                : VitalDelayType := 0.000 ns;
 	tpw_RCLKS_negedge	                : VitalDelayType := 0.000 ns;
 	tperiod_RCLKS	                        : VitalDelayType := 0.000 ns;
 	tsetup_WADDR0_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR0_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR1_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR1_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR2_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR2_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR3_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR3_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR4_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR4_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR5_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR5_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR6_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR6_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WADDR7_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WADDR7_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WRB_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WRB_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_WBLKB_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_WBLKB_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI0_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI0_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI1_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI1_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI2_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI2_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI3_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI3_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI4_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI4_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI5_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI5_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI6_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI6_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI7_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI7_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	tsetup_DI8_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	tsetup_DI8_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR0_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR0_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR1_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR1_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR2_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR2_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR3_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR3_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR4_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR4_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR5_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR5_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR6_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR6_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WADDR7_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WADDR7_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WRB_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_WRB_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_WBLKB_WCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
	thold_WBLKB_WCLKS_negedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_DI0_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI0_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI1_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI1_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI2_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI2_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI3_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI3_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI4_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI4_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI5_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI5_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI6_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI6_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI7_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI7_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
 	thold_DI8_WCLKS_negedge_posedge	        : VitalDelayType := 0.000 ns;
	thold_DI8_WCLKS_posedge_posedge	        : VitalDelayType := 0.000 ns;
	tpw_WCLKS_posedge                       : VitalDelayType := 0.000 ns;
 	tpw_WCLKS_negedge                       : VitalDelayType := 0.000 ns;
 	tperiod_WCLKS                           : VitalDelayType := 0.000 ns;

 	-- timing data for checking read/write at the same address, and at same time
 	tsetup_WCLKS_RCLKS_posedge_posedge	: VitalDelayType := 0.000 ns;
 	thold_WCLKS_RCLKS_posedge_posedge	: VitalDelayType := 7.000 ns

 	);
 port (
   DO0    :  OUT STD_LOGIC := 'X';
   DO1    :  OUT STD_LOGIC := 'X';
   DO2    :  OUT STD_LOGIC := 'X';
   DO3    :  OUT STD_LOGIC := 'X';
   DO4    :  OUT STD_LOGIC := 'X';
   DO5    :  OUT STD_LOGIC := 'X';
   DO6    :  OUT STD_LOGIC := 'X';
   DO7    :  OUT STD_LOGIC := 'X';
   DO8    :  OUT STD_LOGIC := 'X';
   DOS    :  OUT STD_LOGIC := 'X';

   WADDR0 :  IN STD_LOGIC := 'X';
   WADDR1 :  IN STD_LOGIC := 'X';
   WADDR2 :  IN STD_LOGIC := 'X';
   WADDR3 :  IN STD_LOGIC := 'X';
   WADDR4 :  IN STD_LOGIC := 'X';
   WADDR5 :  IN STD_LOGIC := 'X';
   WADDR6 :  IN STD_LOGIC := 'X';
   WADDR7 :  IN STD_LOGIC := 'X';
   RADDR0 :  IN STD_LOGIC := 'X';
   RADDR1 :  IN STD_LOGIC := 'X';
   RADDR2 :  IN STD_LOGIC := 'X';
   RADDR3 :  IN STD_LOGIC := 'X';
   RADDR4 :  IN STD_LOGIC := 'X';
   RADDR5 :  IN STD_LOGIC := 'X';
   RADDR6 :  IN STD_LOGIC := 'X';
   RADDR7 :  IN STD_LOGIC := 'X';
   DI0    :  IN STD_LOGIC := 'X';
   DI1    :  IN STD_LOGIC := 'X';
   DI2    :  IN STD_LOGIC := 'X';
   DI3    :  IN STD_LOGIC := 'X';
   DI4    :  IN STD_LOGIC := 'X';
   DI5    :  IN STD_LOGIC := 'X';
   DI6    :  IN STD_LOGIC := 'X';
   DI7    :  IN STD_LOGIC := 'X';
   DI8    :  IN STD_LOGIC := 'X';
   WRB    :  IN STD_LOGIC := 'X';
   RDB    :  IN STD_LOGIC := 'X';
   WBLKB  :  IN STD_LOGIC := 'X';
   RBLKB  :  IN STD_LOGIC := 'X';
   PARODD :  IN STD_LOGIC := 'X';
   RCLKS   :  IN STD_LOGIC := 'X';
   WCLKS   :  IN STD_LOGIC := 'X';
   DIS    :  IN STD_LOGIC := 'X');
end component;


component FIFO256x9AA
   generic (
        Xon           : Boolean := False;
        MsgOn         : Boolean := True;
        TimingCheckOn : Boolean := True;
        InstancePath  : String  := "*";

 	tipd_LEVEL0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RESET		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI0_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI1_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI2_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI3_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI4_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI5_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI6_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI7_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI8_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RBLKB_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);

 	tpw_RDB_posedge         : VitalDelayType        := 0.000 ns;
 	tpw_RDB_negedge         : VitalDelayType        := 0.000 ns;
 	tperiod_RDB             : VitalDelayType        := 0.000 ns;
 	tpw_RBLKB_posedge       : VitalDelayType        := 0.000 ns;
 	tpw_RBLKB_negedge       : VitalDelayType        := 0.000 ns;
 	tperiod_RBLKB           : VitalDelayType        := 0.000 ns;

 	tpw_RESET_negedge                             : VitalDelayType := 0.000 ns;
 	thold_DI0_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI0_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI1_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI1_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI2_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI2_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI3_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI3_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI4_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI4_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI5_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI5_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI6_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI6_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI7_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI7_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI8_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI8_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI0_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI0_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI1_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI1_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI2_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI2_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI3_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI3_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI4_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI4_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI5_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI5_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI6_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI6_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI7_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI7_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI8_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI8_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI0_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI1_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI2_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI3_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI4_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI5_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI6_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI7_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI8_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI0_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI1_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI2_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI3_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI4_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI5_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI6_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI7_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI8_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;

  	-- WB falling edge hold to RESETB   
 	thold_WRB_RESET_posedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_WBLKB_RESET_posedge_posedge             : VitalDelayType := 0.000 ns;
 	tsetup_WRB_RESET_posedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_WBLKB_RESET_posedge_posedge            : VitalDelayType := 0.000 ns;
	thold_WRB_RESET_negedge_posedge               : VitalDelayType := 0.000 ns;
	thold_WBLKB_RESET_negedge_posedge             : VitalDelayType := 0.000 ns;
	tsetup_WRB_RESET_negedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_WBLKB_RESET_negedge_posedge            : VitalDelayType := 0.000 ns;
 	tpw_WRB_posedge                               : VitalDelayType := 0.000 ns;
 	tpw_WRB_negedge                               : VitalDelayType := 0.000 ns;
 	tperiod_WRB                                   : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_posedge                             : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_negedge                             : VitalDelayType := 0.000 ns;
 	tperiod_WBLKB                                 : VitalDelayType := 0.000 ns
 	);

   port (
        DO0    :  OUT STD_LOGIC := 'X';
        DO1    :  OUT STD_LOGIC := 'X';
        DO2    :  OUT STD_LOGIC := 'X';
        DO3    :  OUT STD_LOGIC := 'X';
        DO4    :  OUT STD_LOGIC := 'X';
        DO5    :  OUT STD_LOGIC := 'X';
        DO6    :  OUT STD_LOGIC := 'X';
        DO7    :  OUT STD_LOGIC := 'X';
        DO8    :  OUT STD_LOGIC := 'X';
        DOS    :  OUT STD_LOGIC := 'X';
        WPE    :  OUT STD_LOGIC := 'X';
        RPE    :  OUT STD_LOGIC := 'X';
        FULL   :  OUT STD_LOGIC := 'X';
        EMPTY  :  OUT STD_LOGIC := 'X';
        EQTH   :  OUT STD_LOGIC := 'X';
        GEQTH  :  OUT STD_LOGIC := 'X';

        LGDEP0 :  IN STD_LOGIC := 'X';
        LGDEP1 :  IN STD_LOGIC := 'X';
        LGDEP2 :  IN STD_LOGIC := 'X';
        LEVEL0 :  IN STD_LOGIC := 'X';
        LEVEL1 :  IN STD_LOGIC := 'X';
        LEVEL2 :  IN STD_LOGIC := 'X';
        LEVEL3 :  IN STD_LOGIC := 'X';
        LEVEL4 :  IN STD_LOGIC := 'X';
        LEVEL5 :  IN STD_LOGIC := 'X';
        LEVEL6 :  IN STD_LOGIC := 'X';
        LEVEL7 :  IN STD_LOGIC := 'X';
        DI0    :  IN STD_LOGIC := 'X';
        DI1    :  IN STD_LOGIC := 'X';
        DI2    :  IN STD_LOGIC := 'X';
        DI3    :  IN STD_LOGIC := 'X';
        DI4    :  IN STD_LOGIC := 'X';
        DI5    :  IN STD_LOGIC := 'X';
        DI6    :  IN STD_LOGIC := 'X';
        DI7    :  IN STD_LOGIC := 'X';
        DI8    :  IN STD_LOGIC := 'X';
        WRB    :  IN STD_LOGIC := 'X';
        RDB    :  IN STD_LOGIC := 'X';
        WBLKB  :  IN STD_LOGIC := 'X';
        RBLKB  :  IN STD_LOGIC := 'X';
        PARODD :  IN STD_LOGIC := 'X';
        RESET  :  IN STD_LOGIC := 'X';
        DIS    :  IN STD_LOGIC := 'X');

end component;

component FIFO256x9AAP
   generic (
        Xon           : Boolean := False;
        MsgOn         : Boolean := True;
        TimingCheckOn : Boolean := True;
        InstancePath  : String  := "*";

 	tipd_LEVEL0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RESET		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RBLKB_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);

 	tpw_RDB_posedge         : VitalDelayType        := 0.000 ns;
 	tpw_RDB_negedge         : VitalDelayType        := 0.000 ns;
 	tperiod_RDB             : VitalDelayType        := 0.000 ns;
 	tpw_RBLKB_posedge       : VitalDelayType        := 0.000 ns;
 	tpw_RBLKB_negedge       : VitalDelayType        := 0.000 ns;
 	tperiod_RBLKB           : VitalDelayType        := 0.000 ns;

 	tpw_RESET_negedge                             : VitalDelayType := 0.000 ns;
 	thold_DI0_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI0_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI1_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI1_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI2_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI2_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI3_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI3_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI4_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI4_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI5_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI5_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI6_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI6_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI7_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI7_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI8_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI8_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI0_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI0_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI1_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI1_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI2_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI2_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI3_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI3_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI4_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI4_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI5_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI5_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI6_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI6_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI7_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI7_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI8_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI8_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI0_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI1_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI2_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI3_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI4_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI5_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI6_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI7_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI8_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI0_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI1_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI2_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI3_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI4_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI5_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI6_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI7_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI8_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;

  	-- WB falling edge hold to RESETB   
 	thold_WRB_RESET_posedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_WBLKB_RESET_posedge_posedge             : VitalDelayType := 0.000 ns;
 	tsetup_WRB_RESET_posedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_WBLKB_RESET_posedge_posedge            : VitalDelayType := 0.000 ns;
	thold_WRB_RESET_negedge_posedge               : VitalDelayType := 0.000 ns;
	thold_WBLKB_RESET_negedge_posedge             : VitalDelayType := 0.000 ns;
	tsetup_WRB_RESET_negedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_WBLKB_RESET_negedge_posedge            : VitalDelayType := 0.000 ns;
 	tpw_WRB_posedge                               : VitalDelayType := 0.000 ns;
 	tpw_WRB_negedge                               : VitalDelayType := 0.000 ns;
 	tperiod_WRB                                   : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_posedge                             : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_negedge                             : VitalDelayType := 0.000 ns;
 	tperiod_WBLKB                                 : VitalDelayType := 0.000 ns
 	);

   port (
        DO0    :  OUT STD_LOGIC := 'X';
        DO1    :  OUT STD_LOGIC := 'X';
        DO2    :  OUT STD_LOGIC := 'X';
        DO3    :  OUT STD_LOGIC := 'X';
        DO4    :  OUT STD_LOGIC := 'X';
        DO5    :  OUT STD_LOGIC := 'X';
        DO6    :  OUT STD_LOGIC := 'X';
        DO7    :  OUT STD_LOGIC := 'X';
        DO8    :  OUT STD_LOGIC := 'X';
        DOS    :  OUT STD_LOGIC := 'X';
        FULL   :  OUT STD_LOGIC := 'X';
        EMPTY  :  OUT STD_LOGIC := 'X';
        EQTH   :  OUT STD_LOGIC := 'X';
        GEQTH  :  OUT STD_LOGIC := 'X';

        LGDEP0 :  IN STD_LOGIC := 'X';
        LGDEP1 :  IN STD_LOGIC := 'X';
        LGDEP2 :  IN STD_LOGIC := 'X';
        LEVEL0 :  IN STD_LOGIC := 'X';
        LEVEL1 :  IN STD_LOGIC := 'X';
        LEVEL2 :  IN STD_LOGIC := 'X';
        LEVEL3 :  IN STD_LOGIC := 'X';
        LEVEL4 :  IN STD_LOGIC := 'X';
        LEVEL5 :  IN STD_LOGIC := 'X';
        LEVEL6 :  IN STD_LOGIC := 'X';
        LEVEL7 :  IN STD_LOGIC := 'X';
        DI0    :  IN STD_LOGIC := 'X';
        DI1    :  IN STD_LOGIC := 'X';
        DI2    :  IN STD_LOGIC := 'X';
        DI3    :  IN STD_LOGIC := 'X';
        DI4    :  IN STD_LOGIC := 'X';
        DI5    :  IN STD_LOGIC := 'X';
        DI6    :  IN STD_LOGIC := 'X';
        DI7    :  IN STD_LOGIC := 'X';
        DI8    :  IN STD_LOGIC := 'X';
        WRB    :  IN STD_LOGIC := 'X';
        RDB    :  IN STD_LOGIC := 'X';
        WBLKB  :  IN STD_LOGIC := 'X';
        RBLKB  :  IN STD_LOGIC := 'X';
        PARODD :  IN STD_LOGIC := 'X';
        RESET  :  IN STD_LOGIC := 'X';
        DIS    :  IN STD_LOGIC := 'X');

end component;

component FIFO256x9AST
   generic (
        Xon           : Boolean := False;
        MsgOn         : Boolean := True;
        TimingCheckOn : Boolean := True;
        InstancePath  : String  := "*";

 	tipd_LEVEL0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RESET		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI0_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI1_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI2_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI3_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI4_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI5_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI6_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI7_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI8_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);

 	tsetup_RDB_RCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_RDB_RCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_RBLKB_RCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
	tsetup_RBLKB_RCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;
 	tsetup_PARODD_RCLKS_posedge_posedge           : VitalDelayType := 0.000 ns;
	tsetup_PARODD_RCLKS_negedge_posedge           : VitalDelayType := 0.000 ns;
 	thold_RDB_RCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_RDB_RCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_RBLKB_RCLKS_posedge_posedge             : VitalDelayType := 0.000 ns;
	thold_RBLKB_RCLKS_negedge_posedge             : VitalDelayType := 0.000 ns;
 	thold_PARODD_RCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
	thold_PARODD_RCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;

        -- RCLK falling edge setup to RESET rising edge 
	trecovery_RESET_RCLKS_posedge_posedge            : VitalDelayType := 0.00 ns;
	trecovery_RESET_RCLKS_posedge_negedge            : VitalDelayType := 0.00 ns;

        -- RCLK rising  edge hold to RESET rising edge 
 	thold_RESET_RCLKS_posedge_posedge             : VitalDelayType := 0.000 ns;
	thold_RESET_RCLKS_posedge_negedge             : VitalDelayType := 0.000 ns;
	tpw_RCLKS_posedge                             : VitalDelayType := 0.000 ns;
 	tpw_RCLKS_negedge                             : VitalDelayType := 0.000 ns;
 	tperiod_RCLKS                                 : VitalDelayType := 0.000 ns;

 	tpw_RESET_negedge                             : VitalDelayType := 0.000 ns;
 	thold_DI0_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI0_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI1_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI1_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI2_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI2_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI3_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI3_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI4_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI4_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI5_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI5_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI6_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI6_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI7_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI7_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI8_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI8_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI0_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI0_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI1_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI1_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI2_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI2_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI3_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI3_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI4_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI4_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI5_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI5_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI6_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI6_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI7_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI7_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI8_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI8_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI0_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI1_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI2_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI3_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI4_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI5_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI6_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI7_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI8_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI0_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI1_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI2_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI3_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI4_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI5_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI6_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI7_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI8_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;

  	-- WB falling edge hold to RESETB   
 	thold_WRB_RESET_posedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_WBLKB_RESET_posedge_posedge             : VitalDelayType := 0.000 ns;
 	tsetup_WRB_RESET_posedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_WBLKB_RESET_posedge_posedge            : VitalDelayType := 0.000 ns;
	thold_WRB_RESET_negedge_posedge               : VitalDelayType := 0.000 ns;
	thold_WBLKB_RESET_negedge_posedge             : VitalDelayType := 0.000 ns;
	tsetup_WRB_RESET_negedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_WBLKB_RESET_negedge_posedge            : VitalDelayType := 0.000 ns;
 	tpw_WRB_posedge                               : VitalDelayType := 0.000 ns;
 	tpw_WRB_negedge                               : VitalDelayType := 0.000 ns;
 	tperiod_WRB                                   : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_posedge                             : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_negedge                             : VitalDelayType := 0.000 ns;
 	tperiod_WBLKB                                 : VitalDelayType := 0.000 ns
 	);

   port (
        DO0    :  OUT STD_LOGIC := 'X';
        DO1    :  OUT STD_LOGIC := 'X';
        DO2    :  OUT STD_LOGIC := 'X';
        DO3    :  OUT STD_LOGIC := 'X';
        DO4    :  OUT STD_LOGIC := 'X';
        DO5    :  OUT STD_LOGIC := 'X';
        DO6    :  OUT STD_LOGIC := 'X';
        DO7    :  OUT STD_LOGIC := 'X';
        DO8    :  OUT STD_LOGIC := 'X';
        DOS    :  OUT STD_LOGIC := 'X';
        WPE    :  OUT STD_LOGIC := 'X';
        RPE    :  OUT STD_LOGIC := 'X';
        FULL   :  OUT STD_LOGIC := 'X';
        EMPTY  :  OUT STD_LOGIC := 'X';
        EQTH   :  OUT STD_LOGIC := 'X';
        GEQTH  :  OUT STD_LOGIC := 'X';

        LGDEP0 :  IN STD_LOGIC := 'X';
        LGDEP1 :  IN STD_LOGIC := 'X';
        LGDEP2 :  IN STD_LOGIC := 'X';
        LEVEL0 :  IN STD_LOGIC := 'X';
        LEVEL1 :  IN STD_LOGIC := 'X';
        LEVEL2 :  IN STD_LOGIC := 'X';
        LEVEL3 :  IN STD_LOGIC := 'X';
        LEVEL4 :  IN STD_LOGIC := 'X';
        LEVEL5 :  IN STD_LOGIC := 'X';
        LEVEL6 :  IN STD_LOGIC := 'X';
        LEVEL7 :  IN STD_LOGIC := 'X';
        DI0    :  IN STD_LOGIC := 'X';
        DI1    :  IN STD_LOGIC := 'X';
        DI2    :  IN STD_LOGIC := 'X';
        DI3    :  IN STD_LOGIC := 'X';
        DI4    :  IN STD_LOGIC := 'X';
        DI5    :  IN STD_LOGIC := 'X';
        DI6    :  IN STD_LOGIC := 'X';
        DI7    :  IN STD_LOGIC := 'X';
        DI8    :  IN STD_LOGIC := 'X';
        WRB    :  IN STD_LOGIC := 'X';
        RDB    :  IN STD_LOGIC := 'X';
        WBLKB  :  IN STD_LOGIC := 'X';
        RBLKB  :  IN STD_LOGIC := 'X';
        PARODD :  IN STD_LOGIC := 'X';
        RESET  :  IN STD_LOGIC := 'X';
        RCLKS  :  IN STD_LOGIC := 'X';
        DIS    :  IN STD_LOGIC := 'X');

end component;

component FIFO256x9ASTP
   generic (
        Xon           : Boolean := False;
        MsgOn         : Boolean := True;
        TimingCheckOn : Boolean := True;
        InstancePath  : String  := "*";

 	tipd_LEVEL0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RESET		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);

 	tsetup_RDB_RCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_RDB_RCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_RBLKB_RCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
	tsetup_RBLKB_RCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;
 	tsetup_PARODD_RCLKS_posedge_posedge           : VitalDelayType := 0.000 ns;
	tsetup_PARODD_RCLKS_negedge_posedge           : VitalDelayType := 0.000 ns;
 	thold_RDB_RCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_RDB_RCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_RBLKB_RCLKS_posedge_posedge             : VitalDelayType := 0.000 ns;
	thold_RBLKB_RCLKS_negedge_posedge             : VitalDelayType := 0.000 ns;
 	thold_PARODD_RCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
	thold_PARODD_RCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;

        -- RCLK falling edge setup to RESET rising edge 
	trecovery_RESET_RCLKS_posedge_posedge            : VitalDelayType := 0.00 ns;
	trecovery_RESET_RCLKS_posedge_negedge            : VitalDelayType := 0.00 ns;

        -- RCLK rising  edge hold to RESET rising edge 
 	thold_RESET_RCLKS_posedge_posedge             : VitalDelayType := 0.000 ns;
	thold_RESET_RCLKS_posedge_negedge             : VitalDelayType := 0.000 ns;
	tpw_RCLKS_posedge                             : VitalDelayType := 0.000 ns;
 	tpw_RCLKS_negedge                             : VitalDelayType := 0.000 ns;
 	tperiod_RCLKS                                 : VitalDelayType := 0.000 ns;

 	tpw_RESET_negedge                             : VitalDelayType := 0.000 ns;
 	thold_DI0_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI0_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI1_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI1_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI2_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI2_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI3_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI3_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI4_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI4_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI5_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI5_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI6_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI6_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI7_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI7_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI8_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI8_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI0_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI0_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI1_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI1_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI2_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI2_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI3_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI3_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI4_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI4_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI5_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI5_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI6_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI6_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI7_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI7_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI8_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI8_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI0_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI1_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI2_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI3_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI4_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI5_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI6_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI7_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI8_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI0_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI1_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI2_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI3_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI4_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI5_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI6_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI7_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI8_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;

  	-- WB falling edge hold to RESETB   
 	thold_WRB_RESET_posedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_WBLKB_RESET_posedge_posedge             : VitalDelayType := 0.000 ns;
 	tsetup_WRB_RESET_posedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_WBLKB_RESET_posedge_posedge            : VitalDelayType := 0.000 ns;
	thold_WRB_RESET_negedge_posedge               : VitalDelayType := 0.000 ns;
	thold_WBLKB_RESET_negedge_posedge             : VitalDelayType := 0.000 ns;
	tsetup_WRB_RESET_negedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_WBLKB_RESET_negedge_posedge            : VitalDelayType := 0.000 ns;
 	tpw_WRB_posedge                               : VitalDelayType := 0.000 ns;
 	tpw_WRB_negedge                               : VitalDelayType := 0.000 ns;
 	tperiod_WRB                                   : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_posedge                             : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_negedge                             : VitalDelayType := 0.000 ns;
 	tperiod_WBLKB                                 : VitalDelayType := 0.000 ns
 	);

   port (
        DO0    :  OUT STD_LOGIC := 'X';
        DO1    :  OUT STD_LOGIC := 'X';
        DO2    :  OUT STD_LOGIC := 'X';
        DO3    :  OUT STD_LOGIC := 'X';
        DO4    :  OUT STD_LOGIC := 'X';
        DO5    :  OUT STD_LOGIC := 'X';
        DO6    :  OUT STD_LOGIC := 'X';
        DO7    :  OUT STD_LOGIC := 'X';
        DO8    :  OUT STD_LOGIC := 'X';
        DOS    :  OUT STD_LOGIC := 'X';
        FULL   :  OUT STD_LOGIC := 'X';
        EMPTY  :  OUT STD_LOGIC := 'X';
        EQTH   :  OUT STD_LOGIC := 'X';
        GEQTH  :  OUT STD_LOGIC := 'X';

        LGDEP0 :  IN STD_LOGIC := 'X';
        LGDEP1 :  IN STD_LOGIC := 'X';
        LGDEP2 :  IN STD_LOGIC := 'X';
        LEVEL0 :  IN STD_LOGIC := 'X';
        LEVEL1 :  IN STD_LOGIC := 'X';
        LEVEL2 :  IN STD_LOGIC := 'X';
        LEVEL3 :  IN STD_LOGIC := 'X';
        LEVEL4 :  IN STD_LOGIC := 'X';
        LEVEL5 :  IN STD_LOGIC := 'X';
        LEVEL6 :  IN STD_LOGIC := 'X';
        LEVEL7 :  IN STD_LOGIC := 'X';
        DI0    :  IN STD_LOGIC := 'X';
        DI1    :  IN STD_LOGIC := 'X';
        DI2    :  IN STD_LOGIC := 'X';
        DI3    :  IN STD_LOGIC := 'X';
        DI4    :  IN STD_LOGIC := 'X';
        DI5    :  IN STD_LOGIC := 'X';
        DI6    :  IN STD_LOGIC := 'X';
        DI7    :  IN STD_LOGIC := 'X';
        DI8    :  IN STD_LOGIC := 'X';
        WRB    :  IN STD_LOGIC := 'X';
        RDB    :  IN STD_LOGIC := 'X';
        WBLKB  :  IN STD_LOGIC := 'X';
        RBLKB  :  IN STD_LOGIC := 'X';
        PARODD :  IN STD_LOGIC := 'X';
        RESET  :  IN STD_LOGIC := 'X';
        RCLKS  :  IN STD_LOGIC := 'X';
        DIS    :  IN STD_LOGIC := 'X');

end component;

component FIFO256x9ASR
   generic (
        Xon           : Boolean := False;
        MsgOn         : Boolean := True;
        TimingCheckOn : Boolean := True;
        InstancePath  : String  := "*";

 	tipd_LEVEL0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RESET		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI0_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI1_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI2_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI3_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI4_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI5_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI6_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI7_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_DI8_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);

 	tsetup_RDB_RCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_RDB_RCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_RBLKB_RCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
	tsetup_RBLKB_RCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;
 	tsetup_PARODD_RCLKS_posedge_posedge           : VitalDelayType := 0.000 ns;
	tsetup_PARODD_RCLKS_negedge_posedge           : VitalDelayType := 0.000 ns;
 	thold_RDB_RCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_RDB_RCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_RBLKB_RCLKS_posedge_posedge             : VitalDelayType := 0.000 ns;
	thold_RBLKB_RCLKS_negedge_posedge             : VitalDelayType := 0.000 ns;
 	thold_PARODD_RCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
	thold_PARODD_RCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;

        -- RCLK falling edge setup to RESET rising edge 
	trecovery_RESET_RCLKS_posedge_posedge            : VitalDelayType := 0.00 ns;
	trecovery_RESET_RCLKS_posedge_negedge            : VitalDelayType := 0.00 ns;

        -- RCLK rising  edge hold to RESET rising edge 
 	thold_RESET_RCLKS_posedge_posedge             : VitalDelayType := 0.000 ns;
	thold_RESET_RCLKS_posedge_negedge             : VitalDelayType := 0.000 ns;
	tpw_RCLKS_posedge                             : VitalDelayType := 0.000 ns;
 	tpw_RCLKS_negedge                             : VitalDelayType := 0.000 ns;
 	tperiod_RCLKS                                 : VitalDelayType := 0.000 ns;

 	tpw_RESET_negedge                             : VitalDelayType := 0.000 ns;
 	thold_DI0_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI0_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI1_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI1_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI2_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI2_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI3_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI3_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI4_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI4_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI5_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI5_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI6_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI6_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI7_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI7_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI8_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI8_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI0_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI0_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI1_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI1_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI2_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI2_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI3_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI3_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI4_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI4_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI5_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI5_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI6_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI6_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI7_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI7_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI8_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI8_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI0_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI1_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI2_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI3_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI4_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI5_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI6_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI7_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI8_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI0_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI1_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI2_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI3_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI4_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI5_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI6_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI7_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI8_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;

  	-- WB falling edge hold to RESETB   
 	thold_WRB_RESET_posedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_WBLKB_RESET_posedge_posedge             : VitalDelayType := 0.000 ns;
 	tsetup_WRB_RESET_posedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_WBLKB_RESET_posedge_posedge            : VitalDelayType := 0.000 ns;
	thold_WRB_RESET_negedge_posedge               : VitalDelayType := 0.000 ns;
	thold_WBLKB_RESET_negedge_posedge             : VitalDelayType := 0.000 ns;
	tsetup_WRB_RESET_negedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_WBLKB_RESET_negedge_posedge            : VitalDelayType := 0.000 ns;
 	tpw_WRB_posedge                               : VitalDelayType := 0.000 ns;
 	tpw_WRB_negedge                               : VitalDelayType := 0.000 ns;
 	tperiod_WRB                                   : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_posedge                             : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_negedge                             : VitalDelayType := 0.000 ns;
 	tperiod_WBLKB                                 : VitalDelayType := 0.000 ns
 	);

   port (
        DO0    :  OUT STD_LOGIC := 'X';
        DO1    :  OUT STD_LOGIC := 'X';
        DO2    :  OUT STD_LOGIC := 'X';
        DO3    :  OUT STD_LOGIC := 'X';
        DO4    :  OUT STD_LOGIC := 'X';
        DO5    :  OUT STD_LOGIC := 'X';
        DO6    :  OUT STD_LOGIC := 'X';
        DO7    :  OUT STD_LOGIC := 'X';
        DO8    :  OUT STD_LOGIC := 'X';
        DOS    :  OUT STD_LOGIC := 'X';
        WPE    :  OUT STD_LOGIC := 'X';
        RPE    :  OUT STD_LOGIC := 'X';
        FULL   :  OUT STD_LOGIC := 'X';
        EMPTY  :  OUT STD_LOGIC := 'X';
        EQTH   :  OUT STD_LOGIC := 'X';
        GEQTH  :  OUT STD_LOGIC := 'X';

        LGDEP0 :  IN STD_LOGIC := 'X';
        LGDEP1 :  IN STD_LOGIC := 'X';
        LGDEP2 :  IN STD_LOGIC := 'X';
        LEVEL0 :  IN STD_LOGIC := 'X';
        LEVEL1 :  IN STD_LOGIC := 'X';
        LEVEL2 :  IN STD_LOGIC := 'X';
        LEVEL3 :  IN STD_LOGIC := 'X';
        LEVEL4 :  IN STD_LOGIC := 'X';
        LEVEL5 :  IN STD_LOGIC := 'X';
        LEVEL6 :  IN STD_LOGIC := 'X';
        LEVEL7 :  IN STD_LOGIC := 'X';
        DI0    :  IN STD_LOGIC := 'X';
        DI1    :  IN STD_LOGIC := 'X';
        DI2    :  IN STD_LOGIC := 'X';
        DI3    :  IN STD_LOGIC := 'X';
        DI4    :  IN STD_LOGIC := 'X';
        DI5    :  IN STD_LOGIC := 'X';
        DI6    :  IN STD_LOGIC := 'X';
        DI7    :  IN STD_LOGIC := 'X';
        DI8    :  IN STD_LOGIC := 'X';
        WRB    :  IN STD_LOGIC := 'X';
        RDB    :  IN STD_LOGIC := 'X';
        WBLKB  :  IN STD_LOGIC := 'X';
        RBLKB  :  IN STD_LOGIC := 'X';
        PARODD :  IN STD_LOGIC := 'X';
        RESET  :  IN STD_LOGIC := 'X';
        RCLKS  :  IN STD_LOGIC := 'X';
        DIS    :  IN STD_LOGIC := 'X');

end component;

component FIFO256x9ASRP
   generic (
        Xon           : Boolean := False;
        MsgOn         : Boolean := True;
        TimingCheckOn : Boolean := True;
        InstancePath  : String  := "*";

 	tipd_LEVEL0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RESET		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WBLKB_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WRB_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);

 	tsetup_RDB_RCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_RDB_RCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_RBLKB_RCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
	tsetup_RBLKB_RCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;
 	tsetup_PARODD_RCLKS_posedge_posedge           : VitalDelayType := 0.000 ns;
	tsetup_PARODD_RCLKS_negedge_posedge           : VitalDelayType := 0.000 ns;
 	thold_RDB_RCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_RDB_RCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_RBLKB_RCLKS_posedge_posedge             : VitalDelayType := 0.000 ns;
	thold_RBLKB_RCLKS_negedge_posedge             : VitalDelayType := 0.000 ns;
 	thold_PARODD_RCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
	thold_PARODD_RCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;

        -- RCLK falling edge setup to RESET rising edge 
	trecovery_RESET_RCLKS_posedge_posedge            : VitalDelayType := 0.00 ns;
	trecovery_RESET_RCLKS_posedge_negedge            : VitalDelayType := 0.00 ns;

        -- RCLK rising  edge hold to RESET rising edge 
 	thold_RESET_RCLKS_posedge_posedge             : VitalDelayType := 0.000 ns;
	thold_RESET_RCLKS_posedge_negedge             : VitalDelayType := 0.000 ns;
	tpw_RCLKS_posedge                             : VitalDelayType := 0.000 ns;
 	tpw_RCLKS_negedge                             : VitalDelayType := 0.000 ns;
 	tperiod_RCLKS                                 : VitalDelayType := 0.000 ns;

 	tpw_RESET_negedge                             : VitalDelayType := 0.000 ns;
 	thold_DI0_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI0_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI1_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI1_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI2_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI2_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI3_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI3_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI4_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI4_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI5_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI5_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI6_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI6_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI7_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI7_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI8_WRB_posedge_posedge                 : VitalDelayType := 0.000 ns;
	thold_DI8_WRB_negedge_posedge                 : VitalDelayType := 0.000 ns;
 	thold_DI0_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI0_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI1_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI1_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI2_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI2_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI3_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI3_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI4_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI4_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI5_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI5_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI6_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI6_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI7_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI7_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI8_WBLKB_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI8_WBLKB_negedge_posedge               : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI0_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI1_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI2_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI3_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI4_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI5_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI6_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI7_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WRB_posedge_posedge                : VitalDelayType := 0.000 ns;
	tsetup_DI8_WRB_negedge_posedge                : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI0_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI1_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI2_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI3_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI4_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI5_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI6_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI7_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WBLKB_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI8_WBLKB_negedge_posedge              : VitalDelayType := 0.000 ns;

  	-- WB falling edge hold to RESETB   
 	thold_WRB_RESET_posedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_WBLKB_RESET_posedge_posedge             : VitalDelayType := 0.000 ns;
 	tsetup_WRB_RESET_posedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_WBLKB_RESET_posedge_posedge            : VitalDelayType := 0.000 ns;
	thold_WRB_RESET_negedge_posedge               : VitalDelayType := 0.000 ns;
	thold_WBLKB_RESET_negedge_posedge             : VitalDelayType := 0.000 ns;
	tsetup_WRB_RESET_negedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_WBLKB_RESET_negedge_posedge            : VitalDelayType := 0.000 ns;
 	tpw_WRB_posedge                               : VitalDelayType := 0.000 ns;
 	tpw_WRB_negedge                               : VitalDelayType := 0.000 ns;
 	tperiod_WRB                                   : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_posedge                             : VitalDelayType := 0.000 ns;
 	tpw_WBLKB_negedge                             : VitalDelayType := 0.000 ns;
 	tperiod_WBLKB                                 : VitalDelayType := 0.000 ns
 	);

   port (
        DO0    :  OUT STD_LOGIC := 'X';
        DO1    :  OUT STD_LOGIC := 'X';
        DO2    :  OUT STD_LOGIC := 'X';
        DO3    :  OUT STD_LOGIC := 'X';
        DO4    :  OUT STD_LOGIC := 'X';
        DO5    :  OUT STD_LOGIC := 'X';
        DO6    :  OUT STD_LOGIC := 'X';
        DO7    :  OUT STD_LOGIC := 'X';
        DO8    :  OUT STD_LOGIC := 'X';
        DOS    :  OUT STD_LOGIC := 'X';
        FULL   :  OUT STD_LOGIC := 'X';
        EMPTY  :  OUT STD_LOGIC := 'X';
        EQTH   :  OUT STD_LOGIC := 'X';
        GEQTH  :  OUT STD_LOGIC := 'X';

        LGDEP0 :  IN STD_LOGIC := 'X';
        LGDEP1 :  IN STD_LOGIC := 'X';
        LGDEP2 :  IN STD_LOGIC := 'X';
        LEVEL0 :  IN STD_LOGIC := 'X';
        LEVEL1 :  IN STD_LOGIC := 'X';
        LEVEL2 :  IN STD_LOGIC := 'X';
        LEVEL3 :  IN STD_LOGIC := 'X';
        LEVEL4 :  IN STD_LOGIC := 'X';
        LEVEL5 :  IN STD_LOGIC := 'X';
        LEVEL6 :  IN STD_LOGIC := 'X';
        LEVEL7 :  IN STD_LOGIC := 'X';
        DI0    :  IN STD_LOGIC := 'X';
        DI1    :  IN STD_LOGIC := 'X';
        DI2    :  IN STD_LOGIC := 'X';
        DI3    :  IN STD_LOGIC := 'X';
        DI4    :  IN STD_LOGIC := 'X';
        DI5    :  IN STD_LOGIC := 'X';
        DI6    :  IN STD_LOGIC := 'X';
        DI7    :  IN STD_LOGIC := 'X';
        DI8    :  IN STD_LOGIC := 'X';
        WRB    :  IN STD_LOGIC := 'X';
        RDB    :  IN STD_LOGIC := 'X';
        WBLKB  :  IN STD_LOGIC := 'X';
        RBLKB  :  IN STD_LOGIC := 'X';
        PARODD :  IN STD_LOGIC := 'X';
        RESET  :  IN STD_LOGIC := 'X';
        RCLKS  :  IN STD_LOGIC := 'X';
        DIS    :  IN STD_LOGIC := 'X');

end component;

component FIFO256x9SA
   generic (
        Xon           : Boolean := False;
        MsgOn         : Boolean := True;
        TimingCheckOn : Boolean := True;
        InstancePath  : String  := "*";

 	tipd_LEVEL0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RESET		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RBLKB_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_PARODD_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);

 	tpw_RDB_posedge         : VitalDelayType        := 0.000 ns;
 	tpw_RDB_negedge         : VitalDelayType        := 0.000 ns;
 	tperiod_RDB             : VitalDelayType        := 0.000 ns;
 	tpw_RBLKB_posedge       : VitalDelayType        := 0.000 ns;
 	tpw_RBLKB_negedge       : VitalDelayType        := 0.000 ns;
 	tperiod_RBLKB           : VitalDelayType        := 0.000 ns;

 	tpw_RESET_negedge                             : VitalDelayType := 0.000 ns;
 	tsetup_WRB_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_WRB_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_WBLKB_WCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
	tsetup_WBLKB_WCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;
 	tsetup_PARODD_WCLKS_posedge_posedge           : VitalDelayType := 0.000 ns;
	tsetup_PARODD_WCLKS_negedge_posedge           : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI0_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI1_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI2_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI3_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI4_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI5_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI6_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI7_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI8_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	thold_WRB_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_WRB_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_WBLKB_WCLKS_posedge_posedge             : VitalDelayType := 0.000 ns;
	thold_WBLKB_WCLKS_negedge_posedge             : VitalDelayType := 0.000 ns;
 	thold_PARODD_WCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;
	thold_PARODD_WCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
 	thold_DI0_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI0_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI1_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI1_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI2_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI2_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI3_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI3_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI4_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI4_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI5_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI5_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI6_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI6_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI7_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI7_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI8_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI8_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;

        -- WCLK falling edge setup to RESET rising edge 
 	trecovery_RESET_WCLKS_posedge_posedge            : VitalDelayType := 0.00 ns;
	trecovery_RESET_WCLKS_posedge_negedge            : VitalDelayType := 0.00 ns;

        -- WCLK rising  edge hold to RESET rising edge 
	thold_RESET_WCLKS_posedge_posedge             : VitalDelayType := 0.00 ns;
	thold_RESET_WCLKS_posedge_negedge             : VitalDelayType := 0.00 ns;
	tpw_WCLKS_posedge                             : VitalDelayType := 0.000 ns;
 	tpw_WCLKS_negedge                             : VitalDelayType := 0.000 ns;
 	tperiod_WCLKS                                 : VitalDelayType := 0.000 ns
 	);

   port (
        DO0    :  OUT STD_LOGIC := 'X';
        DO1    :  OUT STD_LOGIC := 'X';
        DO2    :  OUT STD_LOGIC := 'X';
        DO3    :  OUT STD_LOGIC := 'X';
        DO4    :  OUT STD_LOGIC := 'X';
        DO5    :  OUT STD_LOGIC := 'X';
        DO6    :  OUT STD_LOGIC := 'X';
        DO7    :  OUT STD_LOGIC := 'X';
        DO8    :  OUT STD_LOGIC := 'X';
        DOS    :  OUT STD_LOGIC := 'X';
        WPE    :  OUT STD_LOGIC := 'X';
        RPE    :  OUT STD_LOGIC := 'X';
        FULL   :  OUT STD_LOGIC := 'X';
        EMPTY  :  OUT STD_LOGIC := 'X';
        EQTH   :  OUT STD_LOGIC := 'X';
        GEQTH  :  OUT STD_LOGIC := 'X';

        LGDEP0 :  IN STD_LOGIC := 'X';
        LGDEP1 :  IN STD_LOGIC := 'X';
        LGDEP2 :  IN STD_LOGIC := 'X';
        LEVEL0 :  IN STD_LOGIC := 'X';
        LEVEL1 :  IN STD_LOGIC := 'X';
        LEVEL2 :  IN STD_LOGIC := 'X';
        LEVEL3 :  IN STD_LOGIC := 'X';
        LEVEL4 :  IN STD_LOGIC := 'X';
        LEVEL5 :  IN STD_LOGIC := 'X';
        LEVEL6 :  IN STD_LOGIC := 'X';
        LEVEL7 :  IN STD_LOGIC := 'X';
        DI0    :  IN STD_LOGIC := 'X';
        DI1    :  IN STD_LOGIC := 'X';
        DI2    :  IN STD_LOGIC := 'X';
        DI3    :  IN STD_LOGIC := 'X';
        DI4    :  IN STD_LOGIC := 'X';
        DI5    :  IN STD_LOGIC := 'X';
        DI6    :  IN STD_LOGIC := 'X';
        DI7    :  IN STD_LOGIC := 'X';
        DI8    :  IN STD_LOGIC := 'X';
        WRB    :  IN STD_LOGIC := 'X';
        RDB    :  IN STD_LOGIC := 'X';
        WBLKB  :  IN STD_LOGIC := 'X';
        RBLKB  :  IN STD_LOGIC := 'X';
        PARODD :  IN STD_LOGIC := 'X';
        RESET  :  IN STD_LOGIC := 'X';
        WCLKS  :  IN STD_LOGIC := 'X';
        DIS    :  IN STD_LOGIC := 'X');

end component;

component FIFO256x9SAP
   generic (
        Xon           : Boolean := False;
        MsgOn         : Boolean := True;
        TimingCheckOn : Boolean := True;
        InstancePath  : String  := "*";

 	tipd_LEVEL0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RESET		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_RBLKB_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RBLKB_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RDB_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);

 	tpw_RDB_posedge         : VitalDelayType        := 0.000 ns;
 	tpw_RDB_negedge         : VitalDelayType        := 0.000 ns;
 	tperiod_RDB             : VitalDelayType        := 0.000 ns;
 	tpw_RBLKB_posedge       : VitalDelayType        := 0.000 ns;
 	tpw_RBLKB_negedge       : VitalDelayType        := 0.000 ns;
 	tperiod_RBLKB           : VitalDelayType        := 0.000 ns;

 	tpw_RESET_negedge                             : VitalDelayType := 0.000 ns;
 	tsetup_WRB_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_WRB_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_WBLKB_WCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
	tsetup_WBLKB_WCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;
 	tsetup_PARODD_WCLKS_posedge_posedge           : VitalDelayType := 0.000 ns;
	tsetup_PARODD_WCLKS_negedge_posedge           : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI0_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI1_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI2_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI3_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI4_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI5_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI6_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI7_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI8_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	thold_WRB_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_WRB_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_WBLKB_WCLKS_posedge_posedge             : VitalDelayType := 0.000 ns;
	thold_WBLKB_WCLKS_negedge_posedge             : VitalDelayType := 0.000 ns;
 	thold_PARODD_WCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;
	thold_PARODD_WCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
 	thold_DI0_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI0_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI1_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI1_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI2_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI2_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI3_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI3_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI4_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI4_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI5_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI5_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI6_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI6_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI7_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI7_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI8_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI8_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;

        -- WCLK falling edge setup to RESET rising edge 
 	trecovery_RESET_WCLKS_posedge_posedge            : VitalDelayType := 0.00 ns;
	trecovery_RESET_WCLKS_posedge_negedge            : VitalDelayType := 0.00 ns;

        -- WCLK rising  edge hold to RESET rising edge 
	thold_RESET_WCLKS_posedge_posedge             : VitalDelayType := 0.00 ns;
	thold_RESET_WCLKS_posedge_negedge             : VitalDelayType := 0.00 ns;
	tpw_WCLKS_posedge                             : VitalDelayType := 0.000 ns;
 	tpw_WCLKS_negedge                             : VitalDelayType := 0.000 ns;
 	tperiod_WCLKS                                 : VitalDelayType := 0.000 ns
 	);

   port (
        DO0    :  OUT STD_LOGIC := 'X';
        DO1    :  OUT STD_LOGIC := 'X';
        DO2    :  OUT STD_LOGIC := 'X';
        DO3    :  OUT STD_LOGIC := 'X';
        DO4    :  OUT STD_LOGIC := 'X';
        DO5    :  OUT STD_LOGIC := 'X';
        DO6    :  OUT STD_LOGIC := 'X';
        DO7    :  OUT STD_LOGIC := 'X';
        DO8    :  OUT STD_LOGIC := 'X';
        DOS    :  OUT STD_LOGIC := 'X';
        FULL   :  OUT STD_LOGIC := 'X';
        EMPTY  :  OUT STD_LOGIC := 'X';
        EQTH   :  OUT STD_LOGIC := 'X';
        GEQTH  :  OUT STD_LOGIC := 'X';

        LGDEP0 :  IN STD_LOGIC := 'X';
        LGDEP1 :  IN STD_LOGIC := 'X';
        LGDEP2 :  IN STD_LOGIC := 'X';
        LEVEL0 :  IN STD_LOGIC := 'X';
        LEVEL1 :  IN STD_LOGIC := 'X';
        LEVEL2 :  IN STD_LOGIC := 'X';
        LEVEL3 :  IN STD_LOGIC := 'X';
        LEVEL4 :  IN STD_LOGIC := 'X';
        LEVEL5 :  IN STD_LOGIC := 'X';
        LEVEL6 :  IN STD_LOGIC := 'X';
        LEVEL7 :  IN STD_LOGIC := 'X';
        DI0    :  IN STD_LOGIC := 'X';
        DI1    :  IN STD_LOGIC := 'X';
        DI2    :  IN STD_LOGIC := 'X';
        DI3    :  IN STD_LOGIC := 'X';
        DI4    :  IN STD_LOGIC := 'X';
        DI5    :  IN STD_LOGIC := 'X';
        DI6    :  IN STD_LOGIC := 'X';
        DI7    :  IN STD_LOGIC := 'X';
        DI8    :  IN STD_LOGIC := 'X';
        WRB    :  IN STD_LOGIC := 'X';
        RDB    :  IN STD_LOGIC := 'X';
        WBLKB  :  IN STD_LOGIC := 'X';
        RBLKB  :  IN STD_LOGIC := 'X';
        PARODD :  IN STD_LOGIC := 'X';
        RESET  :  IN STD_LOGIC := 'X';
        WCLKS  :  IN STD_LOGIC := 'X';
        DIS    :  IN STD_LOGIC := 'X');

end component;

component FIFO256x9SST
   generic (
        Xon           : Boolean := False;
        MsgOn         : Boolean := True;
        TimingCheckOn : Boolean := True;
        InstancePath  : String  := "*";

 	tipd_LEVEL0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RESET		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_PARODD_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);

 	tsetup_RDB_RCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_RDB_RCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_RBLKB_RCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
	tsetup_RBLKB_RCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;
 	tsetup_PARODD_RCLKS_posedge_posedge           : VitalDelayType := 0.000 ns;
	tsetup_PARODD_RCLKS_negedge_posedge           : VitalDelayType := 0.000 ns;
 	thold_RDB_RCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_RDB_RCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_RBLKB_RCLKS_posedge_posedge             : VitalDelayType := 0.000 ns;
	thold_RBLKB_RCLKS_negedge_posedge             : VitalDelayType := 0.000 ns;
 	thold_PARODD_RCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
	thold_PARODD_RCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;

        -- RCLK falling edge setup to RESET rising edge 
	trecovery_RESET_RCLKS_posedge_posedge            : VitalDelayType := 0.00 ns;
	trecovery_RESET_RCLKS_posedge_negedge            : VitalDelayType := 0.00 ns;

        -- RCLK rising  edge hold to RESET rising edge 
 	thold_RESET_RCLKS_posedge_posedge             : VitalDelayType := 0.000 ns;
	thold_RESET_RCLKS_posedge_negedge             : VitalDelayType := 0.000 ns;
	tpw_RCLKS_posedge                             : VitalDelayType := 0.000 ns;
 	tpw_RCLKS_negedge                             : VitalDelayType := 0.000 ns;
 	tperiod_RCLKS                                 : VitalDelayType := 0.000 ns;

 	tpw_RESET_negedge                             : VitalDelayType := 0.000 ns;
 	tsetup_WRB_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_WRB_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_WBLKB_WCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
	tsetup_WBLKB_WCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;
 	tsetup_PARODD_WCLKS_posedge_posedge           : VitalDelayType := 0.000 ns;
	tsetup_PARODD_WCLKS_negedge_posedge           : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI0_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI1_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI2_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI3_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI4_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI5_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI6_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI7_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI8_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	thold_WRB_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_WRB_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_WBLKB_WCLKS_posedge_posedge             : VitalDelayType := 0.000 ns;
	thold_WBLKB_WCLKS_negedge_posedge             : VitalDelayType := 0.000 ns;
 	thold_PARODD_WCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;
	thold_PARODD_WCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
 	thold_DI0_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI0_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI1_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI1_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI2_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI2_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI3_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI3_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI4_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI4_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI5_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI5_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI6_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI6_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI7_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI7_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI8_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI8_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;

        -- WCLK falling edge setup to RESET rising edge 
 	trecovery_RESET_WCLKS_posedge_posedge            : VitalDelayType := 0.00 ns;
	trecovery_RESET_WCLKS_posedge_negedge            : VitalDelayType := 0.00 ns;

        -- WCLK rising  edge hold to RESET rising edge 
	thold_RESET_WCLKS_posedge_posedge             : VitalDelayType := 0.00 ns;
	thold_RESET_WCLKS_posedge_negedge             : VitalDelayType := 0.00 ns;
	tpw_WCLKS_posedge                             : VitalDelayType := 0.000 ns;
 	tpw_WCLKS_negedge                             : VitalDelayType := 0.000 ns;
 	tperiod_WCLKS                                 : VitalDelayType := 0.000 ns
 	);

   port (
        DO0    :  OUT STD_LOGIC := 'X';
        DO1    :  OUT STD_LOGIC := 'X';
        DO2    :  OUT STD_LOGIC := 'X';
        DO3    :  OUT STD_LOGIC := 'X';
        DO4    :  OUT STD_LOGIC := 'X';
        DO5    :  OUT STD_LOGIC := 'X';
        DO6    :  OUT STD_LOGIC := 'X';
        DO7    :  OUT STD_LOGIC := 'X';
        DO8    :  OUT STD_LOGIC := 'X';
        DOS    :  OUT STD_LOGIC := 'X';
        WPE    :  OUT STD_LOGIC := 'X';
        RPE    :  OUT STD_LOGIC := 'X';
        FULL   :  OUT STD_LOGIC := 'X';
        EMPTY  :  OUT STD_LOGIC := 'X';
        EQTH   :  OUT STD_LOGIC := 'X';
        GEQTH  :  OUT STD_LOGIC := 'X';

        LGDEP0 :  IN STD_LOGIC := 'X';
        LGDEP1 :  IN STD_LOGIC := 'X';
        LGDEP2 :  IN STD_LOGIC := 'X';
        LEVEL0 :  IN STD_LOGIC := 'X';
        LEVEL1 :  IN STD_LOGIC := 'X';
        LEVEL2 :  IN STD_LOGIC := 'X';
        LEVEL3 :  IN STD_LOGIC := 'X';
        LEVEL4 :  IN STD_LOGIC := 'X';
        LEVEL5 :  IN STD_LOGIC := 'X';
        LEVEL6 :  IN STD_LOGIC := 'X';
        LEVEL7 :  IN STD_LOGIC := 'X';
        DI0    :  IN STD_LOGIC := 'X';
        DI1    :  IN STD_LOGIC := 'X';
        DI2    :  IN STD_LOGIC := 'X';
        DI3    :  IN STD_LOGIC := 'X';
        DI4    :  IN STD_LOGIC := 'X';
        DI5    :  IN STD_LOGIC := 'X';
        DI6    :  IN STD_LOGIC := 'X';
        DI7    :  IN STD_LOGIC := 'X';
        DI8    :  IN STD_LOGIC := 'X';
        WRB    :  IN STD_LOGIC := 'X';
        RDB    :  IN STD_LOGIC := 'X';
        WBLKB  :  IN STD_LOGIC := 'X';
        RBLKB  :  IN STD_LOGIC := 'X';
        PARODD :  IN STD_LOGIC := 'X';
        RESET  :  IN STD_LOGIC := 'X';
        RCLKS  :  IN STD_LOGIC := 'X';
        WCLKS  :  IN STD_LOGIC := 'X';
        DIS    :  IN STD_LOGIC := 'X');

end component;

component FIFO256x9SSTP
   generic (
        Xon           : Boolean := False;
        MsgOn         : Boolean := True;
        TimingCheckOn : Boolean := True;
        InstancePath  : String  := "*";

 	tipd_LEVEL0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RESET		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);

 	tsetup_RDB_RCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_RDB_RCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_RBLKB_RCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
	tsetup_RBLKB_RCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;
 	tsetup_PARODD_RCLKS_posedge_posedge           : VitalDelayType := 0.000 ns;
	tsetup_PARODD_RCLKS_negedge_posedge           : VitalDelayType := 0.000 ns;
 	thold_RDB_RCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_RDB_RCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_RBLKB_RCLKS_posedge_posedge             : VitalDelayType := 0.000 ns;
	thold_RBLKB_RCLKS_negedge_posedge             : VitalDelayType := 0.000 ns;
 	thold_PARODD_RCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
	thold_PARODD_RCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;

        -- RCLK falling edge setup to RESET rising edge 
	trecovery_RESET_RCLKS_posedge_posedge            : VitalDelayType := 0.00 ns;
	trecovery_RESET_RCLKS_posedge_negedge            : VitalDelayType := 0.00 ns;

        -- RCLK rising  edge hold to RESET rising edge 
 	thold_RESET_RCLKS_posedge_posedge             : VitalDelayType := 0.000 ns;
	thold_RESET_RCLKS_posedge_negedge             : VitalDelayType := 0.000 ns;
	tpw_RCLKS_posedge                             : VitalDelayType := 0.000 ns;
 	tpw_RCLKS_negedge                             : VitalDelayType := 0.000 ns;
 	tperiod_RCLKS                                 : VitalDelayType := 0.000 ns;

 	tpw_RESET_negedge                             : VitalDelayType := 0.000 ns;
 	tsetup_WRB_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_WRB_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_WBLKB_WCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
	tsetup_WBLKB_WCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;
 	tsetup_PARODD_WCLKS_posedge_posedge           : VitalDelayType := 0.000 ns;
	tsetup_PARODD_WCLKS_negedge_posedge           : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI0_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI1_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI2_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI3_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI4_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI5_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI6_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI7_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI8_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	thold_WRB_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_WRB_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_WBLKB_WCLKS_posedge_posedge             : VitalDelayType := 0.000 ns;
	thold_WBLKB_WCLKS_negedge_posedge             : VitalDelayType := 0.000 ns;
 	thold_PARODD_WCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;
	thold_PARODD_WCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
 	thold_DI0_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI0_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI1_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI1_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI2_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI2_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI3_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI3_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI4_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI4_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI5_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI5_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI6_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI6_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI7_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI7_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI8_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI8_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;

        -- WCLK falling edge setup to RESET rising edge 
 	trecovery_RESET_WCLKS_posedge_posedge            : VitalDelayType := 0.00 ns;
	trecovery_RESET_WCLKS_posedge_negedge            : VitalDelayType := 0.00 ns;

        -- WCLK rising  edge hold to RESET rising edge 
	thold_RESET_WCLKS_posedge_posedge             : VitalDelayType := 0.00 ns;
	thold_RESET_WCLKS_posedge_negedge             : VitalDelayType := 0.00 ns;
	tpw_WCLKS_posedge                             : VitalDelayType := 0.000 ns;
 	tpw_WCLKS_negedge                             : VitalDelayType := 0.000 ns;
 	tperiod_WCLKS                                 : VitalDelayType := 0.000 ns
 	);

   port (
        DO0    :  OUT STD_LOGIC := 'X';
        DO1    :  OUT STD_LOGIC := 'X';
        DO2    :  OUT STD_LOGIC := 'X';
        DO3    :  OUT STD_LOGIC := 'X';
        DO4    :  OUT STD_LOGIC := 'X';
        DO5    :  OUT STD_LOGIC := 'X';
        DO6    :  OUT STD_LOGIC := 'X';
        DO7    :  OUT STD_LOGIC := 'X';
        DO8    :  OUT STD_LOGIC := 'X';
        DOS    :  OUT STD_LOGIC := 'X';
        FULL   :  OUT STD_LOGIC := 'X';
        EMPTY  :  OUT STD_LOGIC := 'X';
        EQTH   :  OUT STD_LOGIC := 'X';
        GEQTH  :  OUT STD_LOGIC := 'X';

        LGDEP0 :  IN STD_LOGIC := 'X';
        LGDEP1 :  IN STD_LOGIC := 'X';
        LGDEP2 :  IN STD_LOGIC := 'X';
        LEVEL0 :  IN STD_LOGIC := 'X';
        LEVEL1 :  IN STD_LOGIC := 'X';
        LEVEL2 :  IN STD_LOGIC := 'X';
        LEVEL3 :  IN STD_LOGIC := 'X';
        LEVEL4 :  IN STD_LOGIC := 'X';
        LEVEL5 :  IN STD_LOGIC := 'X';
        LEVEL6 :  IN STD_LOGIC := 'X';
        LEVEL7 :  IN STD_LOGIC := 'X';
        DI0    :  IN STD_LOGIC := 'X';
        DI1    :  IN STD_LOGIC := 'X';
        DI2    :  IN STD_LOGIC := 'X';
        DI3    :  IN STD_LOGIC := 'X';
        DI4    :  IN STD_LOGIC := 'X';
        DI5    :  IN STD_LOGIC := 'X';
        DI6    :  IN STD_LOGIC := 'X';
        DI7    :  IN STD_LOGIC := 'X';
        DI8    :  IN STD_LOGIC := 'X';
        WRB    :  IN STD_LOGIC := 'X';
        RDB    :  IN STD_LOGIC := 'X';
        WBLKB  :  IN STD_LOGIC := 'X';
        RBLKB  :  IN STD_LOGIC := 'X';
        PARODD :  IN STD_LOGIC := 'X';
        RESET  :  IN STD_LOGIC := 'X';
        RCLKS  :  IN STD_LOGIC := 'X';
        WCLKS  :  IN STD_LOGIC := 'X';
        DIS    :  IN STD_LOGIC := 'X');

end component;

component FIFO256x9SSR
   generic (
        Xon           : Boolean := False;
        MsgOn         : Boolean := True;
        TimingCheckOn : Boolean := True;
        InstancePath  : String  := "*";

 	tipd_LEVEL0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RESET		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_RPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_PARODD_WPE		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);

 	tsetup_RDB_RCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_RDB_RCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_RBLKB_RCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
	tsetup_RBLKB_RCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;
 	tsetup_PARODD_RCLKS_posedge_posedge           : VitalDelayType := 0.000 ns;
	tsetup_PARODD_RCLKS_negedge_posedge           : VitalDelayType := 0.000 ns;
 	thold_RDB_RCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_RDB_RCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_RBLKB_RCLKS_posedge_posedge             : VitalDelayType := 0.000 ns;
	thold_RBLKB_RCLKS_negedge_posedge             : VitalDelayType := 0.000 ns;
 	thold_PARODD_RCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
	thold_PARODD_RCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;

        -- RCLK falling edge setup to RESET rising edge 
	trecovery_RESET_RCLKS_posedge_posedge            : VitalDelayType := 0.00 ns;
	trecovery_RESET_RCLKS_posedge_negedge            : VitalDelayType := 0.00 ns;

        -- RCLK rising  edge hold to RESET rising edge 
 	thold_RESET_RCLKS_posedge_posedge             : VitalDelayType := 0.000 ns;
	thold_RESET_RCLKS_posedge_negedge             : VitalDelayType := 0.000 ns;
	tpw_RCLKS_posedge                             : VitalDelayType := 0.000 ns;
 	tpw_RCLKS_negedge                             : VitalDelayType := 0.000 ns;
 	tperiod_RCLKS                                 : VitalDelayType := 0.000 ns;

 	tpw_RESET_negedge                             : VitalDelayType := 0.000 ns;
 	tsetup_WRB_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_WRB_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_WBLKB_WCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
	tsetup_WBLKB_WCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;
 	tsetup_PARODD_WCLKS_posedge_posedge           : VitalDelayType := 0.000 ns;
	tsetup_PARODD_WCLKS_negedge_posedge           : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI0_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI1_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI2_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI3_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI4_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI5_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI6_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI7_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI8_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	thold_WRB_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_WRB_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_WBLKB_WCLKS_posedge_posedge             : VitalDelayType := 0.000 ns;
	thold_WBLKB_WCLKS_negedge_posedge             : VitalDelayType := 0.000 ns;
 	thold_PARODD_WCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;
	thold_PARODD_WCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
 	thold_DI0_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI0_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI1_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI1_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI2_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI2_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI3_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI3_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI4_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI4_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI5_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI5_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI6_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI6_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI7_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI7_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI8_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI8_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;

        -- WCLK falling edge setup to RESET rising edge 
 	trecovery_RESET_WCLKS_posedge_posedge            : VitalDelayType := 0.00 ns;
	trecovery_RESET_WCLKS_posedge_negedge            : VitalDelayType := 0.00 ns;

        -- WCLK rising  edge hold to RESET rising edge 
	thold_RESET_WCLKS_posedge_posedge             : VitalDelayType := 0.00 ns;
	thold_RESET_WCLKS_posedge_negedge             : VitalDelayType := 0.00 ns;
	tpw_WCLKS_posedge                             : VitalDelayType := 0.000 ns;
 	tpw_WCLKS_negedge                             : VitalDelayType := 0.000 ns;
 	tperiod_WCLKS                                 : VitalDelayType := 0.000 ns
 	);

   port (
        DO0    :  OUT STD_LOGIC := 'X';
        DO1    :  OUT STD_LOGIC := 'X';
        DO2    :  OUT STD_LOGIC := 'X';
        DO3    :  OUT STD_LOGIC := 'X';
        DO4    :  OUT STD_LOGIC := 'X';
        DO5    :  OUT STD_LOGIC := 'X';
        DO6    :  OUT STD_LOGIC := 'X';
        DO7    :  OUT STD_LOGIC := 'X';
        DO8    :  OUT STD_LOGIC := 'X';
        DOS    :  OUT STD_LOGIC := 'X';
        WPE    :  OUT STD_LOGIC := 'X';
        RPE    :  OUT STD_LOGIC := 'X';
        FULL   :  OUT STD_LOGIC := 'X';
        EMPTY  :  OUT STD_LOGIC := 'X';
        EQTH   :  OUT STD_LOGIC := 'X';
        GEQTH  :  OUT STD_LOGIC := 'X';

        LGDEP0 :  IN STD_LOGIC := 'X';
        LGDEP1 :  IN STD_LOGIC := 'X';
        LGDEP2 :  IN STD_LOGIC := 'X';
        LEVEL0 :  IN STD_LOGIC := 'X';
        LEVEL1 :  IN STD_LOGIC := 'X';
        LEVEL2 :  IN STD_LOGIC := 'X';
        LEVEL3 :  IN STD_LOGIC := 'X';
        LEVEL4 :  IN STD_LOGIC := 'X';
        LEVEL5 :  IN STD_LOGIC := 'X';
        LEVEL6 :  IN STD_LOGIC := 'X';
        LEVEL7 :  IN STD_LOGIC := 'X';
        DI0    :  IN STD_LOGIC := 'X';
        DI1    :  IN STD_LOGIC := 'X';
        DI2    :  IN STD_LOGIC := 'X';
        DI3    :  IN STD_LOGIC := 'X';
        DI4    :  IN STD_LOGIC := 'X';
        DI5    :  IN STD_LOGIC := 'X';
        DI6    :  IN STD_LOGIC := 'X';
        DI7    :  IN STD_LOGIC := 'X';
        DI8    :  IN STD_LOGIC := 'X';
        WRB    :  IN STD_LOGIC := 'X';
        RDB    :  IN STD_LOGIC := 'X';
        WBLKB  :  IN STD_LOGIC := 'X';
        RBLKB  :  IN STD_LOGIC := 'X';
        PARODD :  IN STD_LOGIC := 'X';
        RESET  :  IN STD_LOGIC := 'X';
        RCLKS  :  IN STD_LOGIC := 'X';
        WCLKS  :  IN STD_LOGIC := 'X';
        DIS    :  IN STD_LOGIC := 'X');

end component;

component FIFO256x9SSRP
   generic (
        Xon           : Boolean := False;
        MsgOn         : Boolean := True;
        TimingCheckOn : Boolean := True;
        InstancePath  : String  := "*";

 	tipd_LEVEL0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LEVEL7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_LGDEP2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RCLKS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WRB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RDB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_WBLKB		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DIS		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_PARODD		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_RESET		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI0		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI1		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI2		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI3		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI4		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI5		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI6		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI7		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tipd_DI8		: VitalDelayType01Z     := (0 ns, 0 ns, 0 ns, 0 ns, 0 ns, 0 ns);
 	tpd_DIS_DOS		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
	tpd_WCLKS_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RCLKS_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_FULL		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EMPTY		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_EQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_GEQTH		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO0		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO1		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO2		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO3		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO4		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO5		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO6		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO7		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
 	tpd_RESET_DO8		: VitalDelayType01Z     := (0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);

 	tsetup_RDB_RCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_RDB_RCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_RBLKB_RCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
	tsetup_RBLKB_RCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;
 	tsetup_PARODD_RCLKS_posedge_posedge           : VitalDelayType := 0.000 ns;
	tsetup_PARODD_RCLKS_negedge_posedge           : VitalDelayType := 0.000 ns;
 	thold_RDB_RCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_RDB_RCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_RBLKB_RCLKS_posedge_posedge             : VitalDelayType := 0.000 ns;
	thold_RBLKB_RCLKS_negedge_posedge             : VitalDelayType := 0.000 ns;
 	thold_PARODD_RCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
	thold_PARODD_RCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;

        -- RCLK falling edge setup to RESET rising edge 
	trecovery_RESET_RCLKS_posedge_posedge            : VitalDelayType := 0.00 ns;
	trecovery_RESET_RCLKS_posedge_negedge            : VitalDelayType := 0.00 ns;

        -- RCLK rising  edge hold to RESET rising edge 
 	thold_RESET_RCLKS_posedge_posedge             : VitalDelayType := 0.000 ns;
	thold_RESET_RCLKS_posedge_negedge             : VitalDelayType := 0.000 ns;
	tpw_RCLKS_posedge                             : VitalDelayType := 0.000 ns;
 	tpw_RCLKS_negedge                             : VitalDelayType := 0.000 ns;
 	tperiod_RCLKS                                 : VitalDelayType := 0.000 ns;

 	tpw_RESET_negedge                             : VitalDelayType := 0.000 ns;
 	tsetup_WRB_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_WRB_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_WBLKB_WCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
	tsetup_WBLKB_WCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;
 	tsetup_PARODD_WCLKS_posedge_posedge           : VitalDelayType := 0.000 ns;
	tsetup_PARODD_WCLKS_negedge_posedge           : VitalDelayType := 0.000 ns;
 	tsetup_DI0_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI0_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI1_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI1_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI2_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI2_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI3_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI3_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI4_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI4_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI5_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI5_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI6_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI6_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI7_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI7_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	tsetup_DI8_WCLKS_posedge_posedge              : VitalDelayType := 0.000 ns;
	tsetup_DI8_WCLKS_negedge_posedge              : VitalDelayType := 0.000 ns;
 	thold_WRB_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_WRB_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_WBLKB_WCLKS_posedge_posedge             : VitalDelayType := 0.000 ns;
	thold_WBLKB_WCLKS_negedge_posedge             : VitalDelayType := 0.000 ns;
 	thold_PARODD_WCLKS_negedge_posedge            : VitalDelayType := 0.000 ns;
	thold_PARODD_WCLKS_posedge_posedge            : VitalDelayType := 0.000 ns;
 	thold_DI0_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI0_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI1_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI1_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI2_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI2_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI3_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI3_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI4_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI4_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI5_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI5_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI6_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI6_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI7_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI7_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;
 	thold_DI8_WCLKS_posedge_posedge               : VitalDelayType := 0.000 ns;
	thold_DI8_WCLKS_negedge_posedge               : VitalDelayType := 0.000 ns;

        -- WCLK falling edge setup to RESET rising edge 
 	trecovery_RESET_WCLKS_posedge_posedge            : VitalDelayType := 0.00 ns;
	trecovery_RESET_WCLKS_posedge_negedge            : VitalDelayType := 0.00 ns;

        -- WCLK rising  edge hold to RESET rising edge 
	thold_RESET_WCLKS_posedge_posedge             : VitalDelayType := 0.00 ns;
	thold_RESET_WCLKS_posedge_negedge             : VitalDelayType := 0.00 ns;
	tpw_WCLKS_posedge                             : VitalDelayType := 0.000 ns;
 	tpw_WCLKS_negedge                             : VitalDelayType := 0.000 ns;
 	tperiod_WCLKS                                 : VitalDelayType := 0.000 ns
 	);

   port (
        DO0    :  OUT STD_LOGIC := 'X';
        DO1    :  OUT STD_LOGIC := 'X';
        DO2    :  OUT STD_LOGIC := 'X';
        DO3    :  OUT STD_LOGIC := 'X';
        DO4    :  OUT STD_LOGIC := 'X';
        DO5    :  OUT STD_LOGIC := 'X';
        DO6    :  OUT STD_LOGIC := 'X';
        DO7    :  OUT STD_LOGIC := 'X';
        DO8    :  OUT STD_LOGIC := 'X';
        DOS    :  OUT STD_LOGIC := 'X';
        FULL   :  OUT STD_LOGIC := 'X';
        EMPTY  :  OUT STD_LOGIC := 'X';
        EQTH   :  OUT STD_LOGIC := 'X';
        GEQTH  :  OUT STD_LOGIC := 'X';

        LGDEP0 :  IN STD_LOGIC := 'X';
        LGDEP1 :  IN STD_LOGIC := 'X';
        LGDEP2 :  IN STD_LOGIC := 'X';
        LEVEL0 :  IN STD_LOGIC := 'X';
        LEVEL1 :  IN STD_LOGIC := 'X';
        LEVEL2 :  IN STD_LOGIC := 'X';
        LEVEL3 :  IN STD_LOGIC := 'X';
        LEVEL4 :  IN STD_LOGIC := 'X';
        LEVEL5 :  IN STD_LOGIC := 'X';
        LEVEL6 :  IN STD_LOGIC := 'X';
        LEVEL7 :  IN STD_LOGIC := 'X';
        DI0    :  IN STD_LOGIC := 'X';
        DI1    :  IN STD_LOGIC := 'X';
        DI2    :  IN STD_LOGIC := 'X';
        DI3    :  IN STD_LOGIC := 'X';
        DI4    :  IN STD_LOGIC := 'X';
        DI5    :  IN STD_LOGIC := 'X';
        DI6    :  IN STD_LOGIC := 'X';
        DI7    :  IN STD_LOGIC := 'X';
        DI8    :  IN STD_LOGIC := 'X';
        WRB    :  IN STD_LOGIC := 'X';
        RDB    :  IN STD_LOGIC := 'X';
        WBLKB  :  IN STD_LOGIC := 'X';
        RBLKB  :  IN STD_LOGIC := 'X';
        PARODD :  IN STD_LOGIC := 'X';
        RESET  :  IN STD_LOGIC := 'X';
        RCLKS  :  IN STD_LOGIC := 'X';
        WCLKS  :  IN STD_LOGIC := 'X';
        DIS    :  IN STD_LOGIC := 'X');

end component;

component UJTAG
      generic(
      tipd_UTDO      : VitalDelayType01 := (  0.0 ns,0.0 ns );
      tipd_TMS       : VitalDelayType01 := (  0.0 ns,0.0 ns );
      tipd_TDI       : VitalDelayType01 := (  0.0 ns,0.0 ns );
      tipd_TCK       : VitalDelayType01 := (  0.0 ns,0.0 ns );
      tipd_TRSTB     : VitalDelayType01 := (  0.0 ns,0.0 ns );

      TimingChecksOn : Boolean := True;
      InstancePath   : String  := "*";
      Xon            : Boolean := False;
      MsgOn          : Boolean := True);

    port(
      UTDO           :  in    STD_ULOGIC;
      TMS            :  in    STD_ULOGIC;
      TDI            :  in    STD_ULOGIC;
      TCK            :  in    STD_ULOGIC;
      TRSTB          :  in    STD_ULOGIC;
      UIREG0         :  out   STD_ULOGIC;
      UIREG1         :  out   STD_ULOGIC;
      UIREG2         :  out   STD_ULOGIC;
      UIREG3         :  out   STD_ULOGIC;
      UIREG4         :  out   STD_ULOGIC;
      UIREG5         :  out   STD_ULOGIC;
      UIREG6         :  out   STD_ULOGIC;
      UIREG7         :  out   STD_ULOGIC;
      UTDI           :  out   STD_ULOGIC;
      URSTB          :  out   STD_ULOGIC;
      UDRCK          :  out   STD_ULOGIC;
      UDRSH          :  out   STD_ULOGIC;
      UDRUPD         :  out   STD_ULOGIC;
      TDO            :  out   STD_ULOGIC);
end component;

end COMPONENTS;

--------------------- END OF COMPONENTS PACKAGE SECTION  ----------------

library IEEE;
use IEEE.STD_LOGIC_1164.all;

use IEEE.VITAL_Timing.all;
use IEEE.VITAL_Primitives.all;

package VTABLES is

   CONSTANT L : VitalTableSymbolType := '0';
   CONSTANT H : VitalTableSymbolType := '1';
   CONSTANT x : VitalTableSymbolType := '-';
   CONSTANT S : VitalTableSymbolType := 'S';
   CONSTANT R : VitalTableSymbolType := '/';
   CONSTANT U : VitalTableSymbolType := 'X';
   CONSTANT V : VitalTableSymbolType := 'B'; -- valid clock signal (non-rising)

-- CLR_ipd, CLK_delayed, Q_zd, D, E_delayed, PRE_ipd, CLK_ipd
CONSTANT DFEG_Q_tab : VitalStateTableType := (
( L,  x,  x,  x,  x,  x,  x,  x,  L ),
( H,  L,  H,  H,  x,  x,  H,  x,  H ),
( H,  L,  H,  x,  H,  x,  H,  x,  H ),
( H,  L,  x,  H,  L,  x,  H,  x,  H ),
( H,  H,  x,  x,  x,  H,  x,  x,  S ),
( H,  x,  x,  x,  x,  L,  x,  x,  H ),
( H,  x,  x,  x,  x,  H,  L,  x,  S ),
( x,  L,  L,  L,  x,  H,  H,  x,  L ),
( x,  L,  L,  x,  H,  H,  H,  x,  L ),
( x,  L,  x,  L,  L,  H,  H,  x,  L ),
( U,  x,  L,  x,  x,  H,  x,  x,  L ),
( H,  x,  H,  x,  x,  U,  x,  x,  H )); 

-- CLR_ipd, CLK_delayed, T_delayed, Q_zd, CLK_ipd
CONSTANT tflipflop_Q_tab : VitalStateTableType := (
( L,  x,  x,  x,  x,  x,  L ),
( H,  L,  L,  H,  H,  x,  H ),
( H,  L,  H,  L,  H,  x,  H ),
( H,  H,  x,  x,  x,  x,  S ),
( H,  x,  x,  x,  L,  x,  S ),
( x,  L,  L,  L,  H,  x,  L ),
( x,  L,  H,  H,  H,  x,  L ));

-- CLR_ipd, CLK_delayed, PRE_delayed,K_delayed,J_delayed, Q_zd, CLK_ipd
CONSTANT jkflipflop_Q_tab : VitalStateTableType := (
( L,  x,  H,  x,  x,  x,  x,  x,  U ),
( L,  x,  L,  x,  x,  x,  x,  x,  L ),
( H,  L,  x,  L,  H,  x,  H,  x,  H ),
( H,  L,  x,  L,  x,  H,  H,  x,  H ),
( H,  L,  x,  x,  H,  L,  H,  x,  H ),
( H,  H,  L,  x,  x,  x,  x,  x,  S ),
( H,  x,  L,  x,  x,  x,  L,  x,  S ),
( H,  x,  H,  x,  x,  x,  x,  x,  H ),
( x,  L,  L,  H,  L,  x,  H,  x,  L ),
( x,  L,  L,  H,  x,  H,  H,  x,  L ),
( x,  L,  L,  x,  L,  L,  H,  x,  L ),
( U,  x,  L,  x,  x,  L,  x,  x,  L ),
( H,  x,  U,  x,  x,  H,  x,  x,  H ));

CONSTANT JKF2A_Q_tab : VitalStateTableType := (
( L,  x,  x,  x,  x,  x,  x,  L ),
( H,  L,  L,  H,  x,  H,  x,  H ),
( H,  L,  L,  x,  H,  H,  x,  H ),
( H,  L,  x,  H,  L,  H,  x,  H ),
( H,  H,  x,  x,  x,  x,  x,  S ),
( H,  x,  x,  x,  x,  L,  x,  S ),
( x,  L,  H,  L,  x,  H,  x,  L ),
( x,  L,  H,  x,  H,  H,  x,  L ),
( x,  L,  x,  L,  L,  H,  x,  L ),
( U,  x,  x,  x,  L,  x,  x,  L ));

CONSTANT JKF3A_Q_tab : VitalStateTableType := (
( L,  H,  L,  x,  H,  H,  x,  L ),
( L,  H,  x,  H,  H,  H,  x,  L ),
( L,  L,  H,  x,  x,  H,  x,  H ),
( L,  L,  x,  H,  x,  H,  x,  H ),
( L,  x,  L,  L,  H,  H,  x,  L ),
( L,  x,  H,  L,  x,  H,  x,  H ),
( H,  x,  x,  x,  H,  x,  x,  S ),
( x,  x,  x,  x,  L,  x,  x,  H ),
( x,  x,  x,  x,  H,  L,  x,  S ),
( x,  x,  x,  H,  U,  x,  x,  H ));

CONSTANT dlatch_DLE3B_Q_tab : VitalStateTableType := (
( x,  x,  x,  H,  x,  H ),   --active high preset

( H,  x,  x,  L,  x,  S ),   --latch
( x,  H,  x,  L,  x,  S ),   --latch

( L,  L,  H,  L,  x,  H ),   --transparent
( L,  L,  L,  L,  x,  L ),   --transparent

( U,  x,  H,  L,  H,  H ),   --o/p mux pessimism
( x,  U,  H,  L,  H,  H ),   --o/p mux pessimism
( U,  x,  L,  L,  L,  L ),   --o/p mux pessimism
( x,  U,  L,  L,  L,  L ),   --o/p mux pessimism

( L,  L,  H,  U,  x,  H ),   --PRE==X
( H,  x,  x,  U,  H,  H ),   --PRE==X
( x,  H,  x,  U,  H,  H ),   --PRE==X
( L,  U,  H,  U,  H,  H ),   --PRE==X
( U,  L,  H,  U,  H,  H ),   --PRE==X
( U,  U,  H,  U,  H,  H ));  --PRE==X
--G, E, D, P, Qn, Qn+1

CONSTANT dlatch_DLE2B_Q_tab : VitalStateTableType := (
( L,  x,  x,  x,  x,  L ),   --active low clear

( H,  H,  x,  x,  x,  S ),   --latch
( H,  x,  H,  x,  x,  S ),   --latch

( H,  L,  L,  H,  x,  H ),   --transparent
( H,  L,  L,  L,  x,  L ),   --transparent

( H,  x,  x,  L,  L,  L ),   --o/p mux pessimism
( H,  x,  x,  H,  H,  H ),   --o/p mux pessimism

( U,  x,  x,  L,  L,  L ),   --CLR==X, o/p mux pessimism
( U,  H,  x,  x,  L,  L ),   --CLR==X, o/p mux pessimism, latch
( U,  x,  H,  x,  L,  L ),   --CLR==X, o/p mux pessimism, latch
( U,  L,  L,  L,  x,  L ));  --CLR==X, i/p mux pessimism
--C, G, E, D, Qn, Qn+1


CONSTANT dlatch_DL2C_Q_tab : VitalStateTableType := (
( L,  x,  x,  x,  x,  L ),   --active low clear
( H,  x,  x,  H,  x,  H ),   --active high preset

( H,  H,  x,  L,  x,  S ),   --latch
( H,  L,  L,  L,  x,  L ),   --transparent

( U,  L,  L,  L,  x,  L ),   --CLR==U
( U,  H,  x,  L,  L,  L ),   --CLR==U
( x,  U,  L,  L,  L,  L ),   --CLR,G==U

( H,  U,  H,  x,  H,  H ),   --PRE==U/x,G==U
( H,  L,  H,  x,  x,  H ),   --PRE==U/x
( H,  H,  x,  U,  H,  H ));  --PRE==U
--CLR, G, D, PRE, Qn, Qn+1

end VTABLES;



--------------------- END OF VITABLE TABLE SECTION  ----------------



 ---- CELL AND2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND2 :  entity is True;
 end AND2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of AND2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( A_ipd  AND  B_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND2_VITAL of AND2 is 
    for VITAL_ACT
    end for;
 end CFG_AND2_VITAL;



 ---- CELL AND2FT ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND2FT is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND2FT :  entity is True;
 end AND2FT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of AND2FT is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( (NOT A_ipd)  AND  B_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND2FT_VITAL of AND2FT is 
    for VITAL_ACT
    end for;
 end CFG_AND2FT_VITAL;



 ---- CELL AND3 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND3 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND3 :  entity is True;
 end AND3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of AND3 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  B_ipd ) AND  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND3_VITAL of AND3 is 
    for VITAL_ACT
    end for;
 end CFG_AND3_VITAL;



 ---- CELL AND3FFT ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND3FFT is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND3FFT :  entity is True;
 end AND3FFT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of AND3FFT is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND3FFT_VITAL of AND3FFT is 
    for VITAL_ACT
    end for;
 end CFG_AND3FFT_VITAL;



 ---- CELL AND3FTT ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND3FTT is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND3FTT :  entity is True;
 end AND3FTT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of AND3FTT is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  B_ipd ) AND  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND3FTT_VITAL of AND3FTT is 
    for VITAL_ACT
    end for;
 end CFG_AND3FTT_VITAL;



 ---- CELL AO21 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO21 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO21 :  entity is True;
 end AO21;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of AO21 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  B_ipd ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO21_VITAL of AO21 is 
    for VITAL_ACT
    end for;
 end CFG_AO21_VITAL;



 ---- CELL AO21FTF ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO21FTF is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO21FTF :  entity is True;
 end AO21FTF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of AO21FTF is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  B_ipd ) OR  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO21FTF_VITAL of AO21FTF is 
    for VITAL_ACT
    end for;
 end CFG_AO21FTF_VITAL;



 ---- CELL AO21FTT ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO21FTT is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO21FTT :  entity is True;
 end AO21FTT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of AO21FTT is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  B_ipd ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO21FTT_VITAL of AO21FTT is 
    for VITAL_ACT
    end for;
 end CFG_AO21FTT_VITAL;



 ---- CELL AO21TTF ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO21TTF is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO21TTF :  entity is True;
 end AO21TTF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of AO21TTF is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  B_ipd ) OR  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO21TTF_VITAL of AO21TTF is 
    for VITAL_ACT
    end for;
 end CFG_AO21TTF_VITAL;



 ---- CELL AOI21 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI21 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI21 :  entity is True;
 end AOI21;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of AOI21 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, C_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  (NOT C_ipd) ) OR ( (NOT B_ipd)  AND  (NOT C_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (C_ipd'last_event,tpd_C_Y, true),
	             2 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI21_VITAL of AOI21 is 
    for VITAL_ACT
    end for;
 end CFG_AOI21_VITAL;



 ---- CELL AOI21FTF ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI21FTF is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI21FTF :  entity is True;
 end AOI21FTF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of AOI21FTF is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, C_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  C_ipd ) OR ( (NOT B_ipd)  AND  C_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (C_ipd'last_event,tpd_C_Y, true),
	             2 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI21FTF_VITAL of AOI21FTF is 
    for VITAL_ACT
    end for;
 end CFG_AOI21FTF_VITAL;



 ---- CELL AOI21FTT ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI21FTT is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI21FTT :  entity is True;
 end AOI21FTT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of AOI21FTT is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, C_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  (NOT C_ipd) ) OR ( (NOT B_ipd)  AND  (NOT C_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (C_ipd'last_event,tpd_C_Y, true),
	             2 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI21FTT_VITAL of AOI21FTT is 
    for VITAL_ACT
    end for;
 end CFG_AOI21FTT_VITAL;



 ---- CELL AOI21TTF ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI21TTF is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI21TTF :  entity is True;
 end AOI21TTF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of AOI21TTF is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, C_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  C_ipd ) OR ( (NOT B_ipd)  AND  C_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (C_ipd'last_event,tpd_C_Y, true),
	             2 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI21TTF_VITAL of AOI21TTF is 
    for VITAL_ACT
    end for;
 end CFG_AOI21TTF_VITAL;



 ---- CELL BFR ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BFR is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BFR :  entity is True;
 end BFR;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of BFR is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BFR_VITAL of BFR is 
    for VITAL_ACT
    end for;
 end CFG_BFR_VITAL;



 ---- CELL BUBBLE ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BUBBLE is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BUBBLE :  entity is True;
 end BUBBLE;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of BUBBLE is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  (NOT A_ipd) ;


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BUBBLE_VITAL of BUBBLE is 
    for VITAL_ACT
    end for;
 end CFG_BUBBLE_VITAL;



 ---- CELL DMUX ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DMUX is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of DMUX :  entity is True;
 end DMUX;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of DMUX is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL S_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (S_ipd, S, tipd_S);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, S_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( A_ipd , B_ipd , (NOT S_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (S_ipd'last_event,tpd_S_Y, true),
	             2 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_DMUX_VITAL of DMUX is 
    for VITAL_ACT
    end for;
 end CFG_DMUX_VITAL;



 ---- CELL GL25 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GL25 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GL25 :  entity is True;
 end GL25;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of GL25 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS GL_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE GL_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        GL_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => GL,
	   GlitchData => GL_GlitchData,
	   OutSignalName => "GL",
	   OutTemp => GL_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_GL, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_GL25_VITAL of GL25 is 
    for VITAL_ACT
    end for;
 end CFG_GL25_VITAL;



 ---- CELL GL25LP ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GL25LP is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GL25LP :  entity is True;
 end GL25LP;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of GL25LP is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS GL_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE GL_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        GL_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => GL,
	   GlitchData => GL_GlitchData,
	   OutSignalName => "GL",
	   OutTemp => GL_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_GL, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_GL25LP_VITAL of GL25LP is 
    for VITAL_ACT
    end for;
 end CFG_GL25LP_VITAL;



 ---- CELL GL25LPU ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GL25LPU is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GL25LPU :  entity is True;
 end GL25LPU;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of GL25LPU is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE PAD_ipd2 : STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS GL_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE GL_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_ipd2 := VitalIdent (data => PAD_ipd,
                              ResultMap => ('U','X','0','1','H'));
        GL_zd := TO_X01(PAD_ipd2);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => GL,
	   GlitchData => GL_GlitchData,
	   OutSignalName => "GL",
	   OutTemp => GL_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_GL, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_GL25LPU_VITAL of GL25LPU is 
    for VITAL_ACT
    end for;
 end CFG_GL25LPU_VITAL;



 ---- CELL GL25U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GL25U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GL25U :  entity is True;
 end GL25U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of GL25U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE PAD_ipd2 : STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS GL_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE GL_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_ipd2 := VitalIdent (data => PAD_ipd,
                              ResultMap => ('U','X','0','1','H'));
        GL_zd := TO_X01(PAD_ipd2);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => GL,
	   GlitchData => GL_GlitchData,
	   OutSignalName => "GL",
	   OutTemp => GL_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_GL, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_GL25U_VITAL of GL25U is 
    for VITAL_ACT
    end for;
 end CFG_GL25U_VITAL;



 ---- CELL GL33 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GL33 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GL33 :  entity is True;
 end GL33;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of GL33 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS GL_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE GL_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        GL_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => GL,
	   GlitchData => GL_GlitchData,
	   OutSignalName => "GL",
	   OutTemp => GL_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_GL, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_GL33_VITAL of GL33 is 
    for VITAL_ACT
    end for;
 end CFG_GL33_VITAL;



 ---- CELL GL33U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GL33U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GL33U :  entity is True;
 end GL33U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of GL33U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE PAD_ipd2 : STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS GL_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE GL_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_ipd2 := VitalIdent (data => PAD_ipd,
                              ResultMap => ('U','X','0','1','H'));
        GL_zd := TO_X01(PAD_ipd2);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => GL,
	   GlitchData => GL_GlitchData,
	   OutSignalName => "GL",
	   OutTemp => GL_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_GL, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_GL33U_VITAL of GL33U is 
    for VITAL_ACT
    end for;
 end CFG_GL33U_VITAL;



 ---- CELL GLINT ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GLINT is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GLINT :  entity is True;
 end GLINT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of GLINT is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS GL_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE GL_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        GL_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => GL,
	   GlitchData => GL_GlitchData,
	   OutSignalName => "GL",
	   OutTemp => GL_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_GL, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_GLINT_VITAL of GLINT is 
    for VITAL_ACT
    end for;
 end CFG_GLINT_VITAL;



 ---- CELL GND ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GND is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True		);
    port(
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GND :  entity is True;
 end GND;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of GND is
	attribute VITAL_LEVEL0 of VITAL_ACT : architecture is True;


begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	--- Empty
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
        Y<= '0';


end VITAL_ACT;

 configuration CFG_GND_VITAL of GND is 
    for VITAL_ACT
    end for;
 end CFG_GND_VITAL;



 ---- CELL IB25 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity IB25 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of IB25 :  entity is True;
 end IB25;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of IB25 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_IB25_VITAL of IB25 is 
    for VITAL_ACT
    end for;
 end CFG_IB25_VITAL;



 ---- CELL IB25LP ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity IB25LP is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of IB25LP :  entity is True;
 end IB25LP;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of IB25LP is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_IB25LP_VITAL of IB25LP is 
    for VITAL_ACT
    end for;
 end CFG_IB25LP_VITAL;



 ---- CELL IB25LPU ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity IB25LPU is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of IB25LPU :  entity is True;
 end IB25LPU;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of IB25LPU is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE PAD_ipd2 : STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_ipd2 := VitalIdent (data => PAD_ipd,
                              ResultMap => ('U','X','0','1','H'));
        Y_zd := TO_X01(PAD_ipd2);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_IB25LPU_VITAL of IB25LPU is 
    for VITAL_ACT
    end for;
 end CFG_IB25LPU_VITAL;



 ---- CELL IB25U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity IB25U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of IB25U :  entity is True;
 end IB25U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of IB25U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE PAD_ipd2 : STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_ipd2 := VitalIdent (data => PAD_ipd,
                              ResultMap => ('U','X','0','1','H'));
        Y_zd := TO_X01(PAD_ipd2);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_IB25U_VITAL of IB25U is 
    for VITAL_ACT
    end for;
 end CFG_IB25U_VITAL;



 ---- CELL IB33 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity IB33 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of IB33 :  entity is True;
 end IB33;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of IB33 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_IB33_VITAL of IB33 is 
    for VITAL_ACT
    end for;
 end CFG_IB33_VITAL;



 ---- CELL IB33U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity IB33U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of IB33U :  entity is True;
 end IB33U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of IB33U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE PAD_ipd2 : STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_ipd2 := VitalIdent (data => PAD_ipd,
                              ResultMap => ('U','X','0','1','H'));
        Y_zd := TO_X01(PAD_ipd2);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_IB33U_VITAL of IB33U is 
    for VITAL_ACT
    end for;
 end CFG_IB33U_VITAL;



 ---- CELL INV ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity INV is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of INV :  entity is True;
 end INV;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of INV is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  (NOT A_ipd) ;


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_INV_VITAL of INV is 
    for VITAL_ACT
    end for;
 end CFG_INV_VITAL;



 ---- CELL LD ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity LD is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_EN_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_negedge		:VitalDelayType := 0.000 ns;
		tpw_EN_posedge		:  VitalDelayType := 0.000 ns;
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of LD :  entity is True;
 end LD;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of LD is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL EN_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (EN_ipd,EN, tipd_EN);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, EN_ipd)

	-- timing check results
	VARIABLE Tviol_D_EN_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_EN_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_EN	: STD_ULOGIC := '0';
	VARIABLE PInfo_EN	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS Q_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_EN_negedge,
	 TimingData		=> Tmkr_D_EN_negedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_EN_posedge_negedge,
	 SetupLow		=> tsetup_D_EN_negedge_negedge,
	 HoldHigh		=> thold_D_EN_posedge_negedge,
	 HoldLow		=> thold_D_EN_negedge_negedge,
	 CheckEnabled		=>  True, 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/LD",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_EN,
	 PeriodData		=> PInfo_EN,
	 TestSignal		=> EN_ipd,
	 TestSignalName		=> "EN",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_EN_negedge,
	 PulseWidthHigh		=> tpw_EN_posedge,
	 PulseWidthLow          => 0 ns,
	 CheckEnabled		=>  True, 
	 HeaderMsg		=> InstancePath & "LD",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_EN_negedge or Pviol_EN;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		'1',(NOT EN_ipd),D_ipd,'0'));
	 Q_zd := Violation XOR Q_zd;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_Q, true),
		    1 => (EN_ipd'last_event, tpd_EN_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_LD_VITAL of LD is
   for VITAL_ACT
   end for;
end CFG_LD_VITAL;



 ---- CELL LDB ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity LDB is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_SET_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_negedge		:VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		SET		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of LDB :  entity is True;
 end LDB;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of LDB is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL SET_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL EN_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (SET_ipd,SET, tipd_SET);
	VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	VitalWireDelay (EN_ipd,EN, tipd_EN);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, SET_ipd,CLR_ipd,EN_ipd)

	-- timing check results
	VARIABLE Tviol_D_EN_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_EN_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_SET_EN_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_SET_EN_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_EN_negedge	: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_EN_negedge         : VitalTimingDataType	:= VitalTimingDataInit;
	VARIABLE Pviol_EN	: STD_ULOGIC := '0';
	VARIABLE PInfo_EN	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_SET	: STD_ULOGIC := '0';
	VARIABLE PInfo_SET	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS Q_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_EN_negedge,
	 TimingData		=> Tmkr_D_EN_negedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_EN_posedge_negedge,
	 SetupLow		=> tsetup_D_EN_negedge_negedge,
	 HoldHigh		=> thold_D_EN_posedge_negedge,
	 HoldLow		=> thold_D_EN_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) OR (SET_ipd) ) ) /= '1', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/LDB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_CLR_EN_negedge,
	 TimingData		=> Tmkr_CLR_EN_negedge,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_CLR_EN_negedge_negedge,
	 Removal		=> thold_CLR_EN_negedge_negedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  TO_X01(( NOT SET_ipd)) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "LDB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_SET_EN_negedge,
	 TimingData		=> Tmkr_SET_EN_negedge,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_SET_EN_negedge_negedge,
	 Removal		=> thold_SET_EN_negedge_negedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  TO_X01(( NOT CLR_ipd)) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "LDB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_EN,
	 PeriodData		=> PInfo_EN,
	 TestSignal		=> EN_ipd,
	 TestSignalName		=> "EN",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_EN_negedge,
	 PulseWidthHigh		=> tpw_EN_posedge,
	 PulseWidthLow          => 0 ns,
	 CheckEnabled		=>  TO_X01(((NOT CLR_ipd) AND (NOT SET_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "LDB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData		=> PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_CLR_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> True,
	 HeaderMsg		=> InstancePath & "LDB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_SET,
	 PeriodData		=> PInfo_SET,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_SET_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=>  TO_X01( NOT CLR_ipd) /='0',
	 HeaderMsg		=> InstancePath & "LDB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_EN_negedge or Tviol_SET_EN_negedge or Pviol_SET or 
		       Pviol_CLR or Pviol_EN;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		 (NOT CLR_ipd),(NOT EN_ipd),D_ipd,SET_ipd));
	 Q_zd := Violation XOR Q_zd;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_Q, true),
		     1 => (SET_ipd'last_event, tpd_SET_Q, true),
		    2 => (CLR_ipd'last_event, tpd_CLR_Q, true),
		    3 => (EN_ipd'last_event, tpd_EN_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_LDB_VITAL of LDB is
   for VITAL_ACT
   end for;
end CFG_LDB_VITAL;



 ---- CELL LDBI ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity LDBI is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_SET_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_negedge		:VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		SET		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of LDBI :  entity is True;
 end LDBI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of LDBI is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL SET_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL EN_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (SET_ipd,SET, tipd_SET);
	VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	VitalWireDelay (EN_ipd,EN, tipd_EN);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, SET_ipd,CLR_ipd,EN_ipd)

	-- timing check results
	VARIABLE Tviol_D_EN_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_EN_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_SET_EN_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_SET_EN_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_EN_negedge	: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_EN_negedge         : VitalTimingDataType	:= VitalTimingDataInit;
	VARIABLE Pviol_EN	: STD_ULOGIC := '0';
	VARIABLE PInfo_EN	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_SET	: STD_ULOGIC := '0';
	VARIABLE PInfo_SET	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE QBAR_temp	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS QBAR_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE QBAR_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_EN_negedge,
	 TimingData		=> Tmkr_D_EN_negedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_EN_posedge_negedge,
	 SetupLow		=> tsetup_D_EN_negedge_negedge,
	 HoldHigh		=> thold_D_EN_posedge_negedge,
	 HoldLow		=> thold_D_EN_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) OR (SET_ipd) ) ) /= '1', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/LDBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_CLR_EN_negedge,
	 TimingData		=> Tmkr_CLR_EN_negedge,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_CLR_EN_negedge_negedge,
	 Removal		=> thold_CLR_EN_negedge_negedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  TO_X01(( NOT SET_ipd)) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "LDBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_SET_EN_negedge,
	 TimingData		=> Tmkr_SET_EN_negedge,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_SET_EN_negedge_negedge,
	 Removal		=> thold_SET_EN_negedge_negedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  TO_X01(( NOT CLR_ipd)) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "LDBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_EN,
	 PeriodData		=> PInfo_EN,
	 TestSignal		=> EN_ipd,
	 TestSignalName		=> "EN",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_EN_negedge,
	 PulseWidthHigh		=> tpw_EN_posedge,
	 PulseWidthLow          => 0 ns,
	 CheckEnabled		=>  TO_X01(((NOT CLR_ipd) AND (NOT SET_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "LDBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData		=> PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_CLR_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> True,
	 HeaderMsg		=> InstancePath & "LDBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_SET,
	 PeriodData		=> PInfo_SET,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_SET_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=>  TO_X01( NOT CLR_ipd) /='0',
	 HeaderMsg		=> InstancePath & "LDBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_EN_negedge or Tviol_SET_EN_negedge or Pviol_SET or 
		       Pviol_CLR or Pviol_EN;

	VitalStateTable(
	 Result => QBAR_temp,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		 (NOT CLR_ipd),(NOT EN_ipd),D_ipd,SET_ipd));
	 QBAR_zd := Violation XOR NOT QBAR_temp;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => QBAR,
	 GlitchData => QBAR_GlitchData,
	 OutSignalName => "QBAR",
	 OutTemp => QBAR_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_QBAR, true),
		     1 => (SET_ipd'last_event, tpd_SET_QBAR, true),
		    2 => (CLR_ipd'last_event, tpd_CLR_QBAR, true),
		    3 => (EN_ipd'last_event, tpd_EN_QBAR, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_LDBI_VITAL of LDBI is
   for VITAL_ACT
   end for;
end CFG_LDBI_VITAL;



 ---- CELL LDC ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity LDC is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_negedge		:VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of LDC :  entity is True;
 end LDC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of LDC is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL EN_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	VitalWireDelay (EN_ipd,EN, tipd_EN);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, CLR_ipd,EN_ipd)

	-- timing check results
	VARIABLE Tviol_D_EN_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_EN_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_EN_negedge	: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_EN_negedge         : VitalTimingDataType	:= VitalTimingDataInit;
	VARIABLE Pviol_EN	: STD_ULOGIC := '0';
	VARIABLE PInfo_EN	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS Q_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_EN_negedge,
	 TimingData		=> Tmkr_D_EN_negedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_EN_posedge_negedge,
	 SetupLow		=> tsetup_D_EN_negedge_negedge,
	 HoldHigh		=> thold_D_EN_posedge_negedge,
	 HoldLow		=> thold_D_EN_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) ) ) /= '1', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/LDC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_CLR_EN_negedge,
	 TimingData		=> Tmkr_CLR_EN_negedge,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_CLR_EN_negedge_negedge,
	 Removal		=> thold_CLR_EN_negedge_negedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  True,
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "LDC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_EN,
	 PeriodData		=> PInfo_EN,
	 TestSignal		=> EN_ipd,
	 TestSignalName		=> "EN",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_EN_negedge,
	 PulseWidthHigh		=> tpw_EN_posedge,
	 PulseWidthLow          => 0 ns,
	 CheckEnabled		=>  TO_X01(((NOT CLR_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "LDC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData		=> PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_CLR_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> True,
	 HeaderMsg		=> InstancePath & "LDC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_EN_negedge or Pviol_CLR or Pviol_EN;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		 (NOT CLR_ipd),(NOT EN_ipd),D_ipd,'0'));
	 Q_zd := Violation XOR Q_zd;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_Q, true),
		    1 => (CLR_ipd'last_event, tpd_CLR_Q, true),
		    2 => (EN_ipd'last_event, tpd_EN_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_LDC_VITAL of LDC is
   for VITAL_ACT
   end for;
end CFG_LDC_VITAL;



 ---- CELL LDCI ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity LDCI is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_negedge		:VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of LDCI :  entity is True;
 end LDCI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of LDCI is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL EN_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	VitalWireDelay (EN_ipd,EN, tipd_EN);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, CLR_ipd,EN_ipd)

	-- timing check results
	VARIABLE Tviol_D_EN_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_EN_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_EN_negedge	: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_EN_negedge         : VitalTimingDataType	:= VitalTimingDataInit;
	VARIABLE Pviol_EN	: STD_ULOGIC := '0';
	VARIABLE PInfo_EN	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE QBAR_temp	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS QBAR_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE QBAR_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_EN_negedge,
	 TimingData		=> Tmkr_D_EN_negedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_EN_posedge_negedge,
	 SetupLow		=> tsetup_D_EN_negedge_negedge,
	 HoldHigh		=> thold_D_EN_posedge_negedge,
	 HoldLow		=> thold_D_EN_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) ) ) /= '1', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/LDCI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_CLR_EN_negedge,
	 TimingData		=> Tmkr_CLR_EN_negedge,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_CLR_EN_negedge_negedge,
	 Removal		=> thold_CLR_EN_negedge_negedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  True,
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "LDCI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_EN,
	 PeriodData		=> PInfo_EN,
	 TestSignal		=> EN_ipd,
	 TestSignalName		=> "EN",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_EN_negedge,
	 PulseWidthHigh		=> tpw_EN_posedge,
	 PulseWidthLow          => 0 ns,
	 CheckEnabled		=>  TO_X01(((NOT CLR_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "LDCI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData		=> PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_CLR_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> True,
	 HeaderMsg		=> InstancePath & "LDCI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_EN_negedge or Pviol_CLR or Pviol_EN;

	VitalStateTable(
	 Result => QBAR_temp,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		 (NOT CLR_ipd),(NOT EN_ipd),D_ipd,'0'));
	 QBAR_zd := Violation XOR NOT QBAR_temp;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => QBAR,
	 GlitchData => QBAR_GlitchData,
	 OutSignalName => "QBAR",
	 OutTemp => QBAR_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_QBAR, true),
		    1 => (CLR_ipd'last_event, tpd_CLR_QBAR, true),
		    2 => (EN_ipd'last_event, tpd_EN_QBAR, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_LDCI_VITAL of LDCI is
   for VITAL_ACT
   end for;
end CFG_LDCI_VITAL;



 ---- CELL LDI ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity LDI is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_EN_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_negedge		:VitalDelayType := 0.000 ns;
		tpw_EN_posedge		:  VitalDelayType := 0.000 ns;
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of LDI :  entity is True;
 end LDI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of LDI is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL EN_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (EN_ipd,EN, tipd_EN);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, EN_ipd)

	-- timing check results
	VARIABLE Tviol_D_EN_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_EN_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_EN	: STD_ULOGIC := '0';
	VARIABLE PInfo_EN	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE QBAR_temp	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS QBAR_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE QBAR_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_EN_negedge,
	 TimingData		=> Tmkr_D_EN_negedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_EN_posedge_negedge,
	 SetupLow		=> tsetup_D_EN_negedge_negedge,
	 HoldHigh		=> thold_D_EN_posedge_negedge,
	 HoldLow		=> thold_D_EN_negedge_negedge,
	 CheckEnabled		=>  True, 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/LDI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_EN,
	 PeriodData		=> PInfo_EN,
	 TestSignal		=> EN_ipd,
	 TestSignalName		=> "EN",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_EN_negedge,
	 PulseWidthHigh		=> tpw_EN_posedge,
	 PulseWidthLow          => 0 ns,
	 CheckEnabled		=>  True, 
	 HeaderMsg		=> InstancePath & "LDI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_EN_negedge or Pviol_EN;

	VitalStateTable(
	 Result => QBAR_temp,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		'1',(NOT EN_ipd),D_ipd,'0'));
	 QBAR_zd := Violation XOR NOT QBAR_temp;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => QBAR,
	 GlitchData => QBAR_GlitchData,
	 OutSignalName => "QBAR",
	 OutTemp => QBAR_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_QBAR, true),
		    1 => (EN_ipd'last_event, tpd_EN_QBAR, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_LDI_VITAL of LDI is
   for VITAL_ACT
   end for;
end CFG_LDI_VITAL;



 ---- CELL LDL ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity LDL is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_EN_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_negedge		:  VitalDelayType := 0.000 ns;
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of LDL :  entity is True;
 end LDL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of LDL is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL EN_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (EN_ipd,EN, tipd_EN);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, EN_ipd)

	-- timing check results
	VARIABLE Tviol_D_EN_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_EN_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_EN	: STD_ULOGIC := '0';
	VARIABLE PInfo_EN	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS Q_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_EN_posedge,
	 TimingData		=> Tmkr_D_EN_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_EN_posedge_posedge,
	 SetupLow		=> tsetup_D_EN_negedge_posedge,
	 HoldHigh		=> thold_D_EN_posedge_posedge,
	 HoldLow		=> thold_D_EN_negedge_posedge,
	 CheckEnabled		=>  True, 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/LDL",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_EN,
	 PeriodData		=> PInfo_EN,
	 TestSignal		=> EN_ipd,
	 TestSignalName		=> "EN",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_EN_posedge,
	 PulseWidthHigh         => 0 ns,
	 PulseWidthLow		=> tpw_EN_negedge,
	 CheckEnabled		=>  True, 
	 HeaderMsg		=> InstancePath & "LDL",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_EN_posedge or Pviol_EN;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		'1',EN_ipd,D_ipd,'0'));
	 Q_zd := Violation XOR Q_zd;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_Q, true),
		    1 => (EN_ipd'last_event, tpd_EN_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_LDL_VITAL of LDL is
   for VITAL_ACT
   end for;
end CFG_LDL_VITAL;



 ---- CELL LDLB ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity LDLB is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_SET_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_posedge		:  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_negedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		SET		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of LDLB :  entity is True;
 end LDLB;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of LDLB is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL SET_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL EN_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (SET_ipd,SET, tipd_SET);
	VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	VitalWireDelay (EN_ipd,EN, tipd_EN);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, SET_ipd,CLR_ipd,EN_ipd)

	-- timing check results
	VARIABLE Tviol_D_EN_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_EN_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_SET_EN_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_SET_EN_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_EN_posedge	: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_EN_posedge         : VitalTimingDataType	:= VitalTimingDataInit;
	VARIABLE Pviol_EN	: STD_ULOGIC := '0';
	VARIABLE PInfo_EN	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_SET	: STD_ULOGIC := '0';
	VARIABLE PInfo_SET	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS Q_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_EN_posedge,
	 TimingData		=> Tmkr_D_EN_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_EN_posedge_posedge,
	 SetupLow		=> tsetup_D_EN_negedge_posedge,
	 HoldHigh		=> thold_D_EN_posedge_posedge,
	 HoldLow		=> thold_D_EN_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) OR (SET_ipd) ) ) /= '1', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/LDLB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_CLR_EN_posedge,
	 TimingData		=> Tmkr_CLR_EN_posedge,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_CLR_EN_negedge_posedge,
	 Removal		=> thold_CLR_EN_negedge_posedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  TO_X01(( NOT SET_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "LDLB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_SET_EN_posedge,
	 TimingData		=> Tmkr_SET_EN_posedge,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_SET_EN_negedge_posedge,
	 Removal		=> thold_SET_EN_negedge_posedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  TO_X01(( NOT CLR_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "LDLB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_EN,
	 PeriodData		=> PInfo_EN,
	 TestSignal		=> EN_ipd,
	 TestSignalName		=> "EN",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_EN_posedge,
	 PulseWidthHigh         => 0 ns,
	 PulseWidthLow		=> tpw_EN_negedge,
	 CheckEnabled		=>  TO_X01(((NOT CLR_ipd) AND (NOT SET_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "LDLB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData		=> PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_CLR_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> True,
	 HeaderMsg		=> InstancePath & "LDLB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_SET,
	 PeriodData		=> PInfo_SET,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_SET_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=>  TO_X01( NOT CLR_ipd) /='0',
	 HeaderMsg		=> InstancePath & "LDLB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_EN_posedge or Tviol_SET_EN_posedge or Pviol_SET or 
		       Pviol_CLR or Pviol_EN;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		 (NOT CLR_ipd),EN_ipd,D_ipd,SET_ipd));
	 Q_zd := Violation XOR Q_zd;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_Q, true),
		     1 => (SET_ipd'last_event, tpd_SET_Q, true),
		    2 => (CLR_ipd'last_event, tpd_CLR_Q, true),
		    3 => (EN_ipd'last_event, tpd_EN_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_LDLB_VITAL of LDLB is
   for VITAL_ACT
   end for;
end CFG_LDLB_VITAL;



 ---- CELL LDLBI ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity LDLBI is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_SET_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_posedge		:  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_negedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		SET		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of LDLBI :  entity is True;
 end LDLBI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of LDLBI is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL SET_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL EN_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (SET_ipd,SET, tipd_SET);
	VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	VitalWireDelay (EN_ipd,EN, tipd_EN);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, SET_ipd,CLR_ipd,EN_ipd)

	-- timing check results
	VARIABLE Tviol_D_EN_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_EN_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_SET_EN_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_SET_EN_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_EN_posedge	: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_EN_posedge         : VitalTimingDataType	:= VitalTimingDataInit;
	VARIABLE Pviol_EN	: STD_ULOGIC := '0';
	VARIABLE PInfo_EN	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_SET	: STD_ULOGIC := '0';
	VARIABLE PInfo_SET	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE QBAR_temp	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS QBAR_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE QBAR_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_EN_posedge,
	 TimingData		=> Tmkr_D_EN_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_EN_posedge_posedge,
	 SetupLow		=> tsetup_D_EN_negedge_posedge,
	 HoldHigh		=> thold_D_EN_posedge_posedge,
	 HoldLow		=> thold_D_EN_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) OR (SET_ipd) ) ) /= '1', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/LDLBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_CLR_EN_posedge,
	 TimingData		=> Tmkr_CLR_EN_posedge,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_CLR_EN_negedge_posedge,
	 Removal		=> thold_CLR_EN_negedge_posedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  TO_X01(( NOT SET_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "LDLBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_SET_EN_posedge,
	 TimingData		=> Tmkr_SET_EN_posedge,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_SET_EN_negedge_posedge,
	 Removal		=> thold_SET_EN_negedge_posedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  TO_X01(( NOT CLR_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "LDLBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_EN,
	 PeriodData		=> PInfo_EN,
	 TestSignal		=> EN_ipd,
	 TestSignalName		=> "EN",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_EN_posedge,
	 PulseWidthHigh         => 0 ns,
	 PulseWidthLow		=> tpw_EN_negedge,
	 CheckEnabled		=>  TO_X01(((NOT CLR_ipd) AND (NOT SET_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "LDLBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData		=> PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_CLR_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> True,
	 HeaderMsg		=> InstancePath & "LDLBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_SET,
	 PeriodData		=> PInfo_SET,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_SET_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=>  TO_X01( NOT CLR_ipd) /='0',
	 HeaderMsg		=> InstancePath & "LDLBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_EN_posedge or Tviol_SET_EN_posedge or Pviol_SET or 
		       Pviol_CLR or Pviol_EN;

	VitalStateTable(
	 Result => QBAR_temp,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		 (NOT CLR_ipd),EN_ipd,D_ipd,SET_ipd));
	 QBAR_zd := Violation XOR NOT QBAR_temp;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => QBAR,
	 GlitchData => QBAR_GlitchData,
	 OutSignalName => "QBAR",
	 OutTemp => QBAR_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_QBAR, true),
		     1 => (SET_ipd'last_event, tpd_SET_QBAR, true),
		    2 => (CLR_ipd'last_event, tpd_CLR_QBAR, true),
		    3 => (EN_ipd'last_event, tpd_EN_QBAR, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_LDLBI_VITAL of LDLBI is
   for VITAL_ACT
   end for;
end CFG_LDLBI_VITAL;



 ---- CELL LDLC ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity LDLC is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of LDLC :  entity is True;
 end LDLC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of LDLC is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL EN_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	VitalWireDelay (EN_ipd,EN, tipd_EN);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, CLR_ipd,EN_ipd)

	-- timing check results
	VARIABLE Tviol_D_EN_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_EN_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_EN_posedge	: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_EN_posedge         : VitalTimingDataType	:= VitalTimingDataInit;
	VARIABLE Pviol_EN	: STD_ULOGIC := '0';
	VARIABLE PInfo_EN	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS Q_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_EN_posedge,
	 TimingData		=> Tmkr_D_EN_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_EN_posedge_posedge,
	 SetupLow		=> tsetup_D_EN_negedge_posedge,
	 HoldHigh		=> thold_D_EN_posedge_posedge,
	 HoldLow		=> thold_D_EN_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) ) ) /= '1', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/LDLC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_CLR_EN_posedge,
	 TimingData		=> Tmkr_CLR_EN_posedge,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_CLR_EN_negedge_posedge,
	 Removal		=> thold_CLR_EN_negedge_posedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  True,
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "LDLC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_EN,
	 PeriodData		=> PInfo_EN,
	 TestSignal		=> EN_ipd,
	 TestSignalName		=> "EN",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_EN_posedge,
	 PulseWidthHigh         => 0 ns,
	 PulseWidthLow		=> tpw_EN_negedge,
	 CheckEnabled		=>  TO_X01(((NOT CLR_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "LDLC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData		=> PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_CLR_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> True,
	 HeaderMsg		=> InstancePath & "LDLC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_EN_posedge or Pviol_CLR or Pviol_EN;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		 (NOT CLR_ipd),EN_ipd,D_ipd,'0'));
	 Q_zd := Violation XOR Q_zd;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_Q, true),
		    1 => (CLR_ipd'last_event, tpd_CLR_Q, true),
		    2 => (EN_ipd'last_event, tpd_EN_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_LDLC_VITAL of LDLC is
   for VITAL_ACT
   end for;
end CFG_LDLC_VITAL;



 ---- CELL LDLCI ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity LDLCI is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of LDLCI :  entity is True;
 end LDLCI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of LDLCI is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL EN_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	VitalWireDelay (EN_ipd,EN, tipd_EN);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, CLR_ipd,EN_ipd)

	-- timing check results
	VARIABLE Tviol_D_EN_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_EN_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_EN_posedge	: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_EN_posedge         : VitalTimingDataType	:= VitalTimingDataInit;
	VARIABLE Pviol_EN	: STD_ULOGIC := '0';
	VARIABLE PInfo_EN	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE QBAR_temp	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS QBAR_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE QBAR_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_EN_posedge,
	 TimingData		=> Tmkr_D_EN_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_EN_posedge_posedge,
	 SetupLow		=> tsetup_D_EN_negedge_posedge,
	 HoldHigh		=> thold_D_EN_posedge_posedge,
	 HoldLow		=> thold_D_EN_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) ) ) /= '1', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/LDLCI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_CLR_EN_posedge,
	 TimingData		=> Tmkr_CLR_EN_posedge,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_CLR_EN_negedge_posedge,
	 Removal		=> thold_CLR_EN_negedge_posedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  True,
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "LDLCI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_EN,
	 PeriodData		=> PInfo_EN,
	 TestSignal		=> EN_ipd,
	 TestSignalName		=> "EN",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_EN_posedge,
	 PulseWidthHigh         => 0 ns,
	 PulseWidthLow		=> tpw_EN_negedge,
	 CheckEnabled		=>  TO_X01(((NOT CLR_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "LDLCI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData		=> PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_CLR_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> True,
	 HeaderMsg		=> InstancePath & "LDLCI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_EN_posedge or Pviol_CLR or Pviol_EN;

	VitalStateTable(
	 Result => QBAR_temp,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		 (NOT CLR_ipd),EN_ipd,D_ipd,'0'));
	 QBAR_zd := Violation XOR NOT QBAR_temp;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => QBAR,
	 GlitchData => QBAR_GlitchData,
	 OutSignalName => "QBAR",
	 OutTemp => QBAR_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_QBAR, true),
		    1 => (CLR_ipd'last_event, tpd_CLR_QBAR, true),
		    2 => (EN_ipd'last_event, tpd_EN_QBAR, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_LDLCI_VITAL of LDLCI is
   for VITAL_ACT
   end for;
end CFG_LDLCI_VITAL;



 ---- CELL LDLI ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity LDLI is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_EN_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_negedge		:  VitalDelayType := 0.000 ns;
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of LDLI :  entity is True;
 end LDLI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of LDLI is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL EN_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (EN_ipd,EN, tipd_EN);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, EN_ipd)

	-- timing check results
	VARIABLE Tviol_D_EN_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_EN_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_EN	: STD_ULOGIC := '0';
	VARIABLE PInfo_EN	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE QBAR_temp	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS QBAR_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE QBAR_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_EN_posedge,
	 TimingData		=> Tmkr_D_EN_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_EN_posedge_posedge,
	 SetupLow		=> tsetup_D_EN_negedge_posedge,
	 HoldHigh		=> thold_D_EN_posedge_posedge,
	 HoldLow		=> thold_D_EN_negedge_posedge,
	 CheckEnabled		=>  True, 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/LDLI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_EN,
	 PeriodData		=> PInfo_EN,
	 TestSignal		=> EN_ipd,
	 TestSignalName		=> "EN",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_EN_posedge,
	 PulseWidthHigh         => 0 ns,
	 PulseWidthLow		=> tpw_EN_negedge,
	 CheckEnabled		=>  True, 
	 HeaderMsg		=> InstancePath & "LDLI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_EN_posedge or Pviol_EN;

	VitalStateTable(
	 Result => QBAR_temp,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		'1',EN_ipd,D_ipd,'0'));
	 QBAR_zd := Violation XOR NOT QBAR_temp;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => QBAR,
	 GlitchData => QBAR_GlitchData,
	 OutSignalName => "QBAR",
	 OutTemp => QBAR_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_QBAR, true),
		    1 => (EN_ipd'last_event, tpd_EN_QBAR, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_LDLI_VITAL of LDLI is
   for VITAL_ACT
   end for;
end CFG_LDLI_VITAL;



 ---- CELL LDLS ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity LDLS is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_SET_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_posedge		:  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_negedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		SET		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of LDLS :  entity is True;
 end LDLS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of LDLS is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL SET_ipd  : STD_ULOGIC := 'X';
	SIGNAL EN_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (SET_ipd,SET, tipd_SET);
	VitalWireDelay (EN_ipd,EN, tipd_EN);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, SET_ipd,EN_ipd)

	-- timing check results
	VARIABLE Tviol_D_EN_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_EN_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_SET_EN_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_SET_EN_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_EN	: STD_ULOGIC := '0';
	VARIABLE PInfo_EN	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_SET	: STD_ULOGIC := '0';
	VARIABLE PInfo_SET	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS Q_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_EN_posedge,
	 TimingData		=> Tmkr_D_EN_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_EN_posedge_posedge,
	 SetupLow		=> tsetup_D_EN_negedge_posedge,
	 HoldHigh		=> thold_D_EN_posedge_posedge,
	 HoldLow		=> thold_D_EN_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((SET_ipd) ) ) /= '1', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/LDLS",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_SET_EN_posedge,
	 TimingData		=> Tmkr_SET_EN_posedge,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_SET_EN_negedge_posedge,
	 Removal		=> thold_SET_EN_negedge_posedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  True,
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "LDLS",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_EN,
	 PeriodData		=> PInfo_EN,
	 TestSignal		=> EN_ipd,
	 TestSignalName		=> "EN",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_EN_posedge,
	 PulseWidthHigh         => 0 ns,
	 PulseWidthLow		=> tpw_EN_negedge,
	 CheckEnabled		=>  TO_X01(((NOT SET_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "LDLS",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_SET,
	 PeriodData		=> PInfo_SET,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_SET_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> 	True,
	 HeaderMsg		=> InstancePath & "LDLS",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_EN_posedge or Tviol_SET_EN_posedge or Pviol_SET or 
		       Pviol_EN;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		'1',EN_ipd,D_ipd,SET_ipd));
	 Q_zd := Violation XOR Q_zd;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_Q, true),
		     1 => (SET_ipd'last_event, tpd_SET_Q, true),
		    2 => (EN_ipd'last_event, tpd_EN_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_LDLS_VITAL of LDLS is
   for VITAL_ACT
   end for;
end CFG_LDLS_VITAL;



 ---- CELL LDLSI ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity LDLSI is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_SET_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_EN_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_posedge		:  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_negedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		SET		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of LDLSI :  entity is True;
 end LDLSI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of LDLSI is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL SET_ipd  : STD_ULOGIC := 'X';
	SIGNAL EN_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (SET_ipd,SET, tipd_SET);
	VitalWireDelay (EN_ipd,EN, tipd_EN);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, SET_ipd,EN_ipd)

	-- timing check results
	VARIABLE Tviol_D_EN_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_EN_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_SET_EN_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_SET_EN_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_EN	: STD_ULOGIC := '0';
	VARIABLE PInfo_EN	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_SET	: STD_ULOGIC := '0';
	VARIABLE PInfo_SET	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE QBAR_temp	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS QBAR_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE QBAR_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_EN_posedge,
	 TimingData		=> Tmkr_D_EN_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_EN_posedge_posedge,
	 SetupLow		=> tsetup_D_EN_negedge_posedge,
	 HoldHigh		=> thold_D_EN_posedge_posedge,
	 HoldLow		=> thold_D_EN_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((SET_ipd) ) ) /= '1', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/LDLSI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_SET_EN_posedge,
	 TimingData		=> Tmkr_SET_EN_posedge,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_SET_EN_negedge_posedge,
	 Removal		=> thold_SET_EN_negedge_posedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  True,
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "LDLSI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_EN,
	 PeriodData		=> PInfo_EN,
	 TestSignal		=> EN_ipd,
	 TestSignalName		=> "EN",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_EN_posedge,
	 PulseWidthHigh         => 0 ns,
	 PulseWidthLow		=> tpw_EN_negedge,
	 CheckEnabled		=>  TO_X01(((NOT SET_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "LDLSI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_SET,
	 PeriodData		=> PInfo_SET,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_SET_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> 	True,
	 HeaderMsg		=> InstancePath & "LDLSI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_EN_posedge or Tviol_SET_EN_posedge or Pviol_SET or 
		       Pviol_EN;

	VitalStateTable(
	 Result => QBAR_temp,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		'1',EN_ipd,D_ipd,SET_ipd));
	 QBAR_zd := Violation XOR NOT QBAR_temp;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => QBAR,
	 GlitchData => QBAR_GlitchData,
	 OutSignalName => "QBAR",
	 OutTemp => QBAR_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_QBAR, true),
		     1 => (SET_ipd'last_event, tpd_SET_QBAR, true),
		    2 => (EN_ipd'last_event, tpd_EN_QBAR, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_LDLSI_VITAL of LDLSI is
   for VITAL_ACT
   end for;
end CFG_LDLSI_VITAL;



 ---- CELL LDS ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity LDS is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_SET_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_negedge		:VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		SET		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of LDS :  entity is True;
 end LDS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of LDS is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL SET_ipd  : STD_ULOGIC := 'X';
	SIGNAL EN_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (SET_ipd,SET, tipd_SET);
	VitalWireDelay (EN_ipd,EN, tipd_EN);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, SET_ipd,EN_ipd)

	-- timing check results
	VARIABLE Tviol_D_EN_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_EN_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_SET_EN_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_SET_EN_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_EN	: STD_ULOGIC := '0';
	VARIABLE PInfo_EN	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_SET	: STD_ULOGIC := '0';
	VARIABLE PInfo_SET	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS Q_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_EN_negedge,
	 TimingData		=> Tmkr_D_EN_negedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_EN_posedge_negedge,
	 SetupLow		=> tsetup_D_EN_negedge_negedge,
	 HoldHigh		=> thold_D_EN_posedge_negedge,
	 HoldLow		=> thold_D_EN_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((SET_ipd) ) ) /= '1', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/LDS",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_SET_EN_negedge,
	 TimingData		=> Tmkr_SET_EN_negedge,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_SET_EN_negedge_negedge,
	 Removal		=> thold_SET_EN_negedge_negedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  True,
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "LDS",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_EN,
	 PeriodData		=> PInfo_EN,
	 TestSignal		=> EN_ipd,
	 TestSignalName		=> "EN",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_EN_negedge,
	 PulseWidthHigh		=> tpw_EN_posedge,
	 PulseWidthLow          => 0 ns,
	 CheckEnabled		=>  TO_X01(((NOT SET_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "LDS",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_SET,
	 PeriodData		=> PInfo_SET,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_SET_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> 	True,
	 HeaderMsg		=> InstancePath & "LDS",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_EN_negedge or Tviol_SET_EN_negedge or Pviol_SET or 
		       Pviol_EN;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		'1',(NOT EN_ipd),D_ipd,SET_ipd));
	 Q_zd := Violation XOR Q_zd;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_Q, true),
		     1 => (SET_ipd'last_event, tpd_SET_Q, true),
		    2 => (EN_ipd'last_event, tpd_EN_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_LDS_VITAL of LDS is
   for VITAL_ACT
   end for;
end CFG_LDS_VITAL;



 ---- CELL LDSI ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity LDSI is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_SET_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_EN_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_EN_negedge		:VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_EN_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		SET		:  in    STD_ULOGIC;
		EN		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of LDSI :  entity is True;
 end LDSI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of LDSI is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL SET_ipd  : STD_ULOGIC := 'X';
	SIGNAL EN_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (SET_ipd,SET, tipd_SET);
	VitalWireDelay (EN_ipd,EN, tipd_EN);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, SET_ipd,EN_ipd)

	-- timing check results
	VARIABLE Tviol_D_EN_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_EN_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_SET_EN_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_SET_EN_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_EN	: STD_ULOGIC := '0';
	VARIABLE PInfo_EN	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_SET	: STD_ULOGIC := '0';
	VARIABLE PInfo_SET	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE QBAR_temp	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS QBAR_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE QBAR_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_EN_negedge,
	 TimingData		=> Tmkr_D_EN_negedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_EN_posedge_negedge,
	 SetupLow		=> tsetup_D_EN_negedge_negedge,
	 HoldHigh		=> thold_D_EN_posedge_negedge,
	 HoldLow		=> thold_D_EN_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((SET_ipd) ) ) /= '1', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/LDSI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_SET_EN_negedge,
	 TimingData		=> Tmkr_SET_EN_negedge,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 RefSignal		=> EN_ipd,
	 RefSignalName		=> "EN",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_SET_EN_negedge_negedge,
	 Removal		=> thold_SET_EN_negedge_negedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  True,
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "LDSI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_EN,
	 PeriodData		=> PInfo_EN,
	 TestSignal		=> EN_ipd,
	 TestSignalName		=> "EN",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_EN_negedge,
	 PulseWidthHigh		=> tpw_EN_posedge,
	 PulseWidthLow          => 0 ns,
	 CheckEnabled		=>  TO_X01(((NOT SET_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "LDSI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_SET,
	 PeriodData		=> PInfo_SET,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_SET_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> 	True,
	 HeaderMsg		=> InstancePath & "LDSI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_EN_negedge or Tviol_SET_EN_negedge or Pviol_SET or 
		       Pviol_EN;

	VitalStateTable(
	 Result => QBAR_temp,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		'1',(NOT EN_ipd),D_ipd,SET_ipd));
	 QBAR_zd := Violation XOR NOT QBAR_temp;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => QBAR,
	 GlitchData => QBAR_GlitchData,
	 OutSignalName => "QBAR",
	 OutTemp => QBAR_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_QBAR, true),
		     1 => (SET_ipd'last_event, tpd_SET_QBAR, true),
		    2 => (EN_ipd'last_event, tpd_EN_QBAR, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_LDSI_VITAL of LDSI is
   for VITAL_ACT
   end for;
end CFG_LDSI_VITAL;



 ---- CELL MUX2H ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity MUX2H is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of MUX2H :  entity is True;
 end MUX2H;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of MUX2H is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL S_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (S_ipd, S, tipd_S);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, S_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( A_ipd , B_ipd , (NOT S_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (S_ipd'last_event,tpd_S_Y, true),
	             2 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_MUX2H_VITAL of MUX2H is 
    for VITAL_ACT
    end for;
 end CFG_MUX2H_VITAL;



 ---- CELL MUX2L ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity MUX2L is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of MUX2L :  entity is True;
 end MUX2L;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of MUX2L is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL S_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (S_ipd, S, tipd_S);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, S_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( A_ipd , B_ipd , S_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (S_ipd'last_event,tpd_S_Y, true),
	             2 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_MUX2L_VITAL of MUX2L is 
    for VITAL_ACT
    end for;
 end CFG_MUX2L_VITAL;



 ---- CELL NAND2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NAND2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NAND2 :  entity is True;
 end NAND2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of NAND2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( (NOT A_ipd)  OR  (NOT B_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NAND2_VITAL of NAND2 is 
    for VITAL_ACT
    end for;
 end CFG_NAND2_VITAL;



 ---- CELL NAND2FT ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NAND2FT is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NAND2FT :  entity is True;
 end NAND2FT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of NAND2FT is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( A_ipd  OR  (NOT B_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NAND2FT_VITAL of NAND2FT is 
    for VITAL_ACT
    end for;
 end CFG_NAND2FT_VITAL;



 ---- CELL NAND3 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NAND3 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NAND3 :  entity is True;
 end NAND3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of NAND3 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  OR  (NOT B_ipd) ) OR  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NAND3_VITAL of NAND3 is 
    for VITAL_ACT
    end for;
 end CFG_NAND3_VITAL;



 ---- CELL NAND3FFT ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NAND3FFT is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NAND3FFT :  entity is True;
 end NAND3FFT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of NAND3FFT is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  OR  B_ipd ) OR  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NAND3FFT_VITAL of NAND3FFT is 
    for VITAL_ACT
    end for;
 end CFG_NAND3FFT_VITAL;



 ---- CELL NAND3FTT ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NAND3FTT is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NAND3FTT :  entity is True;
 end NAND3FTT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of NAND3FTT is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  OR  (NOT B_ipd) ) OR  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NAND3FTT_VITAL of NAND3FTT is 
    for VITAL_ACT
    end for;
 end CFG_NAND3FTT_VITAL;



 ---- CELL NOR2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NOR2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NOR2 :  entity is True;
 end NOR2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of NOR2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( (NOT A_ipd)  AND  (NOT B_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NOR2_VITAL of NOR2 is 
    for VITAL_ACT
    end for;
 end CFG_NOR2_VITAL;



 ---- CELL NOR2FT ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NOR2FT is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NOR2FT :  entity is True;
 end NOR2FT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of NOR2FT is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( A_ipd  AND  (NOT B_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NOR2FT_VITAL of NOR2FT is 
    for VITAL_ACT
    end for;
 end CFG_NOR2FT_VITAL;



 ---- CELL NOR3 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NOR3 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NOR3 :  entity is True;
 end NOR3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of NOR3 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NOR3_VITAL of NOR3 is 
    for VITAL_ACT
    end for;
 end CFG_NOR3_VITAL;



 ---- CELL NOR3FFT ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NOR3FFT is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NOR3FFT :  entity is True;
 end NOR3FFT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of NOR3FFT is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  B_ipd ) AND  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NOR3FFT_VITAL of NOR3FFT is 
    for VITAL_ACT
    end for;
 end CFG_NOR3FFT_VITAL;



 ---- CELL NOR3FTT ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NOR3FTT is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NOR3FTT :  entity is True;
 end NOR3FTT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of NOR3FTT is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  (NOT B_ipd) ) AND  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NOR3FTT_VITAL of NOR3FTT is 
    for VITAL_ACT
    end for;
 end CFG_NOR3FTT_VITAL;



 ---- CELL NUBBLE ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NUBBLE is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NUBBLE :  entity is True;
 end NUBBLE;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of NUBBLE is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NUBBLE_VITAL of NUBBLE is 
    for VITAL_ACT
    end for;
 end CFG_NUBBLE_VITAL;



 ---- CELL OA21 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OA21 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OA21 :  entity is True;
 end OA21;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OA21 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, C_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  C_ipd ) OR ( B_ipd  AND  C_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (C_ipd'last_event,tpd_C_Y, true),
	             2 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OA21_VITAL of OA21 is 
    for VITAL_ACT
    end for;
 end CFG_OA21_VITAL;



 ---- CELL OA21FTF ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OA21FTF is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OA21FTF :  entity is True;
 end OA21FTF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OA21FTF is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, C_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  (NOT C_ipd) ) OR ( B_ipd  AND  (NOT C_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (C_ipd'last_event,tpd_C_Y, true),
	             2 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OA21FTF_VITAL of OA21FTF is 
    for VITAL_ACT
    end for;
 end CFG_OA21FTF_VITAL;



 ---- CELL OA21FTT ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OA21FTT is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OA21FTT :  entity is True;
 end OA21FTT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OA21FTT is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, C_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  C_ipd ) OR ( B_ipd  AND  C_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (C_ipd'last_event,tpd_C_Y, true),
	             2 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OA21FTT_VITAL of OA21FTT is 
    for VITAL_ACT
    end for;
 end CFG_OA21FTT_VITAL;



 ---- CELL OA21TTF ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OA21TTF is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OA21TTF :  entity is True;
 end OA21TTF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OA21TTF is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, C_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  (NOT C_ipd) ) OR ( B_ipd  AND  (NOT C_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (C_ipd'last_event,tpd_C_Y, true),
	             2 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OA21TTF_VITAL of OA21TTF is 
    for VITAL_ACT
    end for;
 end CFG_OA21TTF_VITAL;



 ---- CELL OAI21 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OAI21 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OAI21 :  entity is True;
 end OAI21;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OAI21 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  (NOT B_ipd) ) OR  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OAI21_VITAL of OAI21 is 
    for VITAL_ACT
    end for;
 end CFG_OAI21_VITAL;



 ---- CELL OAI21FTF ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OAI21FTF is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OAI21FTF :  entity is True;
 end OAI21FTF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OAI21FTF is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  (NOT B_ipd) ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OAI21FTF_VITAL of OAI21FTF is 
    for VITAL_ACT
    end for;
 end CFG_OAI21FTF_VITAL;



 ---- CELL OAI21FTT ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OAI21FTT is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OAI21FTT :  entity is True;
 end OAI21FTT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OAI21FTT is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  (NOT B_ipd) ) OR  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OAI21FTT_VITAL of OAI21FTT is 
    for VITAL_ACT
    end for;
 end CFG_OAI21FTT_VITAL;



 ---- CELL OAI21TTF ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OAI21TTF is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		C		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OAI21TTF :  entity is True;
 end OAI21TTF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OAI21TTF is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (C_ipd, A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( C_ipd  OR ( (NOT A_ipd)  AND  (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (C_ipd'last_event,tpd_C_Y, true),
	             1 => (A_ipd'last_event,tpd_A_Y, true),
	             2 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OAI21TTF_VITAL of OAI21TTF is 
    for VITAL_ACT
    end for;
 end CFG_OAI21TTF_VITAL;



 ---- CELL OB25HH ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OB25HH is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OB25HH :  entity is True;
 end OB25HH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OB25HH is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OB25HH_VITAL of OB25HH is 
    for VITAL_ACT
    end for;
 end CFG_OB25HH_VITAL;



 ---- CELL OB25HL ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OB25HL is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OB25HL :  entity is True;
 end OB25HL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OB25HL is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OB25HL_VITAL of OB25HL is 
    for VITAL_ACT
    end for;
 end CFG_OB25HL_VITAL;



 ---- CELL OB25HN ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OB25HN is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OB25HN :  entity is True;
 end OB25HN;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OB25HN is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OB25HN_VITAL of OB25HN is 
    for VITAL_ACT
    end for;
 end CFG_OB25HN_VITAL;



 ---- CELL OB25LH ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OB25LH is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OB25LH :  entity is True;
 end OB25LH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OB25LH is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OB25LH_VITAL of OB25LH is 
    for VITAL_ACT
    end for;
 end CFG_OB25LH_VITAL;



 ---- CELL OB25LL ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OB25LL is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OB25LL :  entity is True;
 end OB25LL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OB25LL is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OB25LL_VITAL of OB25LL is 
    for VITAL_ACT
    end for;
 end CFG_OB25LL_VITAL;



 ---- CELL OB25LN ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OB25LN is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OB25LN :  entity is True;
 end OB25LN;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OB25LN is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OB25LN_VITAL of OB25LN is 
    for VITAL_ACT
    end for;
 end CFG_OB25LN_VITAL;



 ---- CELL OB25LPHH ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OB25LPHH is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OB25LPHH :  entity is True;
 end OB25LPHH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OB25LPHH is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OB25LPHH_VITAL of OB25LPHH is 
    for VITAL_ACT
    end for;
 end CFG_OB25LPHH_VITAL;



 ---- CELL OB25LPHL ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OB25LPHL is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OB25LPHL :  entity is True;
 end OB25LPHL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OB25LPHL is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OB25LPHL_VITAL of OB25LPHL is 
    for VITAL_ACT
    end for;
 end CFG_OB25LPHL_VITAL;



 ---- CELL OB25LPHN ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OB25LPHN is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OB25LPHN :  entity is True;
 end OB25LPHN;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OB25LPHN is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OB25LPHN_VITAL of OB25LPHN is 
    for VITAL_ACT
    end for;
 end CFG_OB25LPHN_VITAL;



 ---- CELL OB25LPLH ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OB25LPLH is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OB25LPLH :  entity is True;
 end OB25LPLH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OB25LPLH is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OB25LPLH_VITAL of OB25LPLH is 
    for VITAL_ACT
    end for;
 end CFG_OB25LPLH_VITAL;



 ---- CELL OB25LPLL ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OB25LPLL is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OB25LPLL :  entity is True;
 end OB25LPLL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OB25LPLL is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OB25LPLL_VITAL of OB25LPLL is 
    for VITAL_ACT
    end for;
 end CFG_OB25LPLL_VITAL;



 ---- CELL OB25LPLN ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OB25LPLN is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OB25LPLN :  entity is True;
 end OB25LPLN;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OB25LPLN is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OB25LPLN_VITAL of OB25LPLN is 
    for VITAL_ACT
    end for;
 end CFG_OB25LPLN_VITAL;



 ---- CELL OB33LH ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OB33LH is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OB33LH :  entity is True;
 end OB33LH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OB33LH is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OB33LH_VITAL of OB33LH is 
    for VITAL_ACT
    end for;
 end CFG_OB33LH_VITAL;



 ---- CELL OB33LL ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OB33LL is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OB33LL :  entity is True;
 end OB33LL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OB33LL is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OB33LL_VITAL of OB33LL is 
    for VITAL_ACT
    end for;
 end CFG_OB33LL_VITAL;



 ---- CELL OB33LN ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OB33LN is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OB33LN :  entity is True;
 end OB33LN;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OB33LN is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OB33LN_VITAL of OB33LN is 
    for VITAL_ACT
    end for;
 end CFG_OB33LN_VITAL;



 ---- CELL OB33PH ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OB33PH is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OB33PH :  entity is True;
 end OB33PH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OB33PH is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OB33PH_VITAL of OB33PH is 
    for VITAL_ACT
    end for;
 end CFG_OB33PH_VITAL;



 ---- CELL OB33PL ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OB33PL is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OB33PL :  entity is True;
 end OB33PL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OB33PL is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OB33PL_VITAL of OB33PL is 
    for VITAL_ACT
    end for;
 end CFG_OB33PL_VITAL;



 ---- CELL OB33PN ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OB33PN is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OB33PN :  entity is True;
 end OB33PN;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OB33PN is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OB33PN_VITAL of OB33PN is 
    for VITAL_ACT
    end for;
 end CFG_OB33PN_VITAL;



 ---- CELL OR2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OR2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OR2 :  entity is True;
 end OR2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OR2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( A_ipd  OR  B_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OR2_VITAL of OR2 is 
    for VITAL_ACT
    end for;
 end CFG_OR2_VITAL;



 ---- CELL OR2FT ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OR2FT is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OR2FT :  entity is True;
 end OR2FT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OR2FT is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( (NOT A_ipd)  OR  B_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OR2FT_VITAL of OR2FT is 
    for VITAL_ACT
    end for;
 end CFG_OR2FT_VITAL;



 ---- CELL OR3 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OR3 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OR3 :  entity is True;
 end OR3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OR3 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  OR  B_ipd ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OR3_VITAL of OR3 is 
    for VITAL_ACT
    end for;
 end CFG_OR3_VITAL;



 ---- CELL OR3FFT ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OR3FFT is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OR3FFT :  entity is True;
 end OR3FFT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OR3FFT is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  OR  (NOT B_ipd) ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OR3FFT_VITAL of OR3FFT is 
    for VITAL_ACT
    end for;
 end CFG_OR3FFT_VITAL;



 ---- CELL OR3FTT ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OR3FTT is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OR3FTT :  entity is True;
 end OR3FTT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of OR3FTT is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  OR  B_ipd ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OR3FTT_VITAL of OR3FTT is 
    for VITAL_ACT
    end for;
 end CFG_OR3FTT_VITAL;



 ---- CELL PWR ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity PWR is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True		);
    port(
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of PWR :  entity is True;
 end PWR;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of PWR is
	attribute VITAL_LEVEL0 of VITAL_ACT : architecture is True;


begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	--- Empty
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
        Y<= '1';


end VITAL_ACT;

 configuration CFG_PWR_VITAL of PWR is 
    for VITAL_ACT
    end for;
 end CFG_PWR_VITAL;



 ---- CELL XNOR2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity XNOR2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of XNOR2 :  entity is True;
 end XNOR2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of XNOR2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT VitalMUX2( B_ipd , (NOT B_ipd) , (NOT A_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_XNOR2_VITAL of XNOR2 is 
    for VITAL_ACT
    end for;
 end CFG_XNOR2_VITAL;



 ---- CELL XNOR2FT ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity XNOR2FT is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of XNOR2FT :  entity is True;
 end XNOR2FT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of XNOR2FT is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT VitalMUX2( B_ipd , (NOT B_ipd) , A_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_XNOR2FT_VITAL of XNOR2FT is 
    for VITAL_ACT
    end for;
 end CFG_XNOR2FT_VITAL;



 ---- CELL XOR2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity XOR2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of XOR2 :  entity is True;
 end XOR2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of XOR2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( B_ipd , (NOT B_ipd) , (NOT A_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_XOR2_VITAL of XOR2 is 
    for VITAL_ACT
    end for;
 end CFG_XOR2_VITAL;



 ---- CELL XOR2FT ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity XOR2FT is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of XOR2FT :  entity is True;
 end XOR2FT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of XOR2FT is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( B_ipd , (NOT B_ipd) , A_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_XOR2FT_VITAL of XOR2FT is 
    for VITAL_ACT
    end for;
 end CFG_XOR2FT_VITAL;



 ---- CELL DFF ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFF is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFF :  entity is True;
 end DFF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of DFF is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_posedge,
	 TimingData		=> Tmkr_D_CLK_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_posedge,
	 SetupLow		=> tsetup_D_CLK_negedge_posedge,
	 HoldHigh		=> thold_D_CLK_posedge_posedge,
	 HoldLow		=> thold_D_CLK_negedge_posedge,
	 CheckEnabled		=>  True, 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DFF",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_posedge,
	 CheckEnabled		=>True,
	 HeaderMsg		=> InstancePath & "DFF",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_posedge or 
	 Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             '1', CLK_delayed, Q_zd, D_delayed, '0', '1', CLK_ipd));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFF_VITAL of DFF is
   for VITAL_ACT
   end for;
end CFG_DFF_VITAL;



 ---- CELL DFFB ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFFB is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_SET_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		SET		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFFB :  entity is True;
 end DFFB;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of DFFB is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL SET_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (SET_ipd,SET, tipd_SET);
	  VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, SET_ipd,CLR_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_SET_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_SET_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_SET	: STD_ULOGIC := '0';
	VARIABLE PInfo_SET	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_posedge,
	 TimingData		=> Tmkr_D_CLK_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_posedge,
	 SetupLow		=> tsetup_D_CLK_negedge_posedge,
	 HoldHigh		=> thold_D_CLK_posedge_posedge,
	 HoldLow		=> thold_D_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((NOT CLR_ipd) AND (NOT SET_ipd) ) ) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DFFB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_SET_CLK_posedge,
	 TimingData		=> Tmkr_SET_CLK_posedge,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_SET_CLK_negedge_posedge,
	 Removal		=> thold_SET_CLK_negedge_posedge,
	 ActiveLow		 => FALSE,
	 CheckEnabled           =>  TO_X01(( NOT CLR_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFFB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation              => Tviol_CLR_CLK_posedge,
	 TimingData             => Tmkr_CLR_CLK_posedge,
	 TestSignal             => CLR_ipd,
	 TestSignalName         => "CLR",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 Recovery              => trecovery_CLR_CLK_negedge_posedge,
	 Removal               => thold_CLR_CLK_negedge_posedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled           =>      TO_X01(( NOT SET_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFFB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_posedge,
	 CheckEnabled		=>		TO_X01(((NOT SET_ipd) AND ( NOT CLR_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFFB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData             => PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period			=> 0 ns,
	 PulseWidthHigh		=> tpw_CLR_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled           => True,
	 HeaderMsg              => InstancePath & "DFFB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_SET,
	 PeriodData		=> PInfo_SET,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthHigh		=> tpw_SET_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> 		TO_X01( NOT CLR_ipd) /='0',
	 HeaderMsg		=> InstancePath & "DFFB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_posedge or 
	 Tviol_SET_CLK_posedge or 
	 Tviol_SET_CLK_posedge or Pviol_SET or Pviol_CLR or Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             (NOT CLR_ipd), CLK_delayed, Q_zd, D_delayed, '0', (NOT SET_ipd), CLK_ipd));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1=> (SET_ipd'last_event, tpd_SET_Q, true),
	            2=> (CLR_ipd'last_event, tpd_CLR_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFFB_VITAL of DFFB is
   for VITAL_ACT
   end for;
end CFG_DFFB_VITAL;



 ---- CELL DFFBI ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFFBI is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_SET_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		SET		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFFBI :  entity is True;
 end DFFBI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of DFFBI is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL SET_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (SET_ipd,SET, tipd_SET);
	  VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, SET_ipd,CLR_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_SET_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_SET_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_SET	: STD_ULOGIC := '0';
	VARIABLE PInfo_SET	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE QBAR_temp	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS QBAR_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE QBAR_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_posedge,
	 TimingData		=> Tmkr_D_CLK_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_posedge,
	 SetupLow		=> tsetup_D_CLK_negedge_posedge,
	 HoldHigh		=> thold_D_CLK_posedge_posedge,
	 HoldLow		=> thold_D_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((NOT CLR_ipd) AND (NOT SET_ipd) ) ) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DFFBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_SET_CLK_posedge,
	 TimingData		=> Tmkr_SET_CLK_posedge,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_SET_CLK_negedge_posedge,
	 Removal		=> thold_SET_CLK_negedge_posedge,
	 ActiveLow		 => FALSE,
	 CheckEnabled           =>  TO_X01(( NOT CLR_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFFBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation              => Tviol_CLR_CLK_posedge,
	 TimingData             => Tmkr_CLR_CLK_posedge,
	 TestSignal             => CLR_ipd,
	 TestSignalName         => "CLR",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 Recovery              => trecovery_CLR_CLK_negedge_posedge,
	 Removal               => thold_CLR_CLK_negedge_posedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled           =>      TO_X01(( NOT SET_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFFBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_posedge,
	 CheckEnabled		=>		TO_X01(((NOT SET_ipd) AND ( NOT CLR_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFFBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData             => PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period			=> 0 ns,
	 PulseWidthHigh		=> tpw_CLR_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled           => True,
	 HeaderMsg              => InstancePath & "DFFBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_SET,
	 PeriodData		=> PInfo_SET,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthHigh		=> tpw_SET_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> 		TO_X01( NOT CLR_ipd) /='0',
	 HeaderMsg		=> InstancePath & "DFFBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_posedge or 
	 Tviol_SET_CLK_posedge or 
	 Tviol_SET_CLK_posedge or Pviol_SET or Pviol_CLR or Pviol_CLK;

  VitalStateTable(
   Result => QBAR_temp,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             (NOT CLR_ipd), CLK_delayed, QBAR_temp, D_delayed, '0', (NOT SET_ipd), CLK_ipd));
   QBAR_zd := Violation XOR  (NOT QBAR_temp);
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => QBAR,
	 GlitchData => QBAR_GlitchData,
	 OutSignalName => "QBAR",
	 OutTemp => QBAR_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_QBAR, true),
	             1=> (SET_ipd'last_event, tpd_SET_QBAR, true),
	            2=> (CLR_ipd'last_event, tpd_CLR_QBAR, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFFBI_VITAL of DFFBI is
   for VITAL_ACT
   end for;
end CFG_DFFBI_VITAL;



 ---- CELL DFFC ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFFC is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFFC :  entity is True;
 end DFFC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of DFFC is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLR_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_posedge,
	 TimingData		=> Tmkr_D_CLK_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_posedge,
	 SetupLow		=> tsetup_D_CLK_negedge_posedge,
	 HoldHigh		=> thold_D_CLK_posedge_posedge,
	 HoldLow		=> thold_D_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((NOT CLR_ipd) ) ) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DFFC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalRecoveryRemovalCheck (
	 Violation              => Tviol_CLR_CLK_posedge,
	 TimingData             => Tmkr_CLR_CLK_posedge,
	 TestSignal             => CLR_ipd,
	 TestSignalName         => "CLR",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 Recovery              => trecovery_CLR_CLK_negedge_posedge,
	 Removal               => thold_CLR_CLK_negedge_posedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled           =>    True,
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFFC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_posedge,
	 CheckEnabled		=>		TO_X01((( NOT CLR_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFFC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData             => PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period			=> 0 ns,
	 PulseWidthHigh		=> tpw_CLR_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled           => True,
	 HeaderMsg              => InstancePath & "DFFC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_posedge or 
	 Pviol_CLR or 
	 Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             (NOT CLR_ipd), CLK_delayed, Q_zd, D_delayed, '0', '1', CLK_ipd));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	            1=> (CLR_ipd'last_event, tpd_CLR_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFFC_VITAL of DFFC is
   for VITAL_ACT
   end for;
end CFG_DFFC_VITAL;



 ---- CELL DFFCI ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFFCI is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFFCI :  entity is True;
 end DFFCI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of DFFCI is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLR_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE QBAR_temp	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS QBAR_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE QBAR_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_posedge,
	 TimingData		=> Tmkr_D_CLK_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_posedge,
	 SetupLow		=> tsetup_D_CLK_negedge_posedge,
	 HoldHigh		=> thold_D_CLK_posedge_posedge,
	 HoldLow		=> thold_D_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((NOT CLR_ipd) ) ) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DFFCI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalRecoveryRemovalCheck (
	 Violation              => Tviol_CLR_CLK_posedge,
	 TimingData             => Tmkr_CLR_CLK_posedge,
	 TestSignal             => CLR_ipd,
	 TestSignalName         => "CLR",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 Recovery              => trecovery_CLR_CLK_negedge_posedge,
	 Removal               => thold_CLR_CLK_negedge_posedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled           =>    True,
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFFCI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_posedge,
	 CheckEnabled		=>		TO_X01((( NOT CLR_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFFCI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData             => PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period			=> 0 ns,
	 PulseWidthHigh		=> tpw_CLR_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled           => True,
	 HeaderMsg              => InstancePath & "DFFCI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_posedge or 
	 Pviol_CLR or 
	 Pviol_CLK;

  VitalStateTable(
   Result => QBAR_temp,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             (NOT CLR_ipd), CLK_delayed, QBAR_temp, D_delayed, '0', '1', CLK_ipd));
   QBAR_zd := Violation XOR  (NOT QBAR_temp);
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => QBAR,
	 GlitchData => QBAR_GlitchData,
	 OutSignalName => "QBAR",
	 OutTemp => QBAR_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_QBAR, true),
	            1=> (CLR_ipd'last_event, tpd_CLR_QBAR, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFFCI_VITAL of DFFCI is
   for VITAL_ACT
   end for;
end CFG_DFFCI_VITAL;



 ---- CELL DFFI ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFFI is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFFI :  entity is True;
 end DFFI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of DFFI is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE QBAR_temp	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS QBAR_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE QBAR_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_posedge,
	 TimingData		=> Tmkr_D_CLK_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_posedge,
	 SetupLow		=> tsetup_D_CLK_negedge_posedge,
	 HoldHigh		=> thold_D_CLK_posedge_posedge,
	 HoldLow		=> thold_D_CLK_negedge_posedge,
	 CheckEnabled		=>  True, 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DFFI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_posedge,
	 CheckEnabled		=>True,
	 HeaderMsg		=> InstancePath & "DFFI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_posedge or 
	 Pviol_CLK;

  VitalStateTable(
   Result => QBAR_temp,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             '1', CLK_delayed, QBAR_temp, D_delayed, '0', '1', CLK_ipd));
   QBAR_zd := Violation XOR  (NOT QBAR_temp);
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => QBAR,
	 GlitchData => QBAR_GlitchData,
	 OutSignalName => "QBAR",
	 OutTemp => QBAR_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_QBAR, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFFI_VITAL of DFFI is
   for VITAL_ACT
   end for;
end CFG_DFFI_VITAL;



 ---- CELL DFFL ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFFL is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFFL :  entity is True;
 end DFFL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of DFFL is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_negedge, 
	 TimingData		=> Tmkr_D_CLK_negedge, 
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_negedge,
	 SetupLow		=> tsetup_D_CLK_negedge_negedge,
	 HoldHigh		=> thold_D_CLK_posedge_negedge,
	 HoldLow		=> thold_D_CLK_negedge_negedge,
	 CheckEnabled		=>  True, 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/DFFL",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_negedge,
	 CheckEnabled		=>True,
	 HeaderMsg		=> InstancePath & "DFFL",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_negedge or 
	 Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             '1', CLK_ipd, Q_zd, D_delayed, '0', '1', CLK_delayed));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFFL_VITAL of DFFL is
   for VITAL_ACT
   end for;
end CFG_DFFL_VITAL;



 ---- CELL DFFLB ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFFLB is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_SET_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		SET		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFFLB :  entity is True;
 end DFFLB;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of DFFLB is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL SET_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (SET_ipd,SET, tipd_SET);
	  VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, SET_ipd,CLR_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_SET_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_SET_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_SET	: STD_ULOGIC := '0';
	VARIABLE PInfo_SET	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_negedge, 
	 TimingData		=> Tmkr_D_CLK_negedge, 
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_negedge,
	 SetupLow		=> tsetup_D_CLK_negedge_negedge,
	 HoldHigh		=> thold_D_CLK_posedge_negedge,
	 HoldLow		=> thold_D_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((NOT CLR_ipd) AND (NOT SET_ipd) ) ) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/DFFLB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_SET_CLK_negedge,
	 TimingData		=> Tmkr_SET_CLK_negedge,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_SET_CLK_negedge_negedge,
	 Removal		=> thold_SET_CLK_negedge_negedge,
	 ActiveLow		 => FALSE,
	 CheckEnabled           =>  TO_X01(( NOT CLR_ipd)) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DFFLB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation              => Tviol_CLR_CLK_negedge,
	 TimingData             => Tmkr_CLR_CLK_negedge,
	 TestSignal             => CLR_ipd,
	 TestSignalName         => "CLR",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 Recovery              => trecovery_CLR_CLK_negedge_negedge,
	 Removal               => thold_CLR_CLK_negedge_negedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled           =>      TO_X01(( NOT SET_ipd)) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DFFLB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_negedge,
	 CheckEnabled		=>		TO_X01(((NOT SET_ipd) AND ( NOT CLR_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFFLB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData             => PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period			=> 0 ns,
	 PulseWidthHigh		=> tpw_CLR_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled           => True,
	 HeaderMsg              => InstancePath & "DFFLB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_SET,
	 PeriodData		=> PInfo_SET,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthHigh		=> tpw_SET_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> 		TO_X01( NOT CLR_ipd) /='0',
	 HeaderMsg		=> InstancePath & "DFFLB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_negedge or 
	 Tviol_SET_CLK_negedge or 
	 Tviol_SET_CLK_negedge or Pviol_SET or Pviol_CLR or Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             (NOT CLR_ipd), CLK_ipd, Q_zd, D_delayed, '0', (NOT SET_ipd), CLK_delayed));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1=> (SET_ipd'last_event, tpd_SET_Q, true),
	            2=> (CLR_ipd'last_event, tpd_CLR_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFFLB_VITAL of DFFLB is
   for VITAL_ACT
   end for;
end CFG_DFFLB_VITAL;



 ---- CELL DFFLBI ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFFLBI is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_SET_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		SET		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFFLBI :  entity is True;
 end DFFLBI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of DFFLBI is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL SET_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (SET_ipd,SET, tipd_SET);
	  VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, SET_ipd,CLR_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_SET_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_SET_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_SET	: STD_ULOGIC := '0';
	VARIABLE PInfo_SET	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE QBAR_temp	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS QBAR_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE QBAR_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_negedge, 
	 TimingData		=> Tmkr_D_CLK_negedge, 
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_negedge,
	 SetupLow		=> tsetup_D_CLK_negedge_negedge,
	 HoldHigh		=> thold_D_CLK_posedge_negedge,
	 HoldLow		=> thold_D_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((NOT CLR_ipd) AND (NOT SET_ipd) ) ) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/DFFLBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_SET_CLK_negedge,
	 TimingData		=> Tmkr_SET_CLK_negedge,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_SET_CLK_negedge_negedge,
	 Removal		=> thold_SET_CLK_negedge_negedge,
	 ActiveLow		 => FALSE,
	 CheckEnabled           =>  TO_X01(( NOT CLR_ipd)) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DFFLBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation              => Tviol_CLR_CLK_negedge,
	 TimingData             => Tmkr_CLR_CLK_negedge,
	 TestSignal             => CLR_ipd,
	 TestSignalName         => "CLR",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 Recovery              => trecovery_CLR_CLK_negedge_negedge,
	 Removal               => thold_CLR_CLK_negedge_negedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled           =>      TO_X01(( NOT SET_ipd)) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DFFLBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_negedge,
	 CheckEnabled		=>		TO_X01(((NOT SET_ipd) AND ( NOT CLR_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFFLBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData             => PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period			=> 0 ns,
	 PulseWidthHigh		=> tpw_CLR_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled           => True,
	 HeaderMsg              => InstancePath & "DFFLBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_SET,
	 PeriodData		=> PInfo_SET,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthHigh		=> tpw_SET_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> 		TO_X01( NOT CLR_ipd) /='0',
	 HeaderMsg		=> InstancePath & "DFFLBI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_negedge or 
	 Tviol_SET_CLK_negedge or 
	 Tviol_SET_CLK_negedge or Pviol_SET or Pviol_CLR or Pviol_CLK;

  VitalStateTable(
   Result => QBAR_temp,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             (NOT CLR_ipd), CLK_ipd, QBAR_temp, D_delayed, '0', (NOT SET_ipd), CLK_delayed));
   QBAR_zd := Violation XOR  (NOT QBAR_temp);
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => QBAR,
	 GlitchData => QBAR_GlitchData,
	 OutSignalName => "QBAR",
	 OutTemp => QBAR_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_QBAR, true),
	             1=> (SET_ipd'last_event, tpd_SET_QBAR, true),
	            2=> (CLR_ipd'last_event, tpd_CLR_QBAR, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFFLBI_VITAL of DFFLBI is
   for VITAL_ACT
   end for;
end CFG_DFFLBI_VITAL;



 ---- CELL DFFLC ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFFLC is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFFLC :  entity is True;
 end DFFLC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of DFFLC is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLR_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_negedge, 
	 TimingData		=> Tmkr_D_CLK_negedge, 
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_negedge,
	 SetupLow		=> tsetup_D_CLK_negedge_negedge,
	 HoldHigh		=> thold_D_CLK_posedge_negedge,
	 HoldLow		=> thold_D_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((NOT CLR_ipd) ) ) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/DFFLC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalRecoveryRemovalCheck (
	 Violation              => Tviol_CLR_CLK_negedge,
	 TimingData             => Tmkr_CLR_CLK_negedge,
	 TestSignal             => CLR_ipd,
	 TestSignalName         => "CLR",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 Recovery              => trecovery_CLR_CLK_negedge_negedge,
	 Removal               => thold_CLR_CLK_negedge_negedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled           =>    True,
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DFFLC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_negedge,
	 CheckEnabled		=>		TO_X01((( NOT CLR_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFFLC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData             => PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period			=> 0 ns,
	 PulseWidthHigh		=> tpw_CLR_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled           => True,
	 HeaderMsg              => InstancePath & "DFFLC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_negedge or 
	 Pviol_CLR or 
	 Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             (NOT CLR_ipd), CLK_ipd, Q_zd, D_delayed, '0', '1', CLK_delayed));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	            1=> (CLR_ipd'last_event, tpd_CLR_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFFLC_VITAL of DFFLC is
   for VITAL_ACT
   end for;
end CFG_DFFLC_VITAL;



 ---- CELL DFFLCI ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFFLCI is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFFLCI :  entity is True;
 end DFFLCI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of DFFLCI is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLR_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE QBAR_temp	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS QBAR_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE QBAR_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_negedge, 
	 TimingData		=> Tmkr_D_CLK_negedge, 
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_negedge,
	 SetupLow		=> tsetup_D_CLK_negedge_negedge,
	 HoldHigh		=> thold_D_CLK_posedge_negedge,
	 HoldLow		=> thold_D_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((NOT CLR_ipd) ) ) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/DFFLCI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalRecoveryRemovalCheck (
	 Violation              => Tviol_CLR_CLK_negedge,
	 TimingData             => Tmkr_CLR_CLK_negedge,
	 TestSignal             => CLR_ipd,
	 TestSignalName         => "CLR",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 Recovery              => trecovery_CLR_CLK_negedge_negedge,
	 Removal               => thold_CLR_CLK_negedge_negedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled           =>    True,
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DFFLCI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_negedge,
	 CheckEnabled		=>		TO_X01((( NOT CLR_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFFLCI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData             => PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period			=> 0 ns,
	 PulseWidthHigh		=> tpw_CLR_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled           => True,
	 HeaderMsg              => InstancePath & "DFFLCI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_negedge or 
	 Pviol_CLR or 
	 Pviol_CLK;

  VitalStateTable(
   Result => QBAR_temp,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             (NOT CLR_ipd), CLK_ipd, QBAR_temp, D_delayed, '0', '1', CLK_delayed));
   QBAR_zd := Violation XOR  (NOT QBAR_temp);
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => QBAR,
	 GlitchData => QBAR_GlitchData,
	 OutSignalName => "QBAR",
	 OutTemp => QBAR_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_QBAR, true),
	            1=> (CLR_ipd'last_event, tpd_CLR_QBAR, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFFLCI_VITAL of DFFLCI is
   for VITAL_ACT
   end for;
end CFG_DFFLCI_VITAL;



 ---- CELL DFFLI ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFFLI is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFFLI :  entity is True;
 end DFFLI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of DFFLI is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE QBAR_temp	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS QBAR_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE QBAR_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_negedge, 
	 TimingData		=> Tmkr_D_CLK_negedge, 
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_negedge,
	 SetupLow		=> tsetup_D_CLK_negedge_negedge,
	 HoldHigh		=> thold_D_CLK_posedge_negedge,
	 HoldLow		=> thold_D_CLK_negedge_negedge,
	 CheckEnabled		=>  True, 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/DFFLI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_negedge,
	 CheckEnabled		=>True,
	 HeaderMsg		=> InstancePath & "DFFLI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_negedge or 
	 Pviol_CLK;

  VitalStateTable(
   Result => QBAR_temp,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             '1', CLK_ipd, QBAR_temp, D_delayed, '0', '1', CLK_delayed));
   QBAR_zd := Violation XOR  (NOT QBAR_temp);
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => QBAR,
	 GlitchData => QBAR_GlitchData,
	 OutSignalName => "QBAR",
	 OutTemp => QBAR_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_QBAR, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFFLI_VITAL of DFFLI is
   for VITAL_ACT
   end for;
end CFG_DFFLI_VITAL;



 ---- CELL DFFLS ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFFLS is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_SET_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		SET		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFFLS :  entity is True;
 end DFFLS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of DFFLS is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL SET_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (SET_ipd,SET, tipd_SET);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, SET_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_SET_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_SET_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_SET	: STD_ULOGIC := '0';
	VARIABLE PInfo_SET	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_negedge, 
	 TimingData		=> Tmkr_D_CLK_negedge, 
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_negedge,
	 SetupLow		=> tsetup_D_CLK_negedge_negedge,
	 HoldHigh		=> thold_D_CLK_posedge_negedge,
	 HoldLow		=> thold_D_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((NOT SET_ipd) ) ) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/DFFLS",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_SET_CLK_negedge,
	 TimingData		=> Tmkr_SET_CLK_negedge,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_SET_CLK_negedge_negedge,
	 Removal		=> thold_SET_CLK_negedge_negedge,
	 ActiveLow		 => FALSE,
	 CheckEnabled           =>  True,
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DFFLS",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_negedge,
	 CheckEnabled		=>		TO_X01(((NOT SET_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFFLS",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_SET,
	 PeriodData		=> PInfo_SET,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthHigh		=> tpw_SET_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> 			         True,
	 HeaderMsg		=> InstancePath & "DFFLS",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_negedge or 
	 Tviol_SET_CLK_negedge or 
	 Tviol_SET_CLK_negedge or Pviol_SET or Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             '1', CLK_ipd, Q_zd, D_delayed, '0', (NOT SET_ipd), CLK_delayed));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1=> (SET_ipd'last_event, tpd_SET_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFFLS_VITAL of DFFLS is
   for VITAL_ACT
   end for;
end CFG_DFFLS_VITAL;



 ---- CELL DFFLSI ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFFLSI is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_SET_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		SET		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFFLSI :  entity is True;
 end DFFLSI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of DFFLSI is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL SET_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (SET_ipd,SET, tipd_SET);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, SET_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_SET_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_SET_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_SET	: STD_ULOGIC := '0';
	VARIABLE PInfo_SET	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE QBAR_temp	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS QBAR_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE QBAR_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_negedge, 
	 TimingData		=> Tmkr_D_CLK_negedge, 
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_negedge,
	 SetupLow		=> tsetup_D_CLK_negedge_negedge,
	 HoldHigh		=> thold_D_CLK_posedge_negedge,
	 HoldLow		=> thold_D_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((NOT SET_ipd) ) ) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/DFFLSI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_SET_CLK_negedge,
	 TimingData		=> Tmkr_SET_CLK_negedge,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_SET_CLK_negedge_negedge,
	 Removal		=> thold_SET_CLK_negedge_negedge,
	 ActiveLow		 => FALSE,
	 CheckEnabled           =>  True,
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DFFLSI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_negedge,
	 CheckEnabled		=>		TO_X01(((NOT SET_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFFLSI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_SET,
	 PeriodData		=> PInfo_SET,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthHigh		=> tpw_SET_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> 			         True,
	 HeaderMsg		=> InstancePath & "DFFLSI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_negedge or 
	 Tviol_SET_CLK_negedge or 
	 Tviol_SET_CLK_negedge or Pviol_SET or Pviol_CLK;

  VitalStateTable(
   Result => QBAR_temp,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             '1', CLK_ipd, QBAR_temp, D_delayed, '0', (NOT SET_ipd), CLK_delayed));
   QBAR_zd := Violation XOR  (NOT QBAR_temp);
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => QBAR,
	 GlitchData => QBAR_GlitchData,
	 OutSignalName => "QBAR",
	 OutTemp => QBAR_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_QBAR, true),
	             1=> (SET_ipd'last_event, tpd_SET_QBAR, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFFLSI_VITAL of DFFLSI is
   for VITAL_ACT
   end for;
end CFG_DFFLSI_VITAL;



 ---- CELL DFFS ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFFS is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_SET_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		SET		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFFS :  entity is True;
 end DFFS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of DFFS is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL SET_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (SET_ipd,SET, tipd_SET);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, SET_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_SET_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_SET_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_SET	: STD_ULOGIC := '0';
	VARIABLE PInfo_SET	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_posedge,
	 TimingData		=> Tmkr_D_CLK_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_posedge,
	 SetupLow		=> tsetup_D_CLK_negedge_posedge,
	 HoldHigh		=> thold_D_CLK_posedge_posedge,
	 HoldLow		=> thold_D_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((NOT SET_ipd) ) ) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DFFS",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_SET_CLK_posedge,
	 TimingData		=> Tmkr_SET_CLK_posedge,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_SET_CLK_negedge_posedge,
	 Removal		=> thold_SET_CLK_negedge_posedge,
	 ActiveLow		 => FALSE,
	 CheckEnabled           =>  True,
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFFS",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_posedge,
	 CheckEnabled		=>		TO_X01(((NOT SET_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFFS",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_SET,
	 PeriodData		=> PInfo_SET,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthHigh		=> tpw_SET_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> 			         True,
	 HeaderMsg		=> InstancePath & "DFFS",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_posedge or 
	 Tviol_SET_CLK_posedge or 
	 Tviol_SET_CLK_posedge or Pviol_SET or Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             '1', CLK_delayed, Q_zd, D_delayed, '0', (NOT SET_ipd), CLK_ipd));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1=> (SET_ipd'last_event, tpd_SET_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFFS_VITAL of DFFS is
   for VITAL_ACT
   end for;
end CFG_DFFS_VITAL;



 ---- CELL DFFSI ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFFSI is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: String := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_SET_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QBAR		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_SET_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_SET_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_SET_posedge		:  VitalDelayType := 0.000 ns;
		tipd_SET		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		SET		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QBAR		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFFSI :  entity is True;
 end DFFSI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of DFFSI is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL SET_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (SET_ipd,SET, tipd_SET);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, SET_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_SET_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_SET_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_SET	: STD_ULOGIC := '0';
	VARIABLE PInfo_SET	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE QBAR_temp	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS QBAR_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE QBAR_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_posedge,
	 TimingData		=> Tmkr_D_CLK_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_posedge,
	 SetupLow		=> tsetup_D_CLK_negedge_posedge,
	 HoldHigh		=> thold_D_CLK_posedge_posedge,
	 HoldLow		=> thold_D_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((NOT SET_ipd) ) ) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DFFSI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_SET_CLK_posedge,
	 TimingData		=> Tmkr_SET_CLK_posedge,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_SET_CLK_negedge_posedge,
	 Removal		=> thold_SET_CLK_negedge_posedge,
	 ActiveLow		 => FALSE,
	 CheckEnabled           =>  True,
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFFSI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_posedge,
	 CheckEnabled		=>		TO_X01(((NOT SET_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFFSI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_SET,
	 PeriodData		=> PInfo_SET,
	 TestSignal		=> SET_ipd,
	 TestSignalName		=> "SET",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthHigh		=> tpw_SET_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> 			         True,
	 HeaderMsg		=> InstancePath & "DFFSI",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_posedge or 
	 Tviol_SET_CLK_posedge or 
	 Tviol_SET_CLK_posedge or Pviol_SET or Pviol_CLK;

  VitalStateTable(
   Result => QBAR_temp,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             '1', CLK_delayed, QBAR_temp, D_delayed, '0', (NOT SET_ipd), CLK_ipd));
   QBAR_zd := Violation XOR  (NOT QBAR_temp);
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => QBAR,
	 GlitchData => QBAR_GlitchData,
	 OutSignalName => "QBAR",
	 OutTemp => QBAR_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_QBAR, true),
	             1=> (SET_ipd'last_event, tpd_SET_QBAR, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFFSI_VITAL of DFFSI is
   for VITAL_ACT
   end for;
end CFG_DFFSI_VITAL;



 ---- CELL GLIB25 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GLIB25 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GLIB25 :  entity is True;
 end GLIB25;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of GLIB25 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';
	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd, A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);
	ALIAS GL_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;
	VARIABLE GL_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);
        GL_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

     VitalPathDelay01 (
	   OutSignal => GL,
	   GlitchData => GL_GlitchData,
	   OutSignalName => "GL",
	   OutTemp => GL_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_GL, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_GLIB25_VITAL of GLIB25 is 
    for VITAL_ACT
    end for;
 end CFG_GLIB25_VITAL;



 ---- CELL GLIB25LP ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GLIB25LP is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GLIB25LP :  entity is True;
 end GLIB25LP;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of GLIB25LP is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';
	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd, A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);
	ALIAS GL_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;
	VARIABLE GL_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);
        GL_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

     VitalPathDelay01 (
	   OutSignal => GL,
	   GlitchData => GL_GlitchData,
	   OutSignalName => "GL",
	   OutTemp => GL_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_GL, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_GLIB25LP_VITAL of GLIB25LP is 
    for VITAL_ACT
    end for;
 end CFG_GLIB25LP_VITAL;



 ---- CELL GLIB25LPU ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GLIB25LPU is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GLIB25LPU :  entity is True;
 end GLIB25LPU;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of GLIB25LPU is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';
	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd, A_ipd)


	-- functionality results
	VARIABLE PAD_ipd2 : STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);
	ALIAS GL_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;
	VARIABLE GL_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_ipd2 := VitalIdent (data => PAD_ipd,
                              ResultMap => ('U','X','0','1','H'));
        Y_zd := TO_X01(PAD_ipd2);
        GL_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

     VitalPathDelay01 (
	   OutSignal => GL,
	   GlitchData => GL_GlitchData,
	   OutSignalName => "GL",
	   OutTemp => GL_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_GL, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_GLIB25LPU_VITAL of GLIB25LPU is 
    for VITAL_ACT
    end for;
 end CFG_GLIB25LPU_VITAL;



 ---- CELL GLIB25U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GLIB25U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GLIB25U :  entity is True;
 end GLIB25U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of GLIB25U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';
	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd, A_ipd)


	-- functionality results
	VARIABLE PAD_ipd2 : STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);
	ALIAS GL_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;
	VARIABLE GL_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_ipd2 := VitalIdent (data => PAD_ipd,
                              ResultMap => ('U','X','0','1','H'));
        Y_zd := TO_X01(PAD_ipd2);
        GL_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

     VitalPathDelay01 (
	   OutSignal => GL,
	   GlitchData => GL_GlitchData,
	   OutSignalName => "GL",
	   OutTemp => GL_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_GL, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_GLIB25U_VITAL of GLIB25U is 
    for VITAL_ACT
    end for;
 end CFG_GLIB25U_VITAL;



 ---- CELL GLIB33 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GLIB33 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GLIB33 :  entity is True;
 end GLIB33;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of GLIB33 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';
	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd, A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);
	ALIAS GL_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;
	VARIABLE GL_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);
        GL_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

     VitalPathDelay01 (
	   OutSignal => GL,
	   GlitchData => GL_GlitchData,
	   OutSignalName => "GL",
	   OutTemp => GL_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_GL, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_GLIB33_VITAL of GLIB33 is 
    for VITAL_ACT
    end for;
 end CFG_GLIB33_VITAL;



 ---- CELL GLIB33U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GLIB33U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GLIB33U :  entity is True;
 end GLIB33U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of GLIB33U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';
	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd, A_ipd)


	-- functionality results
	VARIABLE PAD_ipd2 : STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);
	ALIAS GL_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;
	VARIABLE GL_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_ipd2 := VitalIdent (data => PAD_ipd,
                              ResultMap => ('U','X','0','1','H'));
        Y_zd := TO_X01(PAD_ipd2);
        GL_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

     VitalPathDelay01 (
	   OutSignal => GL,
	   GlitchData => GL_GlitchData,
	   OutSignalName => "GL",
	   OutTemp => GL_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_GL, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_GLIB33U_VITAL of GLIB33U is 
    for VITAL_ACT
    end for;
 end CFG_GLIB33U_VITAL;



 ---- CELL GLMIB25 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GLMIB25 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GLMIB25 :  entity is True;
 end GLMIB25;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of GLMIB25 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';
	SIGNAL EN_ipd  : STD_ULOGIC := 'X';
	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	VitalWireDelay (EN_ipd, EN, tipd_EN);
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd, EN_ipd, A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);
	ALIAS GL_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;
	VARIABLE GL_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);
       GL_zd :=  VitalMUX2( PAD_ipd , A_ipd , (NOT EN_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

     VitalPathDelay01 (
	   OutSignal => GL,
	   GlitchData => GL_GlitchData,
	   OutSignalName => "GL",
	   OutTemp => GL_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_GL, true),
	             1 => (EN_ipd'last_event,tpd_EN_GL, true),
	             2 => (A_ipd'last_event,tpd_A_GL, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_GLMIB25_VITAL of GLMIB25 is 
    for VITAL_ACT
    end for;
 end CFG_GLMIB25_VITAL;



 ---- CELL GLMIB33 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GLMIB33 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GLMIB33 :  entity is True;
 end GLMIB33;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of GLMIB33 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';
	SIGNAL EN_ipd  : STD_ULOGIC := 'X';
	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	VitalWireDelay (EN_ipd, EN, tipd_EN);
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd, EN_ipd, A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);
	ALIAS GL_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;
	VARIABLE GL_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);
       GL_zd :=  VitalMUX2( PAD_ipd , A_ipd , (NOT EN_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

     VitalPathDelay01 (
	   OutSignal => GL,
	   GlitchData => GL_GlitchData,
	   OutSignalName => "GL",
	   OutTemp => GL_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_GL, true),
	             1 => (EN_ipd'last_event,tpd_EN_GL, true),
	             2 => (A_ipd'last_event,tpd_A_GL, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_GLMIB33_VITAL of GLMIB33 is 
    for VITAL_ACT
    end for;
 end CFG_GLMIB33_VITAL;



 ---- CELL GLMIB25LP ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GLMIB25LP is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GLMIB25LP :  entity is True;
 end GLMIB25LP;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of GLMIB25LP is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';
	SIGNAL EN_ipd  : STD_ULOGIC := 'X';
	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	VitalWireDelay (EN_ipd, EN, tipd_EN);
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd, EN_ipd, A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);
	ALIAS GL_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;
	VARIABLE GL_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);
       GL_zd :=  VitalMUX2( PAD_ipd , A_ipd , (NOT EN_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

     VitalPathDelay01 (
	   OutSignal => GL,
	   GlitchData => GL_GlitchData,
	   OutSignalName => "GL",
	   OutTemp => GL_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_GL, true),
	             1 => (EN_ipd'last_event,tpd_EN_GL, true),
	             2 => (A_ipd'last_event,tpd_A_GL, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_GLMIB25LP_VITAL of GLMIB25LP is 
    for VITAL_ACT
    end for;
 end CFG_GLMIB25LP_VITAL;



 ---- CELL GLMIB25U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GLMIB25U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GLMIB25U :  entity is True;
 end GLMIB25U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of GLMIB25U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';
	SIGNAL EN_ipd  : STD_ULOGIC := 'X';
	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	VitalWireDelay (EN_ipd, EN, tipd_EN);
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd, EN_ipd, A_ipd)


	-- functionality results
	VARIABLE PAD_ipd2 : STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);
	ALIAS GL_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;
	VARIABLE GL_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_ipd2 := VitalIdent (data => PAD_ipd,
                              ResultMap => ('U','X','0','1','H'));
        Y_zd := TO_X01(PAD_ipd2);
       GL_zd :=  VitalMUX2( PAD_ipd , A_ipd , (NOT EN_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

     VitalPathDelay01 (
	   OutSignal => GL,
	   GlitchData => GL_GlitchData,
	   OutSignalName => "GL",
	   OutTemp => GL_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_GL, true),
	             1 => (EN_ipd'last_event,tpd_EN_GL, true),
	             2 => (A_ipd'last_event,tpd_A_GL, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_GLMIB25U_VITAL of GLMIB25U is 
    for VITAL_ACT
    end for;
 end CFG_GLMIB25U_VITAL;



 ---- CELL GLMIB33U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GLMIB33U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: String :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_GL		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		GL		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GLMIB33U :  entity is True;
 end GLMIB33U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a500k;
use a500k.VTABLES.all;

architecture VITAL_ACT of GLMIB33U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is True;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';
	SIGNAL EN_ipd  : STD_ULOGIC := 'X';
	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	VitalWireDelay (EN_ipd, EN, tipd_EN);
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd, EN_ipd, A_ipd)


	-- functionality results
	VARIABLE PAD_ipd2 : STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);
	ALIAS GL_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;
	VARIABLE GL_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_ipd2 := VitalIdent (data => PAD_ipd,
                              ResultMap => ('U','X','0','1','H'));
        Y_zd := TO_X01(PAD_ipd2);
       GL_zd :=  VitalMUX2( PAD_ipd , A_ipd , (NOT EN_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

     VitalPathDelay01 (
	   OutSignal => GL,
	   GlitchData => GL_GlitchData,
	   OutSignalName => "GL",
	   OutTemp => GL_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_GL, true),
	             1 => (EN_ipd'last_event,tpd_EN_GL, true),
	             2 => (A_ipd'last_event,t